/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3.persistence;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Primitives;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import org.bukkit.craftbukkit.v1_20_R3.persistence.CraftPersistentDataContainer;
import org.bukkit.persistence.ListPersistentDataType;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public final class CraftPersistentDataTypeRegistry {
    private final Function<Class, TagAdapter> CREATE_ADAPTER = this::createAdapter;
    private final Map<Class, TagAdapter> adapters = new ConcurrentHashMap<Class, TagAdapter>();

    private <T> TagAdapter createAdapter(Class<T> type) {
        if (!Primitives.isWrapperType(type)) {
            type = Primitives.wrap(type);
        }
        if (Objects.equals(Byte.class, type)) {
            return this.createAdapter(Byte.class, NBTTagByte.class, (byte)1, NBTTagByte::a, NBTTagByte::i);
        }
        if (Objects.equals(Short.class, type)) {
            return this.createAdapter(Short.class, NBTTagShort.class, (byte)2, NBTTagShort::a, NBTTagShort::h);
        }
        if (Objects.equals(Integer.class, type)) {
            return this.createAdapter(Integer.class, NBTTagInt.class, (byte)3, NBTTagInt::a, NBTTagInt::g);
        }
        if (Objects.equals(Long.class, type)) {
            return this.createAdapter(Long.class, NBTTagLong.class, (byte)4, NBTTagLong::a, NBTTagLong::f);
        }
        if (Objects.equals(Float.class, type)) {
            return this.createAdapter(Float.class, NBTTagFloat.class, (byte)5, NBTTagFloat::a, NBTTagFloat::k);
        }
        if (Objects.equals(Double.class, type)) {
            return this.createAdapter(Double.class, NBTTagDouble.class, (byte)6, NBTTagDouble::a, NBTTagDouble::j);
        }
        if (Objects.equals(String.class, type)) {
            return this.createAdapter(String.class, NBTTagString.class, (byte)8, NBTTagString::a, NBTTagString::t_);
        }
        if (Objects.equals(byte[].class, type)) {
            return this.createAdapter(byte[].class, NBTTagByteArray.class, (byte)7, array -> new NBTTagByteArray(Arrays.copyOf(array, ((byte[])array).length)), n2 -> Arrays.copyOf(n2.e(), n2.size()));
        }
        if (Objects.equals(int[].class, type)) {
            return this.createAdapter(int[].class, NBTTagIntArray.class, (byte)11, array -> new NBTTagIntArray(Arrays.copyOf(array, ((int[])array).length)), n2 -> Arrays.copyOf(n2.g(), n2.size()));
        }
        if (Objects.equals(long[].class, type)) {
            return this.createAdapter(long[].class, NBTTagLongArray.class, (byte)12, array -> new NBTTagLongArray(Arrays.copyOf(array, ((long[])array).length)), n2 -> Arrays.copyOf(n2.g(), n2.size()));
        }
        if (Objects.equals(PersistentDataContainer[].class, type)) {
            return this.createAdapter(PersistentDataContainer[].class, NBTTagList.class, (byte)9, containerArray -> {
                NBTTagList list = new NBTTagList();
                for (PersistentDataContainer persistentDataContainer : containerArray) {
                    list.add(((CraftPersistentDataContainer)persistentDataContainer).toTagCompound());
                }
                return list;
            }, tag -> {
                PersistentDataContainer[] containerArray = new CraftPersistentDataContainer[tag.size()];
                for (int i2 = 0; i2 < tag.size(); ++i2) {
                    CraftPersistentDataContainer container = new CraftPersistentDataContainer(this);
                    NBTTagCompound compound = tag.a(i2);
                    for (String key : compound.e()) {
                        container.put(key, compound.c(key));
                    }
                    containerArray[i2] = container;
                }
                return containerArray;
            });
        }
        if (Objects.equals(PersistentDataContainer.class, type)) {
            return this.createAdapter(CraftPersistentDataContainer.class, NBTTagCompound.class, (byte)10, CraftPersistentDataContainer::toTagCompound, tag -> {
                CraftPersistentDataContainer container = new CraftPersistentDataContainer(this);
                for (String key : tag.e()) {
                    container.put(key, tag.c(key));
                }
                return container;
            });
        }
        if (Objects.equals(List.class, type)) {
            return this.createAdapter(List.class, NBTTagList.class, (byte)9, this::constructList, this::extractList, this::matchesListTag);
        }
        throw new IllegalArgumentException("Could not find a valid TagAdapter implementation for the requested type " + type.getSimpleName());
    }

    private <T, Z extends NBTBase> TagAdapter<T, Z> createAdapter(Class<T> primitiveType, Class<Z> nbtBaseType, byte nmsTypeByte, Function<T, Z> builder, Function<Z, T> extractor) {
        return this.createAdapter(primitiveType, nbtBaseType, nmsTypeByte, (type, t2) -> (NBTBase)builder.apply(t2), (type, z2) -> extractor.apply(z2), (type, t2) -> nbtBaseType.isInstance(t2));
    }

    private <T, Z extends NBTBase> TagAdapter<T, Z> createAdapter(Class<T> primitiveType, Class<Z> nbtBaseType, byte nmsTypeByte, BiFunction<PersistentDataType<T, ?>, T, Z> builder, BiFunction<PersistentDataType<T, ?>, Z, T> extractor, BiPredicate<PersistentDataType<T, ?>, NBTBase> matcher) {
        return new TagAdapter<T, Z>(primitiveType, nbtBaseType, nmsTypeByte, builder, extractor, matcher);
    }

    public <T> NBTBase wrap(PersistentDataType<T, ?> type, T value) {
        return this.getOrCreateAdapter(type).build(type, value);
    }

    public <T> boolean isInstanceOf(PersistentDataType<T, ?> type, NBTBase base) {
        return this.getOrCreateAdapter(type).isInstance(type, base);
    }

    @NotNull
    private <T, Z extends NBTBase> TagAdapter<T, Z> getOrCreateAdapter(@NotNull PersistentDataType<T, ?> type) {
        return this.adapters.computeIfAbsent(type.getPrimitiveType(), this.CREATE_ADAPTER);
    }

    public <T, Z extends NBTBase> T extract(PersistentDataType<T, ?> type, NBTBase tag) throws ClassCastException, IllegalArgumentException {
        Class primitiveType = type.getPrimitiveType();
        TagAdapter<T, Z> adapter = this.getOrCreateAdapter(type);
        Preconditions.checkArgument((boolean)adapter.isInstance(type, tag), (String)"The found tag instance (%s) cannot store %s", (Object)tag.getClass().getSimpleName(), (Object)primitiveType.getSimpleName());
        T foundValue = adapter.extract(type, tag);
        Preconditions.checkArgument((boolean)primitiveType.isInstance(foundValue), (String)"The found object is of the type %s. Expected type %s", (Object)foundValue.getClass().getSimpleName(), (Object)primitiveType.getSimpleName());
        return primitiveType.cast(foundValue);
    }

    private <P, T extends List<P>> NBTTagList constructList(@NotNull PersistentDataType<T, ?> type, @NotNull List<P> list) {
        Preconditions.checkArgument((boolean)(type instanceof ListPersistentDataType), (String)"The passed list cannot be written to the PDC with a %s (expected a list data type)", (Object)type.getClass().getSimpleName());
        ListPersistentDataType listPersistentDataType = (ListPersistentDataType)type;
        TagAdapter elementAdapter = this.getOrCreateAdapter(listPersistentDataType.elementType());
        ArrayList values = Lists.newArrayListWithCapacity((int)list.size());
        for (P primitiveValue : list) {
            values.add(this.wrap(listPersistentDataType.elementType(), primitiveValue));
        }
        return new NBTTagList(values, values.isEmpty() ? (byte)0 : elementAdapter.nmsTypeByte());
    }

    private <P> List<P> extractList(@NotNull PersistentDataType<P, ?> type, @NotNull NBTTagList listTag) {
        Preconditions.checkArgument((boolean)(type instanceof ListPersistentDataType), (String)"The found list tag cannot be read with a %s (expected a list data type)", (Object)type.getClass().getSimpleName());
        ListPersistentDataType listPersistentDataType = (ListPersistentDataType)type;
        ObjectArrayList output = new ObjectArrayList(listTag.size());
        for (NBTBase tag : listTag) {
            output.add(this.extract(listPersistentDataType.elementType(), tag));
        }
        return output;
    }

    private boolean matchesListTag(PersistentDataType<List, ?> type, NBTBase tag) {
        if (!(type instanceof ListPersistentDataType)) {
            return false;
        }
        ListPersistentDataType listPersistentDataType = (ListPersistentDataType)type;
        if (!(tag instanceof NBTTagList)) {
            return false;
        }
        NBTTagList listTag = (NBTTagList)tag;
        byte elementType = listTag.f();
        TagAdapter elementAdapter = this.getOrCreateAdapter(listPersistentDataType.elementType());
        return elementAdapter.nmsTypeByte() == elementType || elementType == 0;
    }

    private record TagAdapter<P, T extends NBTBase>(Class<P> primitiveType, Class<T> nbtBaseType, byte nmsTypeByte, BiFunction<PersistentDataType<P, ?>, P, T> builder, BiFunction<PersistentDataType<P, ?>, T, P> extractor, BiPredicate<PersistentDataType<P, ?>, NBTBase> matcher) {
        private P extract(PersistentDataType<P, ?> dataType, NBTBase base) {
            Preconditions.checkArgument((boolean)this.nbtBaseType.isInstance(base), (String)"The provided NBTBase was of the type %s. Expected type %s", (Object)base.getClass().getSimpleName(), (Object)this.nbtBaseType.getSimpleName());
            return this.extractor.apply(dataType, (PersistentDataType<P, ?>)((NBTBase)this.nbtBaseType.cast(base)));
        }

        private T build(PersistentDataType<P, ?> dataType, Object value) {
            Preconditions.checkArgument((boolean)this.primitiveType.isInstance(value), (String)"The provided value was of the type %s. Expected type %s", (Object)value.getClass().getSimpleName(), (Object)this.primitiveType.getSimpleName());
            return (T)((NBTBase)this.builder.apply(dataType, this.primitiveType.cast(value)));
        }

        private boolean isInstance(PersistentDataType<P, ?> persistentDataType, NBTBase base) {
            return this.matcher.test(persistentDataType, base);
        }
    }
}

