/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3.potion;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import org.bukkit.craftbukkit.v1_20_R3.potion.CraftPotionEffectType;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class CraftPotionUtil {
    private static final BiMap<PotionType, PotionType> upgradeable = ImmutableBiMap.builder().put((Object)PotionType.JUMP, (Object)PotionType.STRONG_LEAPING).put((Object)PotionType.SPEED, (Object)PotionType.STRONG_SWIFTNESS).put((Object)PotionType.INSTANT_HEAL, (Object)PotionType.STRONG_HEALING).put((Object)PotionType.INSTANT_DAMAGE, (Object)PotionType.STRONG_HARMING).put((Object)PotionType.POISON, (Object)PotionType.STRONG_POISON).put((Object)PotionType.REGEN, (Object)PotionType.STRONG_REGENERATION).put((Object)PotionType.STRENGTH, (Object)PotionType.STRONG_STRENGTH).put((Object)PotionType.SLOWNESS, (Object)PotionType.STRONG_SLOWNESS).put((Object)PotionType.TURTLE_MASTER, (Object)PotionType.STRONG_TURTLE_MASTER).build();
    private static final BiMap<PotionType, PotionType> extendable = ImmutableBiMap.builder().put((Object)PotionType.NIGHT_VISION, (Object)PotionType.LONG_NIGHT_VISION).put((Object)PotionType.INVISIBILITY, (Object)PotionType.LONG_INVISIBILITY).put((Object)PotionType.JUMP, (Object)PotionType.LONG_LEAPING).put((Object)PotionType.FIRE_RESISTANCE, (Object)PotionType.LONG_FIRE_RESISTANCE).put((Object)PotionType.SPEED, (Object)PotionType.LONG_SWIFTNESS).put((Object)PotionType.SLOWNESS, (Object)PotionType.LONG_SLOWNESS).put((Object)PotionType.WATER_BREATHING, (Object)PotionType.LONG_WATER_BREATHING).put((Object)PotionType.POISON, (Object)PotionType.LONG_POISON).put((Object)PotionType.REGEN, (Object)PotionType.LONG_REGENERATION).put((Object)PotionType.STRENGTH, (Object)PotionType.LONG_STRENGTH).put((Object)PotionType.WEAKNESS, (Object)PotionType.LONG_WEAKNESS).put((Object)PotionType.TURTLE_MASTER, (Object)PotionType.LONG_TURTLE_MASTER).put((Object)PotionType.SLOW_FALLING, (Object)PotionType.LONG_SLOW_FALLING).build();

    public static PotionType fromBukkit(PotionData data) {
        PotionType type = data.isUpgraded() ? (PotionType)upgradeable.get((Object)data.getType()) : (data.isExtended() ? (PotionType)extendable.get((Object)data.getType()) : data.getType());
        Preconditions.checkNotNull((Object)type, (Object)("Unknown potion type from data " + data));
        return type;
    }

    public static PotionData toBukkit(PotionType type) {
        if (type == null) {
            return new PotionData(PotionType.UNCRAFTABLE, false, false);
        }
        PotionType potionType = (PotionType)extendable.inverse().get((Object)type);
        if (potionType != null) {
            return new PotionData(potionType, true, false);
        }
        potionType = (PotionType)upgradeable.inverse().get((Object)type);
        if (potionType != null) {
            return new PotionData(potionType, false, true);
        }
        return new PotionData(type, false, false);
    }

    public static MobEffect fromBukkit(PotionEffect effect) {
        MobEffectList type = CraftPotionEffectType.bukkitToMinecraft(effect.getType());
        return new MobEffect(type, effect.getDuration(), effect.getAmplifier(), effect.isAmbient(), effect.hasParticles(), effect.hasIcon());
    }

    public static PotionEffect toBukkit(MobEffect effect) {
        PotionEffectType type = CraftPotionEffectType.minecraftToBukkit(effect.c());
        int amp = effect.e();
        int duration = effect.d();
        boolean ambient = effect.f();
        boolean particles = effect.g();
        return new PotionEffect(type, duration, amp, ambient, particles, effect.h(), effect.q == null ? null : CraftPotionUtil.toBukkit(effect.q));
    }

    public static boolean equals(MobEffectList mobEffect, PotionEffectType type) {
        PotionEffectType typeV = CraftPotionEffectType.minecraftToBukkit(mobEffect);
        return typeV.equals(type);
    }
}

