/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.packet.bytebuf;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.leavesmc.leaves.packet.Packet;
import org.leavesmc.leaves.packet.PacketType;
import org.leavesmc.leaves.packet.WrappedPacket;
import org.leavesmc.leaves.packet.bytebuf.Bytebuf;

public class WrappedBytebuf
implements Bytebuf {
    private final PacketDataSerializer friendlyByteBuf;

    public WrappedBytebuf() {
        this(256);
    }

    public WrappedBytebuf(int initialCapacity) {
        this.friendlyByteBuf = new PacketDataSerializer(Unpooled.buffer((int)initialCapacity));
    }

    public Packet toPacket(PacketType type) {
        return new WrappedPacket(type, this);
    }

    public Bytebuf writeByte(int i2) {
        this.friendlyByteBuf.k(i2);
        return this;
    }

    public Bytebuf writeBoolean(boolean flag) {
        this.friendlyByteBuf.a(flag);
        return this;
    }

    public Bytebuf writeFloat(float f2) {
        this.friendlyByteBuf.a(f2);
        return this;
    }

    public Bytebuf writeInt(int i2) {
        this.friendlyByteBuf.p(i2);
        return this;
    }

    public Bytebuf writeShort(int i2) {
        this.friendlyByteBuf.l(i2);
        return this;
    }

    public Bytebuf writeLong(long i2) {
        this.friendlyByteBuf.b(i2);
        return this;
    }

    public Bytebuf writeVarInt(int value) {
        this.friendlyByteBuf.c(value);
        return this;
    }

    public Bytebuf writeUUID(UUID uuid) {
        return null;
    }

    public Bytebuf writeVarLong(long value) {
        this.friendlyByteBuf.a(value);
        return this;
    }

    public Bytebuf writeStringNbt(String nbt) {
        try {
            NBTTagCompound tag = MojangsonParser.a(nbt);
            this.friendlyByteBuf.a(tag);
        }
        catch (CommandSyntaxException e2) {
            throw new IllegalArgumentException(e2);
        }
        return this;
    }

    public Bytebuf writeStringComponent(String component) {
        try {
            this.friendlyByteBuf.a(IChatBaseComponent.ChatSerializer.a(component));
        }
        catch (Exception e2) {
            throw new IllegalArgumentException(e2);
        }
        return this;
    }

    public Bytebuf writeItem(ItemStack itemStack) {
        this.friendlyByteBuf.a(((CraftItemStack)itemStack).handle);
        return this;
    }

    public PacketDataSerializer getFriendlyByteBuf() {
        return this.friendlyByteBuf;
    }
}

