/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Locale;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.event.player.PlayerKickEvent;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.SpigotConfig;
import org.spigotmc.WatchdogThread;

public class RestartCommand
extends Command {
    public RestartCommand(String name) {
        super(name);
        this.description = "Restarts the server";
        this.usageMessage = "/restart";
        this.setPermission("bukkit.command.restart");
    }

    public boolean execute(CommandSender sender, String currentAlias, String[] args) {
        if (this.testPermission(sender)) {
            MinecraftServer.getServer().processQueue.add(new Runnable(){

                @Override
                public void run() {
                    RestartCommand.restart();
                }
            });
        }
        return true;
    }

    public static void restart() {
        RestartCommand.restart(SpigotConfig.restartScript);
    }

    private static void restart(String restartScript) {
        AsyncCatcher.enabled = false;
        try {
            boolean isRestarting = RestartCommand.addShutdownHook(restartScript);
            if (isRestarting) {
                System.out.println("Attempting to restart with " + SpigotConfig.restartScript);
            } else {
                System.out.println("Startup script '" + SpigotConfig.restartScript + "' does not exist! Stopping server.");
            }
            WatchdogThread.doStop();
            RestartCommand.shutdownServer(isRestarting);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void shutdownServer(boolean isRestarting) {
        if (MinecraftServer.getServer().bq()) {
            for (EntityPlayer p2 : ImmutableList.copyOf(MinecraftServer.getServer().ae().l)) {
                p2.c.disconnect(SpigotConfig.restartMessage, PlayerKickEvent.Cause.RESTART_COMMAND);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            RestartCommand.closeSocket();
            try {
                MinecraftServer.getServer().close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.exit(0);
        } else {
            MinecraftServer.getServer().safeShutdown(false, isRestarting);
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (MinecraftServer.getServer().ad()) {
                return;
            }
            RestartCommand.closeSocket();
            System.exit(0);
        }
    }

    private static void closeSocket() {
        MinecraftServer.getServer().af().b();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static boolean addShutdownHook(final String restartScript) {
        String[] split = restartScript.split(" ");
        if (split.length > 0 && new File(split[0]).isFile()) {
            Thread shutdownHook = new Thread(){

                @Override
                public void run() {
                    try {
                        String os = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
                        if (os.contains("win")) {
                            Runtime.getRuntime().exec("cmd /c start " + restartScript);
                        } else {
                            Runtime.getRuntime().exec("sh " + restartScript);
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            };
            shutdownHook.setDaemon(true);
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            return true;
        }
        return false;
    }
}

