/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves;

import com.destroystokyo.paper.util.SneakyThrow;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.logging.Level;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.configuration.file.YamlConfiguration;
import top.leavesmc.leaves.LeavesLogger;
import top.leavesmc.leaves.bot.BotCommand;
import top.leavesmc.leaves.bot.agent.Actions;
import top.leavesmc.leaves.command.LeavesCommand;
import top.leavesmc.leaves.command.NoBlockUpdateCommand;
import top.leavesmc.leaves.config.ConfigVerify;
import top.leavesmc.leaves.config.GlobalConfig;
import top.leavesmc.leaves.config.GlobalConfigManager;
import top.leavesmc.leaves.config.RemovedConfig;
import top.leavesmc.leaves.profile.LeavesMinecraftSessionService;
import top.leavesmc.leaves.protocol.CarpetServerProtocol;
import top.leavesmc.leaves.protocol.bladeren.BladerenProtocol;
import top.leavesmc.leaves.protocol.syncmatica.SyncmaticaProtocol;
import top.leavesmc.leaves.region.RegionFileFormat;
import top.leavesmc.leaves.util.LeavesUpdateHelper;
import top.leavesmc.leaves.util.MathUtils;
import top.leavesmc.leaves.util.McTechnicalModeHelper;
import top.leavesmc.leaves.util.VillagerInfiniteDiscountHelper;

public final class LeavesConfig {
    public static final String CONFIG_HEADER = "Configuration file for Leaves.";
    public static final int CURRENT_CONFIG_VERSION = 5;
    private static File configFile;
    public static YamlConfiguration config;
    private static int configVersion;
    public static boolean createWorldSections;
    @GlobalConfig(name="enable", category={"modify", "fakeplayer"}, verify=FakeplayerVerify.class)
    public static boolean fakeplayerSupport;
    @GlobalConfig(name="unable-fakeplayer-names", category={"modify", "fakeplayer"}, verify=ConfigVerify.ListConfigVerify.class)
    public static List<String> unableFakeplayerNames;
    @GlobalConfig(name="limit", category={"modify", "fakeplayer"}, verify=ConfigVerify.IntConfigVerify.class)
    public static int fakeplayerLimit;
    @GlobalConfig(name="prefix", category={"modify", "fakeplayer"}, verify=ConfigVerify.StringConfigVerify.class)
    public static String fakeplayerPrefix;
    @GlobalConfig(name="suffix", category={"modify", "fakeplayer"}, verify=ConfigVerify.StringConfigVerify.class)
    public static String fakeplayerSuffix;
    @GlobalConfig(name="always-send-data", category={"modify", "fakeplayer"})
    public static boolean alwaysSendFakeplayerData;
    @GlobalConfig(name="resident-fakeplayer", category={"modify", "fakeplayer"})
    public static boolean fakeplayerResident;
    @GlobalConfig(name="open-fakeplayer-inventory", category={"modify", "fakeplayer"})
    public static boolean openFakeplayerInventory;
    @GlobalConfig(name="skip-sleep-check", category={"modify", "fakeplayer"})
    public static boolean fakeplayerSkipSleep;
    @GlobalConfig(name="spawn-phantom", category={"modify", "fakeplayer"})
    public static boolean fakeplayerSpawnPhantom;
    @GlobalConfig(name="regen-amount", category={"modify", "fakeplayer"}, verify=RegenAmountVerify.class)
    public static double fakeplayerRegenAmount;
    @GlobalConfig(name="use-action", category={"modify", "fakeplayer"})
    public static boolean fakeplayerUseAction;
    @GlobalConfig(name="modify-config", category={"modify", "fakeplayer"})
    public static boolean fakeplayerModifyConfig;
    @GlobalConfig(name="shears-in-dispenser-can-zero-amount", category={"modify", "minecraft-old"})
    public static boolean shearsInDispenserCanZeroAmount;
    @GlobalConfig(name="instant-block-updater-reintroduced", category={"modify", "minecraft-old"}, lock=true)
    public static boolean instantBlockUpdaterReintroduced;
    @GlobalConfig(name="armor-stand-cant-kill-by-mob-projectile", category={"modify", "minecraft-old"})
    public static boolean armorStandCantKillByMobProjectile;
    @GlobalConfig(name="cce-update-suppression", category={"modify", "minecraft-old"})
    public static boolean cceUpdateSuppression;
    @GlobalConfig(name="villager-infinite-discounts", category={"modify", "minecraft-old"}, verify=VillagerInfiniteDiscountsVerify.class)
    public static boolean villagerInfiniteDiscounts;
    @GlobalConfig(name="copper-bulb-1gt-delay", category={"modify", "minecraft-old"})
    public static boolean copperBulb1gt;
    @GlobalConfig(name="crafter-1gt-delay", category={"modify", "minecraft-old"})
    public static boolean crafter1gt;
    @GlobalConfig(name="redstone-wire-dont-connect-if-on-trapdoor", category={"modify", "minecraft-old"})
    public static boolean redstoneDontCantOnTrapDoor;
    @GlobalConfig(name="mending-compatibility-infinity", category={"modify", "minecraft-old"})
    public static boolean mendingCompatibilityInfinity;
    @GlobalConfig(name="zero-tick-plants", category={"modify", "minecraft-old"})
    public static boolean zeroTickPlants;
    @RemovedConfig(name="loot-world-random", category={"modify", "minecraft-old"}, transform=true)
    @GlobalConfig(name="rng-fishing", category={"modify", "minecraft-old"}, lock=true, verify=RNGFishingVerify.class)
    public static boolean rngFishing;
    @GlobalConfig(name="protection-stacking", category={"modify", "minecraft-old"})
    public static boolean protectionStacking;
    @GlobalConfig(name="no-chunk-load", category={"modify", "elytra-aeronautics"})
    public static boolean elytraAeronauticsNoChunk;
    @GlobalConfig(name="no-chunk-height", category={"modify", "elytra-aeronautics"}, verify=ConfigVerify.DoubleConfigVerify.class)
    public static double elytraAeronauticsNoChunkHeight;
    @GlobalConfig(name="no-chunk-speed", category={"modify", "elytra-aeronautics"}, verify=ConfigVerify.DoubleConfigVerify.class)
    public static double elytraAeronauticsNoChunkSpeed;
    @GlobalConfig(name="message", category={"modify", "elytra-aeronautics"})
    public static boolean elytraAeronauticsNoChunkMes;
    @GlobalConfig(name="message-start", category={"modify", "elytra-aeronautics"}, verify=ConfigVerify.StringConfigVerify.class)
    public static String elytraAeronauticsNoChunkStartMes;
    @GlobalConfig(name="message-end", category={"modify", "elytra-aeronautics"}, verify=ConfigVerify.StringConfigVerify.class)
    public static String elytraAeronauticsNoChunkEndMes;
    @GlobalConfig(name="redstone-shears-wrench", category={"modify"})
    public static boolean redstoneShearsWrench;
    @GlobalConfig(name="budding-amethyst-can-push-by-piston", category={"modify"})
    public static boolean buddingAmethystCanPushByPiston;
    @GlobalConfig(name="spectator-dont-get-advancement", category={"modify"})
    public static boolean spectatorDontGetAdvancement;
    @GlobalConfig(name="stick-change-armorstand-arm-status", category={"modify"})
    public static boolean stickChangeArmorStandArmStatus;
    @GlobalConfig(name="snowball-and-egg-can-knockback-player", category={"modify"})
    public static boolean snowballAndEggCanKnockback;
    @GlobalConfig(name="flatten-triangular-distribution", category={"modify"})
    public static boolean flattenTriangularDistribution;
    @GlobalConfig(name="player-operation-limiter", category={"modify"})
    public static boolean playerOperationLimiter;
    @GlobalConfig(name="renewable-elytra", category={"modify"}, verify=RenewableElytraVerify.class)
    public static double renewableElytra;
    public static int shulkerBoxStackSize;
    @GlobalConfig(name="stackable-shulker-boxes", category={"modify"}, verify=StackableShulkerVerify.class)
    private static String stackableShulkerBoxes;
    @GlobalConfig(name="force-void-trade", category={"modify"})
    public static boolean forceVoidTrade;
    @GlobalConfig(name="disable-moved-wrongly-threshold", category={"modify"})
    public static boolean disableMovedWronglyThreshold;
    @GlobalConfig(name="mc-technical-survival-mode", category={"modify"}, verify=McTechnicalModeVerify.class, lock=true)
    public static boolean mcTechnicalMode;
    @GlobalConfig(name="return-nether-portal-fix", category={"modify"})
    public static boolean netherPortalFix;
    @GlobalConfig(name="use-vanilla-random", category={"modify"}, lock=true, verify=UseVanillaRandomVerify.class)
    public static boolean useVanillaRandom;
    @GlobalConfig(name="fix-update-suppression-crash", category={"modify"})
    public static boolean updateSuppressionCrashFix;
    @GlobalConfig(name="bedrock-break-list", category={"modify"}, lock=true)
    public static boolean bedrockBreakList;
    @GlobalConfig(name="disable-distance-check-for-use-item", category={"modify"})
    public static boolean disableDistanceCheckForUseItem;
    @GlobalConfig(name="no-feather-falling-trample", category={"modify"})
    public static boolean noFeatherFallingTrample;
    @GlobalConfig(name="shared-villager-discounts", category={"modify"})
    public static boolean sharedVillagerDiscounts;
    @GlobalConfig(name="disable-check-out-of-order-command", category={"modify"})
    public static boolean disableCheckOutOfOrderCommand;
    @GlobalConfig(name="despawn-enderman-with-block", category={"modify"})
    public static boolean despawnEndermanWithBlock;
    @GlobalConfig(name="creative-no-clip", category={"modify"}, verify=CreativeNoClipVerify.class)
    public static boolean creativeNoClip;
    @GlobalConfig(name="shave-snow-layers", category={"modify"})
    public static boolean shaveSnowLayers;
    @GlobalConfig(name="ignore-lc", category={"modify"})
    public static boolean ignoreLC;
    @GlobalConfig(name="disable-packet-limit", category={"modify"})
    public static boolean disablePacketLimit;
    @GlobalConfig(name="lava-riptide", category={"modify"}, verify=LavaRiptideVerify.class)
    public static boolean lavaRiptide;
    @GlobalConfig(name="no-block-update-command", category={"modify"}, verify=NoBlockUpdateVerify.class)
    public static boolean noBlockUpdateCommand;
    @GlobalConfig(name="no-tnt-place-update", category={"modify"})
    public static boolean noTNTPlaceUpdate;
    @GlobalConfig(name="raider-die-skip-self-raid-check", category={"modify"})
    public static boolean skipSelfRaidCheck;
    @GlobalConfig(name="container-passthrough", category={"modify"})
    public static boolean containerPassthrough;
    @GlobalConfig(name="avoid-anvil-too-expensive", category={"modify"}, verify=AnvilNotExpensiveVerify.class)
    public static boolean avoidAnvilTooExpensive;
    @GlobalConfig(name="bow-infinity-fix", category={"modify"})
    public static boolean bowInfinityFix;
    @GlobalConfig(name="hopper-counter", category={"modify"})
    public static boolean hopperCounter;
    @GlobalConfig(name="spider-jockeys-drop-gapples", category={"modify"}, verify=JockeysDropGAppleVerify.class)
    public static double spiderJockeysDropGapples;
    @GlobalConfig(name="renewable-deepslate", category={"modify"})
    public static boolean renewableDeepslate;
    @GlobalConfig(name="renewable-sponges", category={"modify"})
    public static boolean renewableSponges;
    @GlobalConfig(name="renewable-coral", category={"modify"}, verify=RenewableCoralVerify.class)
    public static RenewableCoralType renewableCoral;
    @GlobalConfig(name="fast-resume", category={"modify"})
    public static boolean fastResume;
    @GlobalConfig(name="force-peaceful-mode", category={"modify"}, verify=ForcePeacefulModeVerify.class)
    public static int forcePeacefulMode;
    @RemovedConfig(name="tick-command", category={"modify"})
    public static boolean tickCommand;
    @GlobalConfig(name="tick-guard-lambda", category={"performance", "remove"})
    public static boolean removeTickGuardLambda;
    @GlobalConfig(name="inventory-contains-iterators", category={"performance", "remove"})
    public static boolean removeInventoryContainsIterators;
    @GlobalConfig(name="get-nearby-players-streams", category={"performance", "remove"})
    public static boolean removeGetNearPlayerStreams;
    @GlobalConfig(name="range-check-streams-and-iterators", category={"performance", "remove"})
    public static boolean removeRangeCheckStreams;
    @GlobalConfig(name="damage-lambda", category={"performance", "remove"})
    public static boolean removeDamageLambda;
    @GlobalConfig(name="optimized-dragon-respawn", category={"performance"})
    public static boolean optimizedDragonRespawn;
    @GlobalConfig(name="dont-send-useless-entity-packets", category={"performance"})
    public static boolean dontSendUselessEntityPackets;
    @GlobalConfig(name="optimize-entity-coordinate-key", category={"performance"})
    public static boolean optimizeEntityCoordinateKey;
    @GlobalConfig(name="enable-suffocation-optimization", category={"performance"})
    public static boolean enableSuffocationOptimization;
    @GlobalConfig(name="strip-raytracing-for-entity", category={"performance"})
    public static boolean entityStripRaytracing;
    @GlobalConfig(name="check-spooky-season-once-an-hour", category={"performance"})
    public static boolean checkSpookySeasonOnceAnHour;
    @GlobalConfig(name="optimize-chunk-ticking", category={"performance"}, lock=true)
    public static boolean optimizeChunkTicking;
    @GlobalConfig(name="skip-poi-find-in-vehicle", category={"performance"})
    public static boolean skipPOIFindingInVehicle;
    @GlobalConfig(name="entity-target-find-optimization", category={"performance"})
    public static boolean entityTargetFindingOptimization;
    @GlobalConfig(name="use-more-thread-unsafe-random", category={"performance"})
    public static boolean useMoreThreadUnsafeRandom;
    @GlobalConfig(name="inactive-goal-selector-disable", category={"performance"})
    public static boolean throttleInactiveGoalSelectorTick;
    @GlobalConfig(name="reduce-entity-allocations", category={"performance"})
    public static boolean reduceEntityAllocations;
    @GlobalConfig(name="cache-climb-check", category={"performance"})
    public static boolean cacheClimbCheck;
    @GlobalConfig(name="biome-temperatures-use-aging-cache", category={"performance"}, lock=true)
    public static boolean biomeTemperaturesUseAgingCache;
    @GlobalConfig(name="reduce-entity-fluid-lookup", category={"performance"})
    public static boolean reduceEntityFluidLookup;
    @GlobalConfig(name="reduce-chuck-load-and-lookup", category={"performance"})
    public static boolean reduceChuckLoadAndLookup;
    @GlobalConfig(name="improve-fluid-direction-caching", category={"performance"}, lock=true)
    public static boolean improveFluidDirectionCaching;
    @GlobalConfig(name="cache-ignite-odds", category={"performance"})
    public static boolean cacheIgniteOdds;
    @GlobalConfig(name="faster-chunk-serialization", category={"performance"})
    public static boolean fasterChunkSerialization;
    @GlobalConfig(name="optimize-world-generation-and-block-access", category={"performance"})
    public static boolean optimizeWorldGenerationAccess;
    @GlobalConfig(name="cache-world-generator-sea-level", category={"performance"})
    public static boolean cacheWorldGeneratorSeaLevel;
    @GlobalConfig(name="skip-secondary-POI-sensor-if-absent", category={"performance"})
    public static boolean skipSecondaryPOISensorIfAbsent;
    @GlobalConfig(name="cache-CubeVoxelShape-shape-array", category={"performance"})
    public static boolean cacheCubeVoxelShapeShapeArray;
    @GlobalConfig(name="store-mob-counts-in-array", category={"performance"})
    public static boolean storeMobCountsInArray;
    @GlobalConfig(name="cache-BlockStatePairKey-hash", category={"performance"})
    public static boolean cacheBlockStatePairKeyHash;
    @GlobalConfig(name="optimize-noise-generation", category={"performance"})
    public static boolean optimizeNoiseGeneration;
    @GlobalConfig(name="optimize-sun-burn-tick", category={"performance"})
    public static boolean optimizeSunBurnTick;
    @GlobalConfig(name="use-optimized-collection", category={"performance"})
    public static boolean useOptimizedCollection;
    @GlobalConfig(name="optimized-CubePointRange", category={"performance"})
    public static boolean optimizedCubePointRange;
    @GlobalConfig(name="check-frozen-ticks-before-landing-block", category={"performance"})
    public static boolean checkFrozenTicksBeforeLandingBlock;
    @GlobalConfig(name="cache-ominous-banner-item", category={"performance"})
    public static boolean cacheOminousBannerItem;
    @GlobalConfig(name="skip-entity-move-if-movement-is-zero", category={"performance"})
    public static boolean skipEntityMoveIfMovementIsZero;
    @GlobalConfig(name="skip-cloning-advancement-criteria", category={"performance"})
    public static boolean skipCloningAdvancementCriteria;
    @GlobalConfig(name="skip-negligible-planar-movement-multiplication", category={"performance"})
    public static boolean skipNegligiblePlanarMovementMultiplication;
    @GlobalConfig(name="fix-villagers-dont-release-memory", category={"performance"})
    public static boolean villagersDontReleaseMemoryFix;
    @RemovedConfig(name="async-pathfinding", category={"performance"})
    public static boolean asyncPathfinding;
    @RemovedConfig(name="async-mob-spawning", category={"performance"})
    public static boolean asyncMobSpawning;
    @RemovedConfig(name="async-entity-tracker", category={"performance"})
    public static boolean asyncEntityTracker;
    @RemovedConfig(name="fix-paper-6045", category={"performance", "fix"})
    public static boolean fixPaper6045;
    @RemovedConfig(name="fix-paper-9372", category={"performance", "fix"})
    public static boolean fixPaper9372;
    @GlobalConfig(name="protocol", category={"protocol", "bladeren"})
    public static boolean bladerenLeavesProtocol;
    @GlobalConfig(name="mspt-sync-protocol", category={"protocol", "bladeren"}, verify=MSPTSyncVerify.class)
    public static boolean msptSyncProtocol;
    @GlobalConfig(name="mspt-sync-tick-interval", category={"protocol", "bladeren"}, verify=MSPTSyncIntervalVerify.class)
    public static int msptSyncTickInterval;
    @GlobalConfig(name="enable", category={"protocol", "syncmatica"}, verify=SyncmaticaVerify.class)
    public static boolean syncmaticaProtocol;
    @GlobalConfig(name="quota", category={"protocol", "syncmatica"})
    public static boolean syncmaticaQuota;
    @GlobalConfig(name="quota-limit", category={"protocol", "syncmatica"}, verify=ConfigVerify.IntConfigVerify.class)
    public static int syncmaticaQuotaLimit;
    @GlobalConfig(name="pca-sync-protocol", category={"protocol"})
    public static boolean pcaSyncProtocol;
    @GlobalConfig(name="pca-sync-player-entity", category={"protocol"}, verify=PcaPlayerEntityVerify.class)
    public static String pcaSyncPlayerEntity;
    @GlobalConfig(name="bbor-protocol", category={"protocol"})
    public static boolean bborProtocol;
    @GlobalConfig(name="jade-protocol", category={"protocol"})
    public static boolean jadeProtocol;
    @GlobalConfig(name="alternative-block-placement", category={"protocol"}, verify=AlternativePlaceVerify.class)
    public static String alternativeBlockPlacement;
    @GlobalConfig(name="appleskin-protocol", category={"protocol"})
    public static boolean appleskinProtocol;
    @GlobalConfig(name="xaero-map-protocol", category={"protocol"})
    public static boolean xaeroMapProtocol;
    @GlobalConfig(name="xaero-map-server-id", category={"protocol"}, verify=ConfigVerify.IntConfigVerify.class)
    public static int xaeroMapServerID;
    @GlobalConfig(name="servux-protocol", category={"protocol"})
    public static boolean servuxProtocol;
    @GlobalConfig(name="leaves-carpet-support", category={"protocol"})
    public static boolean leavesCarpetSupport;
    @GlobalConfig(name="enable", category={"misc", "auto-update"}, lock=true, verify=AutoUpdateVerify.class)
    public static boolean autoUpdate;
    @GlobalConfig(name="time", category={"misc", "auto-update"}, lock=true, verify=ConfigVerify.ListConfigVerify.class)
    public static List<String> autoUpdateTime;
    @GlobalConfig(name="enable", category={"misc", "extra-yggdrasil-service"}, verify=ExtraYggdrasilVerify.class)
    public static boolean extraYggdrasilService;
    @GlobalConfig(name="login-protect", category={"misc", "extra-yggdrasil-service"})
    public static boolean extraYggdrasilLoginProtect;
    @GlobalConfig(name="urls", category={"misc", "extra-yggdrasil-service"}, verify=ExtraYggdrasilUrlsVerify.class)
    public static List<String> extraYggdrasilServiceList;
    @GlobalConfig(name="disable-method-profiler", category={"misc"})
    public static boolean disableMethodProfiler;
    @GlobalConfig(name="no-chat-sign", category={"misc"})
    public static boolean noChatSign;
    @GlobalConfig(name="dont-respond-ping-before-start-fully", category={"misc"})
    public static boolean dontRespondPingBeforeStart;
    @GlobalConfig(name="server-lang", category={"misc"}, lock=true, verify=ServerLangVerify.class)
    public static String serverLang;
    @GlobalConfig(name="server-mod-name", category={"misc"}, verify=ConfigVerify.StringConfigVerify.class)
    public static String serverModName;
    @GlobalConfig(name="bstats-privacy-mode", category={"misc"})
    public static boolean bstatsPrivacyMode;
    @GlobalConfig(name="force-minecraft-command", category={"misc"})
    public static boolean forceMinecraftCommand;
    public static RegionFileFormat regionFormatName;
    @GlobalConfig(name="format", category={"region"}, lock=true, verify=RegionFormatVerify.class)
    public static String regionFormat;
    @GlobalConfig(name="flush-frequency", category={"region", "linear"}, lock=true, verify=ConfigVerify.IntConfigVerify.class)
    public static int linearFlushFrequency;
    @GlobalConfig(name="auto-convert-anvil-to-linear", category={"region", "linear"}, lock=true)
    public static boolean autoConvertAnvilToLinear;
    @GlobalConfig(name="flush-max-threads", category={"region", "linear"}, lock=true, verify=ConfigVerify.IntConfigVerify.class)
    public static int linearFlushThreads;
    @GlobalConfig(name="compression-level", category={"region", "linear"}, lock=true, verify=LinearCompressVerify.class)
    public static int linearCompressionLevel;
    @GlobalConfig(name="crash-on-broken-symlink", category={"region", "linear"}, lock=true)
    public static boolean linearCrashOnBrokenSymlink;
    @GlobalConfig(name="vanilla-hopper", category={"fix"})
    public static boolean vanillaHopper;

    public static void init(File file) {
        configFile = file;
        config = new YamlConfiguration();
        config.options().setHeader(Collections.singletonList(CONFIG_HEADER));
        config.options().copyDefaults(true);
        if (!file.exists()) {
            try {
                boolean is = file.createNewFile();
                if (!is) {
                    throw new IOException("Can't create file");
                }
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.SEVERE, "Failure to create leaves config", ex);
            }
        } else {
            try {
                config.load(file);
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.SEVERE, "Failure to load leaves config", ex);
                SneakyThrow.sneaky((Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
        configVersion = config.getInt("config-version", 5);
        config.set("config-version", (Object)5);
        LeavesConfig.updateConfigVersion(config);
        GlobalConfigManager.init();
        LeavesConfig.registerCommand("leaves", new LeavesCommand("leaves"));
    }

    public static void save() {
        try {
            config.save(configFile);
        }
        catch (Exception ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Unable to save leaves config", ex);
        }
    }

    @Deprecated(forRemoval=true)
    private static void updateConfigVersion(YamlConfiguration config) {
        if (configVersion < 5) {
            switch (configVersion) {
                case 1: {
                    snowballAndEggCanKnockback = config.getBoolean("settings.snowball-and-egg-can-knockback-player", snowballAndEggCanKnockback);
                    fakeplayerSupport = config.getBoolean("settings.fakeplayer.enable", fakeplayerSupport);
                    unableFakeplayerNames = config.getList("settings.fakeplayer.unable-fakeplayer-names", unableFakeplayerNames);
                    shearsInDispenserCanZeroAmount = config.getBoolean("settings.shears-in-dispenser-can-zero-amount", shearsInDispenserCanZeroAmount);
                    redstoneShearsWrench = config.getBoolean("settings.redstone-shears-wrench", redstoneShearsWrench);
                    buddingAmethystCanPushByPiston = config.getBoolean("settings.budding-amethyst-can-push-by-piston", buddingAmethystCanPushByPiston);
                    spectatorDontGetAdvancement = config.getBoolean("settings.spectator-dont-get-advancement", spectatorDontGetAdvancement);
                    stickChangeArmorStandArmStatus = config.getBoolean("settings.stick-change-armorstand-arm-status", stickChangeArmorStandArmStatus);
                    noChatSign = config.getBoolean("settings.no-chat-sign", noChatSign);
                    config.set("settings.snowball-and-egg-can-knockback-player", null);
                    config.set("settings.player-can-edit-sign", null);
                    config.set("settings.fakeplayer", null);
                    config.set("settings.shears-in-dispenser-can-zero-amount", null);
                    config.set("settings.redstone-shears-wrench", null);
                    config.set("settings.budding-amethyst-can-push-by-piston", null);
                    config.set("settings.spectator-dont-get-advancement", null);
                    config.set("settings.stick-change-armorstand-arm-status", null);
                    config.set("settings.no-chat-sign", null);
                    break;
                }
                case 2: {
                    config.set("settings.modify.player-can-edit-sign", null);
                    config.set("settings.performance.skip-clone-loot-parameters", null);
                    break;
                }
                case 3: {
                    boolean carpetAlternative = config.getBoolean("settings.protocol.carpet-alternative-block-placement", false);
                    alternativeBlockPlacement = carpetAlternative ? "CARPET" : "NONE";
                    config.set("settings.protocol.carpet-alternative-block-placement", null);
                    break;
                }
                case 4: {
                    shearsInDispenserCanZeroAmount = config.getBoolean("settings.modify.shears-in-dispenser-can-zero-amount", shearsInDispenserCanZeroAmount);
                    instantBlockUpdaterReintroduced = config.getBoolean("settings.modify.instant-block-updater-reintroduced", instantBlockUpdaterReintroduced);
                    redstoneDontCantOnTrapDoor = config.getBoolean("settings.modify.redstone-wire-dont-connect-if-on-trapdoor", redstoneDontCantOnTrapDoor);
                    mendingCompatibilityInfinity = config.getBoolean("settings.modify.mending-compatibility-infinity", mendingCompatibilityInfinity);
                    zeroTickPlants = config.getBoolean("settings.modify.zero-tick-plants", zeroTickPlants);
                    config.set("settings.modify.shears-in-dispenser-can-zero-amount", null);
                    config.set("settings.modify.instant-block-updater-reintroduced", null);
                    config.set("settings.modify.redstone-wire-dont-connect-if-on-trapdoor", null);
                    config.set("settings.modify.mending-compatibility-infinity", null);
                    config.set("settings.modify.zero-tick-plants", null);
                }
            }
        }
    }

    public static void registerCommand(String name, Command command) {
        MinecraftServer.getServer().server.getCommandMap().register(name, "leaves", command);
        MinecraftServer.getServer().server.syncCommands();
    }

    public static void unregisterCommand(String name) {
        name = name.toLowerCase(Locale.ENGLISH).trim();
        MinecraftServer.getServer().server.getCommandMap().getKnownCommands().remove(name);
        MinecraftServer.getServer().server.getCommandMap().getKnownCommands().remove("leaves:" + name);
        MinecraftServer.getServer().server.syncCommands();
    }

    public static int getLinearFlushThreads() {
        if (linearFlushThreads < 0) {
            return Math.max(Runtime.getRuntime().availableProcessors() + linearFlushThreads, 1);
        }
        return Math.max(linearFlushThreads, 1);
    }

    static {
        createWorldSections = true;
        fakeplayerSupport = true;
        unableFakeplayerNames = List.of("player-name");
        fakeplayerLimit = 10;
        fakeplayerPrefix = "";
        fakeplayerSuffix = "";
        alwaysSendFakeplayerData = true;
        fakeplayerResident = false;
        openFakeplayerInventory = false;
        fakeplayerSkipSleep = false;
        fakeplayerSpawnPhantom = false;
        fakeplayerRegenAmount = 0.01;
        fakeplayerUseAction = true;
        fakeplayerModifyConfig = false;
        shearsInDispenserCanZeroAmount = false;
        instantBlockUpdaterReintroduced = false;
        armorStandCantKillByMobProjectile = false;
        cceUpdateSuppression = false;
        villagerInfiniteDiscounts = false;
        copperBulb1gt = false;
        crafter1gt = false;
        redstoneDontCantOnTrapDoor = false;
        mendingCompatibilityInfinity = false;
        zeroTickPlants = false;
        rngFishing = false;
        protectionStacking = false;
        elytraAeronauticsNoChunk = false;
        elytraAeronauticsNoChunkHeight = 500.0;
        elytraAeronauticsNoChunkSpeed = -1.0;
        elytraAeronauticsNoChunkMes = true;
        elytraAeronauticsNoChunkStartMes = "Flight enter cruise mode";
        elytraAeronauticsNoChunkEndMes = "Flight exit cruise mode";
        redstoneShearsWrench = true;
        buddingAmethystCanPushByPiston = false;
        spectatorDontGetAdvancement = false;
        stickChangeArmorStandArmStatus = true;
        snowballAndEggCanKnockback = true;
        flattenTriangularDistribution = false;
        playerOperationLimiter = false;
        renewableElytra = -1.0;
        shulkerBoxStackSize = 1;
        stackableShulkerBoxes = "false";
        forceVoidTrade = false;
        disableMovedWronglyThreshold = false;
        mcTechnicalMode = true;
        netherPortalFix = false;
        useVanillaRandom = false;
        updateSuppressionCrashFix = true;
        bedrockBreakList = false;
        disableDistanceCheckForUseItem = false;
        noFeatherFallingTrample = false;
        sharedVillagerDiscounts = false;
        disableCheckOutOfOrderCommand = false;
        despawnEndermanWithBlock = false;
        creativeNoClip = false;
        shaveSnowLayers = true;
        ignoreLC = false;
        disablePacketLimit = false;
        lavaRiptide = false;
        noBlockUpdateCommand = false;
        noTNTPlaceUpdate = false;
        skipSelfRaidCheck = false;
        containerPassthrough = false;
        avoidAnvilTooExpensive = false;
        bowInfinityFix = false;
        hopperCounter = false;
        spiderJockeysDropGapples = -1.0;
        renewableDeepslate = false;
        renewableSponges = false;
        renewableCoral = RenewableCoralType.FALSE;
        fastResume = false;
        forcePeacefulMode = -1;
        tickCommand = false;
        removeTickGuardLambda = true;
        removeInventoryContainsIterators = true;
        removeGetNearPlayerStreams = true;
        removeRangeCheckStreams = true;
        removeDamageLambda = true;
        optimizedDragonRespawn = false;
        dontSendUselessEntityPackets = true;
        optimizeEntityCoordinateKey = true;
        enableSuffocationOptimization = true;
        entityStripRaytracing = true;
        checkSpookySeasonOnceAnHour = true;
        optimizeChunkTicking = true;
        skipPOIFindingInVehicle = true;
        entityTargetFindingOptimization = true;
        useMoreThreadUnsafeRandom = true;
        throttleInactiveGoalSelectorTick = false;
        reduceEntityAllocations = true;
        cacheClimbCheck = true;
        biomeTemperaturesUseAgingCache = true;
        reduceEntityFluidLookup = true;
        reduceChuckLoadAndLookup = true;
        improveFluidDirectionCaching = true;
        cacheIgniteOdds = true;
        fasterChunkSerialization = true;
        optimizeWorldGenerationAccess = true;
        cacheWorldGeneratorSeaLevel = true;
        skipSecondaryPOISensorIfAbsent = true;
        cacheCubeVoxelShapeShapeArray = true;
        storeMobCountsInArray = true;
        cacheBlockStatePairKeyHash = true;
        optimizeNoiseGeneration = false;
        optimizeSunBurnTick = true;
        useOptimizedCollection = true;
        optimizedCubePointRange = true;
        checkFrozenTicksBeforeLandingBlock = true;
        cacheOminousBannerItem = true;
        skipEntityMoveIfMovementIsZero = true;
        skipCloningAdvancementCriteria = false;
        skipNegligiblePlanarMovementMultiplication = true;
        villagersDontReleaseMemoryFix = false;
        asyncPathfinding = false;
        asyncMobSpawning = false;
        asyncEntityTracker = false;
        fixPaper6045 = true;
        fixPaper9372 = true;
        bladerenLeavesProtocol = true;
        msptSyncProtocol = false;
        msptSyncTickInterval = 20;
        syncmaticaProtocol = false;
        syncmaticaQuota = false;
        syncmaticaQuotaLimit = 40000000;
        pcaSyncProtocol = false;
        pcaSyncPlayerEntity = "OPS";
        bborProtocol = false;
        jadeProtocol = false;
        alternativeBlockPlacement = "NONE";
        appleskinProtocol = false;
        xaeroMapProtocol = false;
        xaeroMapServerID = new Random().nextInt();
        servuxProtocol = false;
        leavesCarpetSupport = false;
        autoUpdate = false;
        autoUpdateTime = List.of("14:00", "2:00");
        extraYggdrasilService = false;
        extraYggdrasilLoginProtect = false;
        extraYggdrasilServiceList = List.of("https://url.with.authlib-injector-yggdrasil");
        disableMethodProfiler = true;
        noChatSign = true;
        dontRespondPingBeforeStart = true;
        serverLang = "en_us";
        serverModName = "Leaves";
        bstatsPrivacyMode = false;
        forceMinecraftCommand = true;
        regionFormatName = RegionFileFormat.ANVIL;
        regionFormat = "ANVIL";
        linearFlushFrequency = 10;
        autoConvertAnvilToLinear = false;
        linearFlushThreads = 1;
        linearCompressionLevel = 1;
        linearCrashOnBrokenSymlink = true;
        vanillaHopper = false;
    }

    public static enum RenewableCoralType {
        FALSE,
        TRUE,
        EXPANDED;

    }

    private static class LinearCompressVerify
    extends ConfigVerify.IntConfigVerify {
        private LinearCompressVerify() {
        }

        @Override
        public String check(Integer old, Integer value) {
            if (value < 1 || value > 22) {
                return "linear.compression-level need between 1 and 22";
            }
            return null;
        }
    }

    private static class RegionFormatVerify
    extends ConfigVerify.StringConfigVerify {
        private RegionFormatVerify() {
        }

        @Override
        public String check(String old, String value) {
            RegionFileFormat format = RegionFileFormat.fromString(value);
            if (format == RegionFileFormat.INVALID) {
                return "Unknown region format " + value;
            }
            regionFormatName = format;
            return null;
        }
    }

    private static class ServerLangVerify
    extends ConfigVerify.StringConfigVerify {
        private static final List<String> supportLang = List.of("en_us", "zh_cn");

        private ServerLangVerify() {
        }

        @Override
        public String check(String old, String value) {
            if (!supportLang.contains(value)) {
                return "server-lang value error";
            }
            return null;
        }
    }

    public static class ExtraYggdrasilUrlsVerify
    extends ConfigVerify.ListConfigVerify {
        @Override
        public String check(List<?> old, List<?> value) {
            LeavesMinecraftSessionService.initExtraYggdrasilList();
            return null;
        }
    }

    public static class ExtraYggdrasilVerify
    extends ConfigVerify.BooleanConfigVerify {
        @Override
        public String check(Boolean old, Boolean value) {
            if (value.booleanValue()) {
                LeavesLogger.LOGGER.warning("extra-yggdrasil-service is an unofficial support. Enabling it may cause data security problems!");
                GlobalConfiguration.get().unsupportedSettings.performUsernameValidation = true;
            }
            return null;
        }
    }

    private static class AutoUpdateVerify
    extends ConfigVerify.BooleanConfigVerify {
        private AutoUpdateVerify() {
        }

        @Override
        public void runAfterLoader(Boolean value) {
            LeavesUpdateHelper.init();
            if (value.booleanValue()) {
                LeavesLogger.LOGGER.warning("Auto-Update is not completely safe. Enabling it may cause data security problems!");
            }
        }
    }

    private static class AlternativePlaceVerify
    extends ConfigVerify.StringConfigVerify {
        private static final List<String> alternativeBlockPlacementType = List.of("NONE", "CARPET", "CARPET_FIX", "LITEMATICA");

        private AlternativePlaceVerify() {
        }

        @Override
        public String check(String old, String value) {
            if (!alternativeBlockPlacementType.contains(value)) {
                return "alternative-block-placement value error";
            }
            return null;
        }
    }

    private static class PcaPlayerEntityVerify
    extends ConfigVerify.StringConfigVerify {
        private static final List<String> pcaSyncPlayerEntityList = List.of("NOBODY", "BOT", "OPS", "OPS_AND_SELF", "EVERYONE");

        private PcaPlayerEntityVerify() {
        }

        @Override
        public String check(String old, String value) {
            if (!pcaSyncPlayerEntityList.contains(value)) {
                return "pca-sync-player-entity value error";
            }
            return null;
        }
    }

    public static class SyncmaticaVerify
    extends ConfigVerify.BooleanConfigVerify {
        @Override
        public String check(Boolean old, Boolean value) {
            if (value.booleanValue()) {
                SyncmaticaProtocol.init();
            }
            return null;
        }
    }

    private static class MSPTSyncIntervalVerify
    extends ConfigVerify.IntConfigVerify {
        private MSPTSyncIntervalVerify() {
        }

        @Override
        public String check(Integer old, Integer value) {
            return value > 0 ? null : "mspt-sync-tick-interval need > 0";
        }
    }

    private static class MSPTSyncVerify
    extends ConfigVerify.BooleanConfigVerify {
        private MSPTSyncVerify() {
        }

        @Override
        public String check(Boolean old, Boolean value) {
            BladerenProtocol.LeavesFeatureSet.register(BladerenProtocol.LeavesFeature.of("mspt_sync", value));
            return null;
        }
    }

    private static class ForcePeacefulModeVerify
    extends ConfigVerify.IntConfigVerify {
        private ForcePeacefulModeVerify() {
        }

        @Override
        public String check(Integer old, Integer value) {
            for (WorldServer level : MinecraftServer.getServer().H()) {
                level.I.peacefulModeSwitchTick = value;
            }
            return null;
        }
    }

    private static class RenewableCoralVerify
    extends ConfigVerify.EnumConfigVerify<RenewableCoralType> {
        private RenewableCoralVerify() {
        }

        @Override
        public String check(Enum<RenewableCoralType> old, Enum<RenewableCoralType> value) {
            CarpetServerProtocol.CarpetRules.register(CarpetServerProtocol.CarpetRule.of("carpet", "renewableCoral", value));
            return null;
        }
    }

    private static class JockeysDropGAppleVerify
    extends ConfigVerify.DoubleConfigVerify {
        private JockeysDropGAppleVerify() {
        }

        @Override
        public String check(Double old, Double value) {
            return value <= 1.0 ? null : "spider-jockeys-drop-gapples need <= 1.0f";
        }
    }

    private static class AnvilNotExpensiveVerify
    extends ConfigVerify.BooleanConfigVerify {
        private AnvilNotExpensiveVerify() {
        }

        @Override
        public String check(Boolean old, Boolean value) {
            CarpetServerProtocol.CarpetRules.register(CarpetServerProtocol.CarpetRule.of("pca", "avoidAnvilTooExpensive", value));
            return null;
        }
    }

    private static class NoBlockUpdateVerify
    extends ConfigVerify.BooleanConfigVerify {
        private NoBlockUpdateVerify() {
        }

        @Override
        public String check(Boolean old, Boolean value) {
            if (value.booleanValue()) {
                LeavesConfig.registerCommand("blockupdate", new NoBlockUpdateCommand("blockupdate"));
            } else {
                LeavesConfig.unregisterCommand("blockupdate");
            }
            return null;
        }
    }

    private static class LavaRiptideVerify
    extends ConfigVerify.BooleanConfigVerify {
        private LavaRiptideVerify() {
        }

        @Override
        public String check(Boolean old, Boolean value) {
            BladerenProtocol.LeavesFeatureSet.register(BladerenProtocol.LeavesFeature.of("lava_riptide", value));
            return null;
        }
    }

    private static class CreativeNoClipVerify
    extends ConfigVerify.BooleanConfigVerify {
        private CreativeNoClipVerify() {
        }

        @Override
        public String check(Boolean old, Boolean value) {
            CarpetServerProtocol.CarpetRules.register(CarpetServerProtocol.CarpetRule.of("carpet", "creativeNoClip", value));
            return null;
        }
    }

    private static class UseVanillaRandomVerify
    extends ConfigVerify.BooleanConfigVerify {
        private UseVanillaRandomVerify() {
        }

        @Override
        public String check(Boolean old, Boolean value) {
            BladerenProtocol.LeavesFeatureSet.register(BladerenProtocol.LeavesFeature.of("use_vanilla_random", value));
            return null;
        }
    }

    private static class McTechnicalModeVerify
    extends ConfigVerify.BooleanConfigVerify {
        private McTechnicalModeVerify() {
        }

        @Override
        public String check(Boolean old, Boolean value) {
            if (value.booleanValue()) {
                McTechnicalModeHelper.doMcTechnicalMode();
            }
            return null;
        }
    }

    private static class StackableShulkerVerify
    extends ConfigVerify.StringConfigVerify {
        private StackableShulkerVerify() {
        }

        @Override
        public String check(String old, String value) {
            String realValue = MathUtils.isNumeric(value) ? value : (value.equals("true") ? "2" : "1");
            shulkerBoxStackSize = Integer.parseInt(realValue);
            return null;
        }
    }

    private static class RenewableElytraVerify
    extends ConfigVerify.DoubleConfigVerify {
        private RenewableElytraVerify() {
        }

        @Override
        public String check(Double old, Double value) {
            return value <= 1.0 ? null : "renewable-elytra need <= 1.0f";
        }
    }

    private static class RNGFishingVerify
    extends ConfigVerify.BooleanConfigVerify {
        private RNGFishingVerify() {
        }

        @Override
        public String check(Boolean old, Boolean value) {
            BladerenProtocol.LeavesFeatureSet.register(BladerenProtocol.LeavesFeature.of("rng_fishing", value));
            return null;
        }
    }

    private static class VillagerInfiniteDiscountsVerify
    extends ConfigVerify.BooleanConfigVerify {
        private VillagerInfiniteDiscountsVerify() {
        }

        @Override
        public String check(Boolean old, Boolean value) {
            VillagerInfiniteDiscountHelper.doVillagerInfiniteDiscount(value);
            return null;
        }
    }

    private static class RegenAmountVerify
    extends ConfigVerify.DoubleConfigVerify {
        private RegenAmountVerify() {
        }

        @Override
        public String check(Double old, Double value) {
            return value > 0.0 ? null : "regen-amount need > 0.0f";
        }
    }

    private static class FakeplayerVerify
    extends ConfigVerify.BooleanConfigVerify {
        private FakeplayerVerify() {
        }

        @Override
        public String check(Boolean old, Boolean value) {
            if (value.booleanValue()) {
                LeavesConfig.registerCommand("bot", new BotCommand("bot"));
                Actions.registerAll();
            } else {
                LeavesConfig.unregisterCommand("bot");
            }
            return null;
        }
    }
}

