/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.bot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.generator.WorldInfo;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.bot.ServerBot;
import top.leavesmc.leaves.bot.agent.Actions;
import top.leavesmc.leaves.bot.agent.BotAction;
import top.leavesmc.leaves.bot.agent.actions.CraftCustomBotAction;
import top.leavesmc.leaves.entity.Bot;
import top.leavesmc.leaves.event.bot.BotActionEvent;
import top.leavesmc.leaves.event.bot.BotConfigModifyEvent;

public class BotCommand
extends Command {
    private static final List<String> acceptConfig = Stream.of(BotConfig.values()).map(config -> config.configName).toList();

    public BotCommand(String name) {
        super(name);
        this.description = "FakePlayer Command";
        this.usageMessage = "/bot [create | remove | action | list | config]";
        this.setPermission("bukkit.command.bot");
        PluginManager pluginManager = Bukkit.getServer().getPluginManager();
        if (pluginManager.getPermission("bukkit.command.bot") == null) {
            pluginManager.addPermission(new Permission("bukkit.command.bot", PermissionDefault.OP));
        }
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, String @NotNull [] args, Location location) throws IllegalArgumentException {
        BotAction action;
        ArrayList<String> list = new ArrayList<String>();
        if (args.length <= 1) {
            list.add("create");
            list.add("remove");
            if (LeavesConfig.fakeplayerUseAction) {
                list.add("action");
            }
            if (LeavesConfig.fakeplayerModifyConfig) {
                list.add("config");
            }
            list.add("list");
        }
        if (args.length == 2) {
            switch (args[0]) {
                case "create": {
                    list.add("<BotName>");
                    break;
                }
                case "remove": 
                case "action": 
                case "config": {
                    list.addAll(ServerBot.getBots().stream().map(e2 -> e2.ad().getString()).toList());
                    break;
                }
                case "list": {
                    list.addAll(Bukkit.getWorlds().stream().map(WorldInfo::getName).toList());
                }
            }
        }
        if (args.length == 3) {
            switch (args[0]) {
                case "action": {
                    list.add("list");
                    list.addAll(Actions.getNames());
                    break;
                }
                case "create": {
                    list.add("<BotSkinName>");
                    break;
                }
                case "config": {
                    list.addAll(acceptConfig);
                }
            }
        }
        if (args.length == 4) {
            switch (args[0]) {
                case "config": {
                    if (args[2].equals(BotConfig.SIMULATION_DISTANCE.configName)) {
                        list.add("10");
                        list.add("2");
                        list.add("<INT 2 - 32>");
                        break;
                    }
                    list.add("true");
                    list.add("false");
                }
            }
        }
        if (args.length >= 4 && args[0].equals("action") && (action = Actions.getForName(args[2])) != null) {
            list.addAll(action.getArgument().tabComplete(args.length - 4));
        }
        return list;
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, String[] args) {
        if (!this.testPermission(sender) || !LeavesConfig.fakeplayerSupport) {
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(ChatColor.RED + "Usage: " + this.usageMessage);
            return false;
        }
        switch (args[0]) {
            case "create": {
                this.onCreate(sender, args);
                break;
            }
            case "remove": {
                this.onRemove(sender, args);
                break;
            }
            case "action": {
                this.onAction(sender, args);
                break;
            }
            case "config": {
                this.onConfig(sender, args);
                break;
            }
            case "list": {
                this.onList(sender, args);
                break;
            }
            default: {
                sender.sendMessage(ChatColor.RED + "Usage: " + this.usageMessage);
                return false;
            }
        }
        return true;
    }

    private void onCreate(CommandSender sender, String @NotNull [] args) {
        if (args.length < 2) {
            sender.sendMessage(ChatColor.RED + "Use /bot create <name> [skin_name] to create a fakeplayer");
            return;
        }
        if (this.canCreate(sender, args[1])) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                new ServerBot.BotCreateState(player.getLocation(), args[1], args.length < 3 ? args[1] : args[2]).createAsync(bot -> {
                    bot.createPlayer = player.getUniqueId();
                });
            } else if (sender instanceof ConsoleCommandSender) {
                if (args.length < 6) {
                    sender.sendMessage(ChatColor.RED + "Use /bot create <name> <skin_name> <bukkit_world_name> <x> <y> <z> to create a fakeplayer");
                    return;
                }
                try {
                    World world = Bukkit.getWorld((String)args[3]);
                    double x2 = Double.parseDouble(args[4]);
                    double y2 = Double.parseDouble(args[5]);
                    double z2 = Double.parseDouble(args[6]);
                    if (world != null) {
                        new ServerBot.BotCreateState(new Location(world, x2, y2, z2), args[1], args[2]).createAsync(null);
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    private boolean canCreate(CommandSender sender, @NotNull String name) {
        if (!name.matches("^[a-zA-Z0-9_]{4,16}$")) {
            sender.sendMessage(ChatColor.RED + "This name is illegal");
            return false;
        }
        if (Bukkit.getPlayerExact((String)name) != null || ServerBot.getBot(name) != null) {
            sender.sendMessage(ChatColor.RED + "This player is in server");
            return false;
        }
        if (LeavesConfig.unableFakeplayerNames.contains(name)) {
            sender.sendMessage(ChatColor.RED + "This name is not allowed");
            return false;
        }
        if (ServerBot.getBots().size() >= LeavesConfig.fakeplayerLimit) {
            sender.sendMessage(ChatColor.RED + "Fakeplayer limit is full");
            return false;
        }
        return true;
    }

    private void onRemove(CommandSender sender, String @NotNull [] args) {
        if (args.length < 2) {
            sender.sendMessage(ChatColor.RED + "Use /bot remove <name> to remove a fakeplayer");
            return;
        }
        ServerBot bot = ServerBot.getBot(args[1]);
        if (bot == null) {
            sender.sendMessage(ChatColor.RED + "This fakeplayer is not in server");
            return;
        }
        bot.a(bot.dN().m());
    }

    private void onAction(CommandSender sender, String @NotNull [] args) {
        BotAction newAction;
        if (!LeavesConfig.fakeplayerUseAction) {
            return;
        }
        if (args.length < 3) {
            sender.sendMessage(ChatColor.RED + "Use /bot action <name> <action> to make fakeplayer do action");
            return;
        }
        ServerBot bot = ServerBot.getBot(args[1]);
        if (bot == null) {
            sender.sendMessage(ChatColor.RED + "This fakeplayer is not in server");
            return;
        }
        if (args[2].equals("list")) {
            sender.sendMessage(bot.cy() + "'s action list:");
            for (BotAction action : bot.getBotActions()) {
                sender.sendMessage(action.getName());
            }
            return;
        }
        BotAction action = Actions.getForName(args[2]);
        if (action == null) {
            sender.sendMessage(ChatColor.RED + "Invalid action");
            return;
        }
        CraftPlayer player = sender instanceof CraftPlayer ? (CraftPlayer)sender : bot.getBukkitEntity();
        String[] realArgs = new String[args.length - 3];
        if (realArgs.length != 0) {
            System.arraycopy(args, 3, realArgs, 0, realArgs.length);
        }
        if (action instanceof CraftCustomBotAction) {
            CraftCustomBotAction customBotAction = (CraftCustomBotAction)action;
            newAction = customBotAction.getNew(player, realArgs);
        } else {
            newAction = action.getNew(player.getHandle(), action.getArgument().parse(0, realArgs));
        }
        if (newAction == null) {
            sender.sendMessage(ChatColor.RED + "Action create error, please check your arguments");
            return;
        }
        BotActionEvent event = new BotActionEvent((Bot)bot.getBukkitEntity(), newAction.getName(), realArgs);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            bot.setBotAction(newAction);
            sender.sendMessage("Action " + action.getName() + " has been issued to " + bot.ad().getString());
        }
    }

    private void onConfig(CommandSender sender, String @NotNull [] args) {
        if (!LeavesConfig.fakeplayerModifyConfig) {
            return;
        }
        if (args.length < 3) {
            sender.sendMessage(ChatColor.RED + "Use /bot config <name> <config> to modify fakeplayer's config");
            return;
        }
        ServerBot bot = ServerBot.getBot(args[1]);
        if (bot == null) {
            sender.sendMessage(ChatColor.RED + "This fakeplayer is not in server");
            return;
        }
        if (!acceptConfig.contains(args[2])) {
            sender.sendMessage(ChatColor.RED + "This config is not accept");
            return;
        }
        BotConfig config = BotConfig.valueOf(args[2].toUpperCase(Locale.ROOT));
        if (args.length < 4) {
            String value = null;
            switch (config) {
                case SKIP_SLEEP: {
                    value = String.valueOf(bot.fauxSleeping);
                    break;
                }
                case SPAWN_PHANTOM: {
                    sender.sendMessage(bot.cy() + "'s spawn_phantom: " + bot.spawnPhantom);
                    if (bot.spawnPhantom) {
                        sender.sendMessage(bot.cy() + "'s not_sleeping_ticks: " + bot.notSleepTicks);
                    }
                    return;
                }
                case ALWAYS_SEND_DATA: {
                    value = String.valueOf(bot.alwaysSendData);
                    break;
                }
                case SIMULATION_DISTANCE: {
                    value = String.valueOf(bot.getBukkitEntity().getSimulationDistance());
                }
            }
            sender.sendMessage(bot.cy() + "'s " + config.configName + ": " + value);
        } else {
            String value = args[3];
            BotConfigModifyEvent event = new BotConfigModifyEvent((Bot)bot.getBukkitEntity(), config.configName, value);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            switch (config) {
                case SKIP_SLEEP: {
                    boolean realValue;
                    bot.fauxSleeping = realValue = value.equals("true");
                    value = String.valueOf(realValue);
                    break;
                }
                case SPAWN_PHANTOM: {
                    boolean realValue;
                    bot.spawnPhantom = realValue = value.equals("true");
                    value = String.valueOf(realValue);
                    break;
                }
                case ALWAYS_SEND_DATA: {
                    boolean realValue;
                    bot.alwaysSendData = realValue = value.equals("true");
                    value = String.valueOf(realValue);
                    break;
                }
                case SIMULATION_DISTANCE: {
                    try {
                        int realValue = Integer.parseInt(value);
                        if (realValue < 2 || realValue > 32) {
                            sender.sendMessage("simulation_distance must be a number between 2 and 32, got: " + value);
                            return;
                        }
                        bot.getBukkitEntity().setSimulationDistance(realValue);
                        break;
                    }
                    catch (NumberFormatException e2) {
                        sender.sendMessage("simulation_distance must be a number between 2 and 32, got: " + value);
                        return;
                    }
                }
            }
            sender.sendMessage(bot.cy() + "'s " + config.configName + " changed: " + value);
        }
    }

    private void onList(CommandSender sender, String @NotNull [] args) {
        if (args.length < 2) {
            HashMap botMap = new HashMap();
            for (World world : Bukkit.getWorlds()) {
                botMap.put(world, new ArrayList());
            }
            for (ServerBot bot : ServerBot.getBots()) {
                Bot bukkitBot = bot.getBukkitPlayer();
                ((List)botMap.get(bukkitBot.getWorld())).add(bukkitBot.getName());
            }
            sender.sendMessage("Total number: (" + ServerBot.getBots().size() + "/" + LeavesConfig.fakeplayerLimit + ")");
            for (World world : botMap.keySet()) {
                sender.sendMessage(world.getName() + "(" + ((List)botMap.get(world)).size() + "): " + BotCommand.formatPlayerNameList((List)botMap.get(world)));
            }
        } else {
            World world = Bukkit.getWorld((String)args[2]);
            if (world == null) {
                sender.sendMessage(ChatColor.RED + "Unknown world");
                return;
            }
            ArrayList<String> botList = new ArrayList<String>();
            for (ServerBot bot : ServerBot.getBots()) {
                Bot bukkitBot = bot.getBukkitPlayer();
                if (bukkitBot.getWorld() != world) continue;
                botList.add(bukkitBot.getName());
            }
            sender.sendMessage(world.getName() + "(" + botList.size() + "): " + BotCommand.formatPlayerNameList(botList));
        }
    }

    @NotNull
    private static String formatPlayerNameList(@NotNull List<String> list) {
        if (list.isEmpty()) {
            return "";
        }
        String string = list.toString();
        return string.substring(1, string.length() - 1);
    }

    public static enum BotConfig {
        SKIP_SLEEP,
        SPAWN_PHANTOM,
        ALWAYS_SEND_DATA,
        SIMULATION_DISTANCE;

        public final String configName = this.name().toLowerCase(Locale.ROOT);
    }
}

