/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.bot;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.TileInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.ContainerChest;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R3.scheduler.CraftScheduler;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.bot.BotInventoryContainer;
import top.leavesmc.leaves.bot.BotStatsCounter;
import top.leavesmc.leaves.bot.BotUtil;
import top.leavesmc.leaves.bot.MojangAPI;
import top.leavesmc.leaves.bot.ServerBotGameMode;
import top.leavesmc.leaves.bot.agent.BotAction;
import top.leavesmc.leaves.bot.agent.actions.StopAction;
import top.leavesmc.leaves.entity.Bot;
import top.leavesmc.leaves.entity.CraftBot;
import top.leavesmc.leaves.event.bot.BotCreateEvent;
import top.leavesmc.leaves.event.bot.BotInventoryOpenEvent;
import top.leavesmc.leaves.event.bot.BotJoinEvent;
import top.leavesmc.leaves.util.MathUtils;

public class ServerBot
extends EntityPlayer {
    private final Map<String, BotAction> actions;
    private final boolean removeOnDeath;
    private final int tracingRange;
    private Vec3D velocity;
    private int fireTicks;
    private int jumpTicks;
    private int noFallTicks;
    public boolean waterSwim;
    private Vec3D knockback;
    public BotCreateState createState;
    public UUID createPlayer;
    private final ServerStatisticManager stats;
    private final BotInventoryContainer container;
    private static final List<ServerBot> bots = new CopyOnWriteArrayList<ServerBot>();
    public boolean spawnPhantom;
    public int notSleepTicks;
    public boolean alwaysSendData;

    private ServerBot(MinecraftServer server, WorldServer world, GameProfile profile) {
        super(server, world, profile, ClientInformation.a());
        this.an.b(new DataWatcherObject<Integer>(16, DataWatcherRegistry.b), 255);
        this.an.b(EntityHuman.bM, (byte)-2);
        this.e = new ServerBotGameMode(this);
        this.velocity = new Vec3D(this.bk, this.bl, this.bm);
        this.noFallTicks = 60;
        this.fireTicks = 0;
        this.actions = new HashMap<String, BotAction>();
        this.removeOnDeath = true;
        this.stats = new BotStatsCounter(server);
        this.container = new BotInventoryContainer(this);
        this.waterSwim = true;
        this.knockback = Vec3D.b;
        this.tracingRange = world.spigotConfig.playerTrackingRange * world.spigotConfig.playerTrackingRange;
        this.notSleepTicks = 0;
        this.fauxSleeping = LeavesConfig.fakeplayerSkipSleep;
        this.spawnPhantom = LeavesConfig.fakeplayerSpawnPhantom;
        this.alwaysSendData = LeavesConfig.alwaysSendFakeplayerData;
    }

    public static ServerBot createBot(@NotNull BotCreateState state) {
        if (!ServerBot.isCreateLegal(state.name)) {
            return null;
        }
        MinecraftServer server = MinecraftServer.getServer();
        BotCreateEvent event = new BotCreateEvent(state.name, state.skinName, state.loc, ChatColor.YELLOW + state.name + " joined the game");
        server.server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return null;
        }
        Location location = event.getCreateLocation();
        WorldServer world = ((CraftWorld)location.getWorld()).getHandle();
        CustomGameProfile profile = new CustomGameProfile(BotUtil.getBotUUID(state), state.name, state.skin);
        ServerBot bot = new ServerBot(server, world, profile);
        bot.c = new PlayerConnection(server, new NetworkManager(EnumProtocolDirection.a){

            @Override
            public void a(@NotNull Packet<?> packet) {
            }

            @Override
            public void a(@NotNull Packet<?> packet, @Nullable PacketSendListener packetsendlistener) {
            }

            @Override
            public void a(@NotNull Packet<?> packet, @Nullable PacketSendListener callbacks, boolean flush) {
            }
        }, bot, CommonListenerCookie.a(profile));
        bot.isRealPlayer = true;
        bot.createState = state;
        if (event.getJoinMessage() != null) {
            Bukkit.broadcastMessage((String)event.getJoinMessage());
        }
        bot.c(location.getX(), location.getY(), location.getZ());
        bot.a(location.getYaw(), location.getPitch());
        bot.getBukkitEntity().setRotation(location.getYaw(), location.getPitch());
        world.addFreshEntity(bot, CreatureSpawnEvent.SpawnReason.COMMAND);
        bot.renderAll();
        server.ae().addNewBot(bot);
        bots.add(bot);
        BotJoinEvent event1 = new BotJoinEvent(bot.getBukkitPlayer());
        server.server.getPluginManager().callEvent((Event)event1);
        return bot;
    }

    public static boolean isCreateLegal(@NotNull String name) {
        if (!name.matches("^[a-zA-Z0-9_]{4,16}$")) {
            return false;
        }
        if (Bukkit.getPlayer((String)name) != null || ServerBot.getBot(name) != null) {
            return false;
        }
        if (LeavesConfig.unableFakeplayerNames.contains(name)) {
            return false;
        }
        return ServerBot.getBots().size() < LeavesConfig.fakeplayerLimit;
    }

    public void renderAll() {
        MinecraftServer.getServer().ae().t().forEach(player -> {
            this.sendPlayerInfo((EntityPlayer)player);
            this.sendFakeData(player.c, false);
        });
    }

    public void sendPlayerInfo(EntityPlayer player) {
        player.c.b(new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.a.a, ClientboundPlayerInfoUpdatePacket.a.d, ClientboundPlayerInfoUpdatePacket.a.f), (Collection<EntityPlayer>)List.of(this)));
    }

    public boolean needSendFakeData(EntityPlayer player) {
        return this.alwaysSendData && player.dM() == this.dM() && player.dk().g(this.dk()) > (double)this.tracingRange;
    }

    public void sendFakeDataIfNeed(EntityPlayer player, boolean login) {
        if (this.needSendFakeData(player)) {
            this.sendFakeData(player.c, login);
        }
    }

    public void sendFakeData(ServerPlayerConnection playerConnection, boolean login) {
        playerConnection.b(new PacketPlayOutSpawnEntity(this));
        if (login) {
            Bukkit.getScheduler().runTaskLater(CraftScheduler.MINECRAFT, () -> this.c.b(new PacketPlayOutEntityHeadRotation(this, (byte)(this.dC() * 256.0f / 360.0f))), 10L);
        } else {
            this.c.b(new PacketPlayOutEntityHeadRotation(this, (byte)(this.dC() * 256.0f / 360.0f)));
        }
    }

    private void sendPacket(Packet<?> packet) {
        MinecraftServer.getServer().ae().t().forEach(player -> player.c.b(packet));
    }

    @Override
    public void a(@NotNull DamageSource damageSource) {
        super.a(damageSource);
        this.dieCheck();
    }

    private void dieCheck() {
        if (this.removeOnDeath) {
            bots.remove(this);
            this.d.ae().removeBot(this);
            this.a(Entity.RemovalReason.a);
            this.setDead();
            this.removeTab();
            Bukkit.broadcastMessage((String)(ChatColor.YELLOW + this.ad().getString() + " left the game"));
        }
    }

    private void removeTab() {
        this.sendPacket(new ClientboundPlayerInfoRemovePacket(List.of(this.cw())));
    }

    private void setDead() {
        this.sendPacket(new PacketPlayOutEntityDestroy(this.aj()));
        this.ba = true;
        this.bR.b(this);
        this.bS.b(this);
    }

    @Override
    @Nullable
    public Entity b(@NotNull WorldServer destination) {
        return null;
    }

    public Bot getBukkitPlayer() {
        return this.getBukkitEntity();
    }

    @Override
    @NotNull
    public CraftBot getBukkitEntity() {
        return (CraftBot)super.getBukkitEntity();
    }

    @Override
    public boolean aZ() {
        Location loc = this.getLocation();
        for (int i2 = 0; i2 <= 2; ++i2) {
            Material type = loc.getBlock().getType();
            if (type == Material.WATER || type == Material.LAVA) {
                return true;
            }
            loc.add(0.0, 0.9, 0.0);
        }
        return false;
    }

    @Override
    public void l() {
        super.l();
        this.m();
        if (!this.bx()) {
            return;
        }
        if (this.spawnPhantom) {
            ++this.notSleepTicks;
        }
        if (this.fireTicks > 0) {
            --this.fireTicks;
        }
        if (this.jumpTicks > 0) {
            --this.jumpTicks;
        }
        if (this.noFallTicks > 0) {
            --this.noFallTicks;
        }
        if (this.bX > 0) {
            --this.bX;
        }
        this.updateLocation();
        this.fM();
        if (this.d.ai() % 20 == 0) {
            float regenAmount;
            float maxHealth;
            float health = this.ev();
            float amount = health < (maxHealth = this.eM()) - (regenAmount = (float)(LeavesConfig.fakeplayerRegenAmount * 20.0)) ? health + regenAmount : maxHealth;
            this.c(amount);
        }
        BlockPosition blockposition = this.aH();
        IBlockData iblockdata = this.dM().a_(blockposition);
        Vec3D vec3d1 = this.a(this.velocity);
        this.a(vec3d1.d, this.aC(), iblockdata, blockposition);
        ++this.aP;
        if (this.ev() > 0.0f) {
            AxisAlignedBB axisalignedbb = this.bO() && !this.cZ().dH() ? this.cH().b(this.cZ().cH()).c(1.0, 0.0, 1.0) : this.cH().c(1.0, 0.5, 1.0);
            List<Entity> list = this.dM().a_(this, axisalignedbb);
            ArrayList list1 = Lists.newArrayList();
            for (Entity entity : list) {
                if (entity.ai() == EntityTypes.K) {
                    list1.add(entity);
                    continue;
                }
                if (entity.dH()) continue;
                this.touch(entity);
            }
            if (!list1.isEmpty()) {
                this.touch((Entity)SystemUtils.a(list1, this.ag));
            }
        }
        Iterator<Map.Entry<String, BotAction>> iterator = this.actions.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, BotAction> entry = iterator.next();
            if (entry.getValue().isCancel()) {
                iterator.remove();
                continue;
            }
            entry.getValue().tryTick(this);
        }
    }

    private void touch(@NotNull Entity entity) {
        entity.b_(this);
    }

    @Override
    public void a(@NotNull EntityItem item) {
        super.a(item);
        this.updateItemInHand(EnumHand.a);
    }

    public void updateItemInHand(EnumHand hand) {
        ItemStack item = this.b(hand);
        if (!item.b()) {
            BotUtil.replenishment(item, this.fS().i);
            if (BotUtil.isDamage(item, 10)) {
                BotUtil.replaceTool(hand == EnumHand.a ? EnumItemSlot.a : EnumItemSlot.b, this);
            }
        }
        this.detectEquipmentUpdatesPublic();
    }

    @Override
    public void a(double heightDifference, boolean onGround, @NotNull IBlockData state, @NotNull BlockPosition landedPosition) {
        if (onGround) {
            if (this.ab > 0.0f) {
                state.b().a(this.dM(), state, landedPosition, (Entity)this, this.ab);
                this.dM().a(GameEvent.A, this.dk(), GameEvent.a.a(this, this.aD.map(blockposition1 -> this.dM().a_((BlockPosition)blockposition1)).orElse(state)));
            }
            this.n();
        } else if (heightDifference < 0.0) {
            this.ab -= (float)heightDifference;
        }
    }

    @Override
    public void m() {
        if (this.aK > 0) {
            --this.aK;
        }
        this.as();
        this.bn = (int)this.bm;
        this.be = this.bd;
        this.N = this.dC();
        this.O = this.dE();
    }

    public Location getLocation() {
        return this.getBukkitPlayer().getLocation();
    }

    @Override
    public void knockback(double strength, double x2, double z2, @Nullable Entity knockingBackEntity, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull EntityKnockbackEvent.KnockbackCause cause) {
        if ((strength *= 1.0 - this.b(GenericAttributes.i)) > 0.0) {
            this.au = true;
            Vec3D vec3d = this.dp();
            Vec3D vec3d1 = new Vec3D(x2, 0.0, z2).d().a(strength);
            this.knockback = new Vec3D(vec3d.c / 2.0 - vec3d1.c, this.aC() ? Math.min(0.4, vec3d.d / 2.0 + strength) : vec3d.d, vec3d.e / 2.0 - vec3d1.e);
        }
    }

    private void updateLocation() {
        this.velocity = new Vec3D(this.bk, this.bl, this.bm);
        if (this.waterSwim && this.aZ()) {
            this.h(new Vec3D(0.0, 0.05, 0.0));
        }
        this.h(this.knockback);
        this.knockback = Vec3D.b;
        this.a(this.velocity);
    }

    public void faceLocation(@NotNull Location loc) {
        this.look(loc.toVector().subtract(this.getLocation().toVector()), false);
    }

    public void look(Vector dir, boolean keepYaw) {
        float pitch;
        float yaw;
        if (keepYaw) {
            yaw = this.cp();
            pitch = MathUtils.fetchPitch(dir);
        } else {
            float[] vals = MathUtils.fetchYawPitch(dir);
            yaw = vals[0];
            pitch = vals[1];
            this.sendPacket(new PacketPlayOutEntityHeadRotation(this, (byte)(yaw * 256.0f / 360.0f)));
        }
        this.a(yaw, pitch);
        this.getBukkitEntity().setRotation(yaw, pitch);
    }

    @Override
    public void d(@NotNull Entity target) {
        super.d(target);
        this.a(EnumHand.a);
    }

    @Override
    public void fb() {
        double jumpPower = (double)this.eZ() + (double)this.fa();
        this.h(new Vec3D(0.0, jumpPower, 0.0));
    }

    public void dropAll() {
        this.fS().k();
        this.detectEquipmentUpdatesPublic();
    }

    public void setBotAction(BotAction action) {
        if (!LeavesConfig.fakeplayerUseAction) {
            return;
        }
        if (action instanceof StopAction) {
            this.actions.clear();
        }
        action.init();
        this.actions.put(action.getName(), action);
    }

    public Collection<BotAction> getBotActions() {
        return this.actions.values();
    }

    public BotAction getBotAction(String name) {
        return this.actions.get(name);
    }

    @Deprecated
    public BotAction getBotAction() {
        return null;
    }

    @Override
    @NotNull
    public ServerStatisticManager H() {
        return this.stats;
    }

    public BotInventoryContainer getContainer() {
        return this.container;
    }

    @Override
    @NotNull
    public EnumInteractionResult a(@NotNull EntityHuman player, @NotNull EnumHand hand) {
        if (LeavesConfig.openFakeplayerInventory && player instanceof EntityPlayer) {
            EntityPlayer player1 = (EntityPlayer)player;
            if (player.eT().b()) {
                BotInventoryOpenEvent event = new BotInventoryOpenEvent((Bot)this.getBukkitEntity(), (Player)player1.getBukkitEntity());
                this.d.server.getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    player.a(new TileInventory((i2, inventory, p2) -> ContainerChest.b(i2, inventory, this.container), this.Q_()));
                    return EnumInteractionResult.a;
                }
            }
        }
        return super.a(player, hand);
    }

    public static ServerBot getBot(EntityPlayer player) {
        ServerBot bot = null;
        for (ServerBot b2 : bots) {
            if (b2.aj() != player.aj()) continue;
            bot = b2;
            break;
        }
        return bot;
    }

    public static ServerBot getBot(String name) {
        ServerBot bot = null;
        for (ServerBot b2 : bots) {
            if (!b2.ad().getString().equals(name)) continue;
            bot = b2;
            break;
        }
        return bot;
    }

    public static ServerBot getBot(UUID uuid) {
        ServerBot bot = null;
        for (ServerBot b2 : bots) {
            if (b2.ay != uuid) continue;
            bot = b2;
            break;
        }
        return bot;
    }

    public static void saveOrRemoveAllBot() {
        if (LeavesConfig.fakeplayerSupport && LeavesConfig.fakeplayerResident) {
            JsonObject fakePlayerList = new JsonObject();
            bots.forEach(bot -> fakePlayerList.add(bot.createState.realName, (JsonElement)BotUtil.saveBot(bot)));
            File file = MinecraftServer.getServer().a(SavedFile.l).resolve("fake_player.leaves.json").toFile();
            if (!file.isFile()) {
                try {
                    file.createNewFile();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            try (BufferedWriter bfw = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                bfw.write(new Gson().toJson((JsonElement)fakePlayerList));
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        } else {
            ServerBot.removeAllBot();
        }
    }

    public static void loadAllBot() {
        if (LeavesConfig.fakeplayerSupport && LeavesConfig.fakeplayerResident) {
            JsonObject fakePlayerList = new JsonObject();
            File file = MinecraftServer.getServer().a(SavedFile.l).resolve("fake_player.leaves.json").toFile();
            if (!file.isFile()) {
                return;
            }
            try (BufferedReader bfr = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
                fakePlayerList = (JsonObject)new Gson().fromJson((Reader)bfr, JsonObject.class);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            for (Map.Entry entry : fakePlayerList.entrySet()) {
                BotUtil.loadBot(entry);
            }
            file.delete();
        }
    }

    public static boolean removeAllBot() {
        for (ServerBot bot : bots) {
            bot.a(bot.dN().m());
        }
        return true;
    }

    public static List<ServerBot> getBots() {
        return bots;
    }

    public static class BotCreateState {
        public Location loc;
        public String[] skin;
        public String skinName;
        private String realName;
        private String name;

        public BotCreateState(Location loc, String realName, String skinName) {
            this.loc = loc;
            this.skinName = skinName;
            this.setRealName(realName);
        }

        public BotCreateState(Location loc, String name, String realName, String skinName, String[] skin) {
            this.loc = loc;
            this.skinName = skinName;
            this.skin = skin;
            this.realName = realName;
            this.name = name;
        }

        public ServerBot createSync() {
            return ServerBot.createBot(this);
        }

        public void createAsync(Consumer<ServerBot> consumer) {
            Bukkit.getScheduler().runTaskAsynchronously(CraftScheduler.MINECRAFT, () -> {
                if (this.skinName != null) {
                    this.skin = MojangAPI.getSkin(this.skinName);
                }
                Bukkit.getScheduler().runTask(CraftScheduler.MINECRAFT, () -> {
                    ServerBot bot = ServerBot.createBot(this);
                    if (bot != null && consumer != null) {
                        consumer.accept(bot);
                    }
                });
            });
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setRealName(String realName) {
            this.realName = realName;
            this.name = LeavesConfig.fakeplayerPrefix + realName + LeavesConfig.fakeplayerSuffix;
        }

        public String getName() {
            return this.name;
        }

        public String getRealName() {
            return this.realName;
        }
    }

    public static class CustomGameProfile
    extends GameProfile {
        public CustomGameProfile(UUID uuid, String name, String[] skin) {
            super(uuid, name);
            this.setSkin(skin);
        }

        public void setSkin(String[] skin) {
            if (skin != null) {
                this.getProperties().put((Object)"textures", (Object)new Property("textures", skin[0], skin[1]));
            }
        }
    }
}

