/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.command;

import io.papermc.paper.command.CommandUtil;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.SystemUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.PluginManager;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.command.LeavesSubcommand;
import top.leavesmc.leaves.command.subcommands.ConfigCommand;
import top.leavesmc.leaves.command.subcommands.CounterCommand;
import top.leavesmc.leaves.command.subcommands.PeacefulModeSwitchCommand;
import top.leavesmc.leaves.command.subcommands.ReloadCommand;
import top.leavesmc.leaves.command.subcommands.UpdateCommand;

public final class LeavesCommand
extends Command {
    static final String BASE_PERM = "bukkit.command.leaves.";
    private static final Map<String, LeavesSubcommand> SUBCOMMANDS = SystemUtils.a(() -> {
        HashMap<Set<String>, LeavesSubcommand> commands = new HashMap<Set<String>, LeavesSubcommand>();
        commands.put(Set.of("config"), new ConfigCommand());
        commands.put(Set.of("update"), new UpdateCommand());
        commands.put(Set.of("peaceful"), new PeacefulModeSwitchCommand());
        commands.put(Set.of("counter"), new CounterCommand());
        commands.put(Set.of("reload"), new ReloadCommand());
        return commands.entrySet().stream().flatMap(entry -> ((Set)entry.getKey()).stream().map(s2 -> Map.entry(s2, (LeavesSubcommand)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    });
    private static final Set<String> COMPLETABLE_SUBCOMMANDS = SUBCOMMANDS.entrySet().stream().filter(entry -> ((LeavesSubcommand)entry.getValue()).tabCompletes()).map(Map.Entry::getKey).collect(Collectors.toSet());

    public LeavesCommand(String name) {
        super(name);
        this.description = "Leaves related commands";
        this.usageMessage = "/leaves [" + String.join((CharSequence)" | ", SUBCOMMANDS.keySet()) + "]";
        ArrayList<String> permissions = new ArrayList<String>();
        permissions.add("bukkit.command.leaves");
        permissions.addAll(SUBCOMMANDS.keySet().stream().map(s2 -> BASE_PERM + s2).toList());
        this.setPermission(String.join((CharSequence)";", permissions));
        PluginManager pluginManager = Bukkit.getServer().getPluginManager();
        for (String perm : permissions) {
            if (pluginManager.getPermission(perm) != null) continue;
            pluginManager.addPermission(new Permission(perm, PermissionDefault.OP));
        }
    }

    private static boolean testPermission(CommandSender sender, String permission) {
        if (sender.hasPermission(BASE_PERM + permission) || sender.hasPermission("bukkit.command.leaves")) {
            return true;
        }
        sender.sendMessage(Bukkit.permissionMessage());
        return false;
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, String[] args, @Nullable Location location) throws IllegalArgumentException {
        if (args.length <= 1) {
            return CommandUtil.getListMatchingLast(sender, args, COMPLETABLE_SUBCOMMANDS);
        }
        @Nullable Pair<String, LeavesSubcommand> subCommand = LeavesCommand.resolveCommand(args[0]);
        if (subCommand != null) {
            return ((LeavesSubcommand)subCommand.second()).tabComplete(sender, (String)subCommand.first(), Arrays.copyOfRange(args, 1, args.length));
        }
        return Collections.emptyList();
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage((Component)Component.text((String)("Usage: " + this.usageMessage), (TextColor)NamedTextColor.RED));
            return false;
        }
        Pair<String, LeavesSubcommand> subCommand = LeavesCommand.resolveCommand(args[0]);
        if (subCommand == null) {
            sender.sendMessage((Component)Component.text((String)("Usage: " + this.usageMessage), (TextColor)NamedTextColor.RED));
            return false;
        }
        if (!LeavesCommand.testPermission(sender, (String)subCommand.first())) {
            return true;
        }
        String[] choppedArgs = Arrays.copyOfRange(args, 1, args.length);
        return ((LeavesSubcommand)subCommand.second()).execute(sender, (String)subCommand.first(), choppedArgs);
    }

    private static @Nullable Pair<String, LeavesSubcommand> resolveCommand(String label) {
        LeavesSubcommand subCommand = SUBCOMMANDS.get(label = label.toLowerCase(Locale.ENGLISH));
        if (subCommand != null) {
            return Pair.of((Object)label, (Object)subCommand);
        }
        return null;
    }
}

