/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.command.subcommands;

import io.papermc.paper.command.CommandUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.CommandSender;
import top.leavesmc.leaves.command.LeavesSubcommand;
import top.leavesmc.leaves.config.GlobalConfigManager;

public class ConfigCommand
implements LeavesSubcommand {
    @Override
    public boolean execute(CommandSender sender, String subCommand, String[] args) {
        if (args.length < 1) {
            sender.sendMessage((Component)Component.text((String)"Leaves Config", (TextColor)NamedTextColor.GRAY));
            return true;
        }
        GlobalConfigManager.VerifiedConfig verifiedConfig = GlobalConfigManager.getVerifiedConfig(args[0]);
        if (verifiedConfig == null) {
            sender.sendMessage(Component.join((JoinConfiguration)JoinConfiguration.noSeparators(), (ComponentLike[])new ComponentLike[]{Component.text((String)"Config ", (TextColor)NamedTextColor.GRAY), Component.text((String)args[0], (TextColor)NamedTextColor.RED), Component.text((String)" is Not Found.", (TextColor)NamedTextColor.GRAY)}));
            return true;
        }
        if (args.length > 1) {
            try {
                verifiedConfig.set(args[1]);
                sender.sendMessage(Component.join((JoinConfiguration)JoinConfiguration.noSeparators(), (ComponentLike[])new ComponentLike[]{Component.text((String)"Config ", (TextColor)NamedTextColor.GRAY), Component.text((String)args[0], (TextColor)NamedTextColor.AQUA), Component.text((String)" changed to ", (TextColor)NamedTextColor.GRAY), Component.text((String)verifiedConfig.getString(), (TextColor)NamedTextColor.AQUA)}));
            }
            catch (IllegalArgumentException exception) {
                sender.sendMessage(Component.join((JoinConfiguration)JoinConfiguration.noSeparators(), (ComponentLike[])new ComponentLike[]{Component.text((String)"Config ", (TextColor)NamedTextColor.GRAY), Component.text((String)args[0], (TextColor)NamedTextColor.RED), Component.text((String)" modify error by ", (TextColor)NamedTextColor.GRAY), Component.text((String)exception.getMessage(), (TextColor)NamedTextColor.RED)}));
            }
        } else {
            sender.sendMessage(Component.join((JoinConfiguration)JoinConfiguration.noSeparators(), (ComponentLike[])new ComponentLike[]{Component.text((String)"Config ", (TextColor)NamedTextColor.GRAY), Component.text((String)args[0], (TextColor)NamedTextColor.AQUA), Component.text((String)" value is ", (TextColor)NamedTextColor.GRAY), Component.text((String)verifiedConfig.getString(), (TextColor)NamedTextColor.AQUA)}));
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String subCommand, String[] args) {
        switch (args.length) {
            case 1: {
                ArrayList<String> list = new ArrayList<String>(GlobalConfigManager.getVerifiedConfigPaths());
                return CommandUtil.getListMatchingLast(sender, args, list);
            }
            case 2: {
                GlobalConfigManager.VerifiedConfig verifiedConfig = GlobalConfigManager.getVerifiedConfig(args[0]);
                if (verifiedConfig != null) {
                    if (verifiedConfig.config().lock()) {
                        return Collections.singletonList("<LOCKED CONFIG>");
                    }
                    return CommandUtil.getListMatchingLast(sender, args, verifiedConfig.verify().valueSuggest());
                }
                return Collections.singletonList("<ERROR CONFIG>");
            }
        }
        return Collections.emptyList();
    }
}

