/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.config;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import org.bukkit.configuration.file.YamlConfiguration;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.config.ConfigVerify;
import top.leavesmc.leaves.config.GlobalConfig;
import top.leavesmc.leaves.config.GlobalConfigManager;

public class GlobalConfigCreator {
    public static void main(String[] args) {
        YamlConfiguration config = new YamlConfiguration();
        config.options().setHeader(Collections.singletonList("Configuration file for Leaves."));
        config.set("config-version", (Object)5);
        Class<LeavesConfig> clazz = LeavesConfig.class;
        for (Field field : clazz.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            GlobalConfig globalConfig = field.getAnnotation(GlobalConfig.class);
            if (globalConfig == null) continue;
            try {
                GlobalConfigManager.VerifiedConfig verifiedConfig = GlobalConfigManager.VerifiedConfig.build(globalConfig, field);
                ConfigVerify<? super Object> verify = verifiedConfig.verify();
                boolean isEnumConfig = verify instanceof ConfigVerify.EnumConfigVerify;
                Object defValue = isEnumConfig ? field.get(null).toString() : field.get(null);
                config.set(verifiedConfig.path(), defValue);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        config.set("settings.protocol.xaero-map-server-id", (Object)0);
        try {
            File file = new File("leaves.yml");
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            config.save(file);
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }
}

