/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.LeavesLogger;
import top.leavesmc.leaves.config.ConfigConvert;
import top.leavesmc.leaves.config.ConfigVerify;
import top.leavesmc.leaves.config.GlobalConfig;
import top.leavesmc.leaves.config.RemovedConfig;

public class GlobalConfigManager {
    private static boolean firstLoad = true;
    private static final Map<String, VerifiedConfig> verifiedConfigs = new HashMap<String, VerifiedConfig>();

    public static void init() {
        verifiedConfigs.clear();
        Class<LeavesConfig> clazz = LeavesConfig.class;
        for (Field field : clazz.getDeclaredFields()) {
            GlobalConfig globalConfig;
            if (!Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            RemovedConfig removedConfig = field.getAnnotation(RemovedConfig.class);
            if (removedConfig != null) {
                RemovedVerifiedConfig verifiedConfig = RemovedVerifiedConfig.build(removedConfig, field);
                verifiedConfig.run();
            }
            if ((globalConfig = field.getAnnotation(GlobalConfig.class)) == null) continue;
            try {
                VerifiedConfig verifiedConfig = VerifiedConfig.build(globalConfig, field);
                if (globalConfig.lock() && !firstLoad) {
                    verifiedConfigs.put(verifiedConfig.path.substring("settings.".length()), verifiedConfig);
                    continue;
                }
                ConfigVerify<? super Object> verify = verifiedConfig.verify;
                boolean isEnumConfig = verify instanceof ConfigVerify.EnumConfigVerify;
                Object defValue = isEnumConfig ? field.get(null).toString() : field.get(null);
                LeavesConfig.config.addDefault(verifiedConfig.path, defValue);
                try {
                    String checkInfo;
                    Object savedValue = LeavesConfig.config.get(verifiedConfig.path);
                    if (isEnumConfig) {
                        savedValue = verify.convert(savedValue.toString());
                    }
                    if ((checkInfo = verify.check(null, savedValue)) != null) {
                        throw new IllegalArgumentException(checkInfo);
                    }
                    field.set(null, savedValue);
                }
                catch (ClassCastException | IllegalArgumentException e2) {
                    LeavesConfig.config.set(verifiedConfig.path, defValue);
                    LeavesLogger.LOGGER.warning(e2.getMessage() + ", reset to " + defValue);
                }
                verifiedConfigs.put(verifiedConfig.path.substring("settings.".length()), verifiedConfig);
            }
            catch (Exception e3) {
                Bukkit.getLogger().log(Level.SEVERE, "Failure to load leaves config", e3);
            }
        }
        verifiedConfigs.forEach((path, config) -> config.verify.runAfterLoader(config.get()));
        firstLoad = false;
        LeavesConfig.save();
    }

    public static VerifiedConfig getVerifiedConfig(String path) {
        return verifiedConfigs.get(path);
    }

    public static Set<String> getVerifiedConfigPaths() {
        return verifiedConfigs.keySet();
    }

    public record RemovedVerifiedConfig(RemovedConfig config, ConfigConvert<? super Object> convert, Field field, String path) {
        public void run() {
            if (this.config.transform() && LeavesConfig.config.contains(this.path)) {
                String string = LeavesConfig.config.get(this.path).toString();
                try {
                    Object object = this.convert.convert(string);
                    this.field.set(null, object);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            LeavesConfig.config.set(this.path, null);
        }

        public static RemovedVerifiedConfig build(RemovedConfig config, Field field) {
            StringBuilder path = new StringBuilder("settings.");
            for (int i2 = 0; i2 < config.category().length; ++i2) {
                path.append(config.category()[i2]).append(".");
            }
            path.append(config.name());
            ConfigConvert<?> configConvert = null;
            try {
                Constructor<ConfigConvert<?>> constructor = config.convert().getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                configConvert = constructor.newInstance(new Object[0]);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            return new RemovedVerifiedConfig(config, configConvert, field, path.toString());
        }
    }

    public record VerifiedConfig(GlobalConfig config, ConfigVerify<? super Object> verify, Field field, String path) {
        public void set(String realValue) throws IllegalArgumentException {
            Object value;
            if (this.config.lock()) {
                throw new IllegalArgumentException("locked");
            }
            try {
                value = this.verify.convert(realValue);
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("value parse error: " + e2.getMessage());
            }
            String checkInfo = this.verify.check(this.get(), value);
            if (checkInfo != null) {
                throw new IllegalArgumentException(checkInfo);
            }
            try {
                this.field.set(null, value);
                LeavesConfig.config.set(this.path, this.verify instanceof ConfigVerify.EnumConfigVerify ? realValue.toUpperCase(Locale.ROOT) : value);
                LeavesConfig.save();
            }
            catch (IllegalAccessException e3) {
                throw new IllegalArgumentException("?");
            }
        }

        public String getString() {
            return this.get().toString();
        }

        public Object get() {
            try {
                return this.field.get(null);
            }
            catch (IllegalAccessException e2) {
                LeavesLogger.LOGGER.log(Level.SEVERE, "Failure to get " + this.path + " value", e2);
                return "<VALUE ERROR>";
            }
        }

        public static VerifiedConfig build(GlobalConfig config, Field field) {
            StringBuilder path = new StringBuilder("settings.");
            for (int i2 = 0; i2 < config.category().length; ++i2) {
                path.append(config.category()[i2]).append(".");
            }
            path.append(config.name());
            ConfigVerify<?> configVerify = null;
            try {
                Constructor<ConfigVerify<?>> constructor = config.verify().getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                configVerify = constructor.newInstance(new Object[0]);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            return new VerifiedConfig(config, configVerify, field, path.toString());
        }
    }
}

