/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.lithium.common.util;

import net.minecraft.core.SectionPosition;
import net.minecraft.world.level.LevelHeightAccessor;

public class Pos {

    public static class SectionYIndex {
        public static int getNumYSections(LevelHeightAccessor view) {
            return view.am();
        }

        public static int getMinYSectionIndex(LevelHeightAccessor view) {
            return 0;
        }

        public static int getMaxYSectionIndexInclusive(LevelHeightAccessor view) {
            return view.am() - 1;
        }

        public static int getMaxYSectionIndexExclusive(LevelHeightAccessor view) {
            return view.am();
        }

        public static int fromSectionCoord(LevelHeightAccessor view, int sectionCoord) {
            return sectionCoord - SectionYCoord.getMinYSection(view);
        }

        public static int fromBlockCoord(LevelHeightAccessor view, int blockCoord) {
            return SectionYIndex.fromSectionCoord(view, SectionPosition.a(blockCoord));
        }
    }

    public static class SectionYCoord {
        public static int getNumYSections(LevelHeightAccessor view) {
            return view.am();
        }

        public static int getMinYSection(LevelHeightAccessor view) {
            return view.an();
        }

        public static int getMaxYSectionInclusive(LevelHeightAccessor view) {
            return view.ao() - 1;
        }

        public static int getMaxYSectionExclusive(LevelHeightAccessor view) {
            return view.ao();
        }

        public static int fromSectionIndex(LevelHeightAccessor view, int sectionCoord) {
            return sectionCoord + SectionYCoord.getMinYSection(view);
        }

        public static int fromBlockCoord(int blockCoord) {
            return SectionPosition.a(blockCoord);
        }
    }

    public static class ChunkCoord {
        public static int fromBlockCoord(int blockCoord) {
            return SectionPosition.a(blockCoord);
        }

        public static int fromBlockSize(int i2) {
            return i2 >> 4;
        }
    }

    public static class BlockCoord {
        public static int getYSize(LevelHeightAccessor view) {
            return view.K_();
        }

        public static int getMinY(LevelHeightAccessor view) {
            return view.J_();
        }

        public static int getMaxYInclusive(LevelHeightAccessor view) {
            return view.al() - 1;
        }

        public static int getMaxYExclusive(LevelHeightAccessor view) {
            return view.al();
        }

        public static int getMaxInSectionCoord(int sectionCoord) {
            return 15 + BlockCoord.getMinInSectionCoord(sectionCoord);
        }

        public static int getMaxYInSectionIndex(LevelHeightAccessor view, int sectionIndex) {
            return BlockCoord.getMaxInSectionCoord(SectionYCoord.fromSectionIndex(view, sectionIndex));
        }

        public static int getMinInSectionCoord(int sectionCoord) {
            return SectionPosition.c(sectionCoord);
        }

        public static int getMinYInSectionIndex(LevelHeightAccessor view, int sectionIndex) {
            return BlockCoord.getMinInSectionCoord(SectionYCoord.fromSectionIndex(view, sectionIndex));
        }
    }
}

