/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.lithium.common.world.chunk;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.VarInt;
import net.minecraft.world.level.chunk.DataPalette;
import net.minecraft.world.level.chunk.DataPaletteExpandable;
import org.jetbrains.annotations.NotNull;

public class LithiumHashPalette<T>
implements DataPalette<T> {
    private static final int ABSENT_VALUE = -1;
    private final Registry<T> idList;
    private final DataPaletteExpandable<T> resizeHandler;
    private final int indexBits;
    private final Reference2IntMap<T> table;
    private T[] entries;
    private int size = 0;

    public LithiumHashPalette(Registry<T> idList, DataPaletteExpandable<T> resizeHandler, int indexBits, T[] entries, Reference2IntMap<T> table, int size) {
        this.idList = idList;
        this.resizeHandler = resizeHandler;
        this.indexBits = indexBits;
        this.entries = entries;
        this.table = table;
        this.size = size;
    }

    public LithiumHashPalette(Registry<T> idList, int bits, DataPaletteExpandable<T> resizeHandler, @NotNull List<T> list) {
        this(idList, bits, resizeHandler);
        for (T t2 : list) {
            this.addEntry(t2);
        }
    }

    public LithiumHashPalette(Registry<T> idList, int bits, DataPaletteExpandable<T> resizeHandler) {
        this.idList = idList;
        this.indexBits = bits;
        this.resizeHandler = resizeHandler;
        int capacity = 1 << bits;
        this.entries = new Object[capacity];
        this.table = new Reference2IntOpenHashMap(capacity, 0.5f);
        this.table.defaultReturnValue(-1);
    }

    @Override
    public int a(@NotNull T obj) {
        int id = this.table.getInt(obj);
        if (id == -1) {
            id = this.computeEntry(obj);
        }
        return id;
    }

    @Override
    public boolean a(@NotNull Predicate<T> predicate) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (!predicate.test(this.entries[i2])) continue;
            return true;
        }
        return false;
    }

    private int computeEntry(T obj) {
        int id = this.addEntry(obj);
        if (id >= 1 << this.indexBits) {
            if (this.resizeHandler == null) {
                throw new IllegalStateException("Cannot grow");
            }
            id = this.resizeHandler.onResize(this.indexBits + 1, obj);
        }
        return id;
    }

    private int addEntry(T obj) {
        int nextId = this.size;
        if (nextId >= this.entries.length) {
            this.resize(this.size);
        }
        this.table.put(obj, nextId);
        this.entries[nextId] = obj;
        ++this.size;
        return nextId;
    }

    private void resize(int neededCapacity) {
        this.entries = Arrays.copyOf(this.entries, HashCommon.nextPowerOfTwo((int)(neededCapacity + 1)));
    }

    @Override
    public T a(int id) {
        T[] entries = this.entries;
        if (id >= 0 && id < entries.length) {
            return entries[id];
        }
        return null;
    }

    @Override
    public void a(PacketDataSerializer buf) {
        this.clear();
        int entryCount = buf.n();
        for (int i2 = 0; i2 < entryCount; ++i2) {
            this.addEntry(this.idList.a(buf.n()));
        }
    }

    @Override
    public void b(PacketDataSerializer buf) {
        int size = this.size;
        buf.c(size);
        for (int i2 = 0; i2 < size; ++i2) {
            buf.c(this.idList.a(this.a(i2)));
        }
    }

    @Override
    public int a() {
        int size = VarInt.a(this.size);
        for (int i2 = 0; i2 < this.size; ++i2) {
            size += VarInt.a(this.idList.a(this.a(i2)));
        }
        return size;
    }

    @Override
    public int b() {
        return this.size;
    }

    @Override
    @NotNull
    public DataPalette<T> c() {
        return new LithiumHashPalette<Object>((Registry<Object>)this.idList, (DataPaletteExpandable<Object>)this.resizeHandler, this.indexBits, (T[])((Object[])this.entries.clone()), (Reference2IntMap<Object>)new Reference2IntOpenHashMap(this.table), this.size);
    }

    private void clear() {
        Arrays.fill(this.entries, null);
        this.table.clear();
        this.size = 0;
    }

    public List<T> getElements() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (T entry : this.entries) {
            if (entry == null) continue;
            builder.add(entry);
        }
        return builder.build();
    }

    public static <A> DataPalette<A> create(int bits, Registry<A> idList, DataPaletteExpandable<A> listener, List<A> list) {
        return new LithiumHashPalette<A>(idList, bits, listener, list);
    }
}

