/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.profile;

import com.destroystokyo.paper.profile.PaperMinecraftSessionService;
import com.google.common.collect.Multimap;
import com.mojang.authlib.Environment;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.exceptions.MinecraftClientException;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.authlib.yggdrasil.ServicesKeySet;
import com.mojang.authlib.yggdrasil.response.HasJoinedMinecraftServerResponse;
import com.mojang.authlib.yggdrasil.response.ProfileAction;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import org.jetbrains.annotations.Nullable;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.bot.ServerBot;

public class LeavesMinecraftSessionService
extends PaperMinecraftSessionService {
    private static List<URL> extraYggdrasilList = List.of();

    protected LeavesMinecraftSessionService(ServicesKeySet keySet, Proxy authenticationService, Environment environment) {
        super(keySet, authenticationService, environment);
    }

    public static void initExtraYggdrasilList() {
        ArrayList<URL> list = new ArrayList<URL>();
        for (String str : LeavesConfig.extraYggdrasilServiceList) {
            list.add(HttpAuthenticationService.constantURL((String)(str + "/sessionserver/session/minecraft/hasJoined")));
        }
        extraYggdrasilList = Collections.unmodifiableList(list);
    }

    @Override
    @Nullable
    public ProfileResult hasJoinedServer(String profileName, String serverId, @Nullable InetAddress address) throws AuthenticationUnavailableException {
        ProfileResult result = super.hasJoinedServer(profileName, serverId, address);
        EntityPlayer player = MinecraftServer.getServer().ae().a(profileName);
        if (player != null && !(player instanceof ServerBot)) {
            return null;
        }
        if (LeavesConfig.extraYggdrasilService && result == null) {
            HashMap<String, String> arguments = new HashMap<String, String>();
            arguments.put("username", profileName);
            arguments.put("serverId", serverId);
            if (address != null) {
                arguments.put("ip", address.getHostAddress());
            }
            GameProfile cache = null;
            if (LeavesConfig.extraYggdrasilLoginProtect) {
                cache = MinecraftServer.getServer().j.f().getProfileIfCached(profileName);
            }
            for (URL checkUrl : extraYggdrasilList) {
                URL url = HttpAuthenticationService.concatenateURL((URL)checkUrl, (String)HttpAuthenticationService.buildQuery(arguments));
                try {
                    HasJoinedMinecraftServerResponse response = (HasJoinedMinecraftServerResponse)this.client.get(url, HasJoinedMinecraftServerResponse.class);
                    if (response == null || response.id() == null || LeavesConfig.extraYggdrasilLoginProtect && cache != null && response.id() != cache.getId()) continue;
                    GameProfile result1 = new GameProfile(response.id(), profileName);
                    if (response.properties() != null) {
                        result1.getProperties().putAll((Multimap)response.properties());
                    }
                    Set profileActions = response.profileActions().stream().map(ProfileAction::type).collect(Collectors.toSet());
                    return new ProfileResult(result1, profileActions);
                }
                catch (MinecraftClientException e2) {
                    AuthenticationException authenticationException = e2.toAuthenticationException();
                    if (!(authenticationException instanceof AuthenticationUnavailableException)) continue;
                    AuthenticationUnavailableException unavailable = (AuthenticationUnavailableException)authenticationException;
                    throw unavailable;
                }
            }
        }
        return result;
    }
}

