/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.food.FoodMetaData;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.protocol.core.LeavesProtocol;
import top.leavesmc.leaves.protocol.core.ProtocolHandler;
import top.leavesmc.leaves.protocol.core.ProtocolUtils;

@LeavesProtocol(namespace={"appleskin"})
public class AppleSkinProtocol {
    public static final String PROTOCOL_ID = "appleskin";
    private static final MinecraftKey SATURATION_KEY = AppleSkinProtocol.id("saturation_sync");
    private static final MinecraftKey EXHAUSTION_KEY = AppleSkinProtocol.id("exhaustion_sync");
    private static final Map<UUID, Float> previousSaturationLevels = new HashMap<UUID, Float>();
    private static final Map<UUID, Float> previousExhaustionLevels = new HashMap<UUID, Float>();
    private static final float MINIMUM_EXHAUSTION_CHANGE_THRESHOLD = 0.01f;
    private static final Set<EntityPlayer> players = new HashSet<EntityPlayer>();

    @Contract(value="_ -> new")
    @NotNull
    public static MinecraftKey id(String path) {
        return new MinecraftKey(PROTOCOL_ID, path);
    }

    @ProtocolHandler.PlayerJoin
    public static void onPlayerLoggedIn(@NotNull EntityPlayer player) {
        if (LeavesConfig.appleskinProtocol) {
            AppleSkinProtocol.resetPlayerData(player);
        }
    }

    @ProtocolHandler.PlayerLeave
    public static void onPlayerLoggedOut(@NotNull EntityPlayer player) {
        if (LeavesConfig.appleskinProtocol) {
            players.remove(player);
            AppleSkinProtocol.resetPlayerData(player);
        }
    }

    @ProtocolHandler.MinecraftRegister(ignoreId=true)
    public static void onPlayerSubscribed(@NotNull EntityPlayer player) {
        if (LeavesConfig.appleskinProtocol) {
            players.add(player);
        }
    }

    @ProtocolHandler.Ticker
    public static void tick() {
        if (LeavesConfig.appleskinProtocol) {
            for (EntityPlayer player : players) {
                FoodMetaData data = player.gc();
                float saturation = data.e();
                Float previousSaturation = previousSaturationLevels.get(player.cw());
                if (previousSaturation == null || saturation != previousSaturation.floatValue()) {
                    ProtocolUtils.sendPayloadPacket(player, SATURATION_KEY, buf -> buf.a(saturation));
                    previousSaturationLevels.put(player.cw(), Float.valueOf(saturation));
                }
                float exhaustion = data.d();
                Float previousExhaustion = previousExhaustionLevels.get(player.cw());
                if (previousExhaustion != null && !(Math.abs(exhaustion - previousExhaustion.floatValue()) >= 0.01f)) continue;
                ProtocolUtils.sendPayloadPacket(player, EXHAUSTION_KEY, buf -> buf.a(exhaustion));
                previousExhaustionLevels.put(player.cw(), Float.valueOf(exhaustion));
            }
        }
    }

    @ProtocolHandler.ReloadServer
    public static void onServerReload() {
        if (!LeavesConfig.appleskinProtocol) {
            AppleSkinProtocol.disableAllPlayer();
        }
    }

    public static void disableAllPlayer() {
        for (EntityPlayer player : MinecraftServer.getServer().ae().t()) {
            AppleSkinProtocol.onPlayerLoggedOut(player);
        }
    }

    private static void resetPlayerData(@NotNull EntityPlayer player) {
        previousExhaustionLevels.remove(player.cw());
        previousSaturationLevels.remove(player.cw());
    }
}

