/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.players.UserCache;
import net.minecraft.world.ChestLock;
import net.minecraft.world.IInventory;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInfo;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.frog.Tadpole;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.inventory.InventoryEnderChest;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.CalibratedSculkSensorBlock;
import net.minecraft.world.level.block.entity.CalibratedSculkSensorBlockEntity;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.entity.TileEntityBrewingStand;
import net.minecraft.world.level.block.entity.TileEntityCampfire;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityComparator;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.entity.TileEntityEnderChest;
import net.minecraft.world.level.block.entity.TileEntityFurnace;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.block.entity.TileEntityJukeBox;
import net.minecraft.world.level.block.entity.TileEntityLectern;
import net.minecraft.world.level.block.entity.TrialSpawnerBlockEntity;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerData;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.protocol.core.LeavesProtocol;
import top.leavesmc.leaves.protocol.core.ProtocolHandler;
import top.leavesmc.leaves.protocol.core.ProtocolUtils;

@LeavesProtocol(namespace={"jade"})
public class JadeProtocol {
    public static final String PROTOCOL_ID = "jade";
    public static final MinecraftKey PACKET_SERVER_PING = JadeProtocol.id("server_ping");
    public static final MinecraftKey PACKET_RECEIVE_DATA = JadeProtocol.id("receive_data");
    private static final HierarchyLookup<IJadeDataProvider<Entity>> entityDataProviders = new HierarchyLookup(Entity.class);
    private static final HierarchyLookup<IJadeDataProvider<TileEntity>> tileDataProviders = new HierarchyLookup(TileEntity.class);
    private static final HierarchyLookup<IServerExtensionProvider<Entity, ItemStack>> entityItemProviders = new HierarchyLookup(Entity.class);
    private static final HierarchyLookup<IServerExtensionProvider<TileEntity, ItemStack>> tileItemProviders = new HierarchyLookup(TileEntity.class);
    public static final Cache<Object, ItemCollector<?>> targetCache = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(60L, TimeUnit.SECONDS).build();
    public static final int MAX_DISTANCE_SQR = 900;

    @Contract(value="_ -> new")
    @NotNull
    public static MinecraftKey id(String path) {
        return new MinecraftKey(PROTOCOL_ID, path);
    }

    @ProtocolHandler.Init
    public static void init() {
        entityItemProviders.register(Entity.class, (player, world, target) -> {
            ItemCollector itemCollector;
            ContainerEntity containerEntity;
            if (target instanceof ContainerEntity && (containerEntity = (ContainerEntity)((Object)target)).C() != null) {
                return List.of();
            }
            try {
                itemCollector = (ItemCollector)targetCache.get(target, () -> {
                    if (target instanceof EntityHorseAbstract) {
                        return new ItemCollector<IInventory>(new ItemIterator.ContainerItemIterator(o2 -> {
                            if (o2 instanceof EntityHorseAbstract) {
                                EntityHorseAbstract horse = (EntityHorseAbstract)o2;
                                return horse.cp;
                            }
                            return null;
                        }, 2));
                    }
                    return ItemCollector.EMPTY;
                });
            }
            catch (ExecutionException e2) {
                return null;
            }
            if (itemCollector == ItemCollector.EMPTY) {
                return null;
            }
            return itemCollector.update(target, world.X());
        });
        tileItemProviders.register(TileEntityCampfire.class, (player, world, target) -> {
            TileEntityCampfire campfire = (TileEntityCampfire)target;
            ArrayList list = Lists.newArrayList();
            for (int i2 = 0; i2 < campfire.e.length; ++i2) {
                ItemStack stack = campfire.c().get(i2);
                if (stack.b()) continue;
                stack = stack.p();
                stack.w().a("jade:cooking", campfire.e[i2] - campfire.d[i2]);
                list.add(stack);
            }
            return List.of(new ViewGroup(list));
        });
        tileItemProviders.register(TileEntity.class, (player, world, target) -> {
            ItemCollector itemCollector;
            IInventory te;
            if (target instanceof RandomizableContainer && (te = (RandomizableContainer)((Object)target)).az_() != null) {
                return List.of();
            }
            if (!player.f() && !player.P_() && target instanceof TileEntityContainer) {
                te = (TileEntityContainer)target;
                if (((TileEntityContainer)te).e != ChestLock.a) {
                    return List.of();
                }
            }
            if (target instanceof TileEntityEnderChest) {
                InventoryEnderChest inventory = player.gf();
                return new ItemCollector<IInventory>(new ItemIterator.ContainerItemIterator(0)).update(inventory, world.X());
            }
            try {
                itemCollector = (ItemCollector)targetCache.get(target, () -> {
                    if (target instanceof IInventory) {
                        if (target instanceof TileEntityChest) {
                            return new ItemCollector<IInventory>(new ItemIterator.ContainerItemIterator(o2 -> {
                                if (o2 instanceof TileEntityChest) {
                                    BlockChest chestBlock;
                                    IInventory compound;
                                    TileEntityChest be = (TileEntityChest)o2;
                                    Block patt8996$temp = be.r().b();
                                    if (patt8996$temp instanceof BlockChest && (compound = BlockChest.a(chestBlock = (BlockChest)patt8996$temp, be.r(), world, be.aB_(), false)) != null) {
                                        return compound;
                                    }
                                    return be;
                                }
                                return null;
                            }, 0));
                        }
                        return new ItemCollector<IInventory>(new ItemIterator.ContainerItemIterator(0));
                    }
                    return ItemCollector.EMPTY;
                });
            }
            catch (ExecutionException e2) {
                return null;
            }
            if (itemCollector == ItemCollector.EMPTY) {
                return null;
            }
            return itemCollector.update(target, world.X());
        });
        entityDataProviders.register(OwnableEntity.class, (data, player, world, entity, showDetails) -> {
            UserCache cache;
            UUID ownerUUID = ((OwnableEntity)((Object)entity)).d();
            if (ownerUUID != null && (cache = MinecraftServer.getServer().ar()) != null) {
                cache.a(ownerUUID).map(GameProfile::getName).ifPresent(name -> data.a("OwnerName", (String)name));
            }
        });
        entityDataProviders.register(EntityLiving.class, (data, player, world, entity, showDetails) -> {
            EntityLiving living = (EntityLiving)entity;
            Collection<MobEffect> effects = living.es();
            if (effects.isEmpty()) {
                return;
            }
            NBTTagList list = new NBTTagList();
            for (MobEffect effect : effects) {
                NBTTagCompound compound = new NBTTagCompound();
                compound.a("Name", IChatBaseComponent.ChatSerializer.a(JadeProtocol.getEffectName(effect)));
                if (effect.b()) {
                    compound.a("Infinite", true);
                } else {
                    compound.a("Duration", effect.d());
                }
                compound.a("Bad", effect.c().f() == MobEffectInfo.b);
                list.add(compound);
            }
            data.a("StatusEffects", list);
        });
        entityDataProviders.register(EntityAgeable.class, (data, player, world, entity, showDetails) -> {
            int time = -((EntityAgeable)entity).h();
            if (time > 0) {
                data.a("GrowingTime", time);
            }
        });
        entityDataProviders.register(Tadpole.class, (data, player, world, entity, showDetails) -> {
            int time = ((Tadpole)entity).gj();
            if (time > 0) {
                data.a("GrowingTime", time);
            }
        });
        entityDataProviders.register(EntityAnimal.class, (data, player, world, entity, showDetails) -> {
            int time = ((EntityAnimal)entity).h();
            if (time > 0) {
                data.a("BreedingCD", time);
            }
        });
        entityDataProviders.register(Allay.class, (data, player, world, entity, showDetails) -> {
            int time = 0;
            Allay allay = (Allay)entity;
            if (allay.ci > 0L && allay.ci < Integer.MAX_VALUE) {
                time = (int)allay.ci;
            }
            if (time > 0) {
                data.a("BreedingCD", time);
            }
        });
        entityDataProviders.register(EntityChicken.class, (data, player, world, entity, showDetails) -> data.a("NextEggIn", ((EntityChicken)entity).bZ));
        entityDataProviders.register(Entity.class, (tag, player, world, object, showDetails) -> {
            for (IServerExtensionProvider<Entity, ItemStack> provider : entityItemProviders.get(object)) {
                List groups = provider.getGroups(player, world, (Entity)object);
                if (groups == null) continue;
                if (!ViewGroup.saveList(tag, "JadeItemStorage", groups, item -> {
                    NBTTagCompound itemTag = new NBTTagCompound();
                    int count = item.L();
                    if (count > 64) {
                        item.f(1);
                    }
                    item.b(itemTag);
                    if (count > 64) {
                        itemTag.a("NewCount", count);
                        item.f(count);
                    }
                    return itemTag;
                })) break;
                tag.a("JadeItemStorageUid", "minecraft:item_storage");
                break;
            }
        });
        entityDataProviders.register(EntityZombieVillager.class, (data, player, world, object, showDetails) -> {
            EntityZombieVillager entity = (EntityZombieVillager)object;
            if (entity.cb > 0) {
                data.a("ConversionTime", entity.cb);
            }
        });
        tileDataProviders.register(TileEntityBrewingStand.class, (data, player, world, object, showDetails) -> {
            if (object instanceof TileEntityBrewingStand) {
                TileEntityBrewingStand brewingStand = (TileEntityBrewingStand)object;
                NBTTagCompound compound = new NBTTagCompound();
                compound.a("Time", brewingStand.n);
                compound.a("Fuel", brewingStand.t);
                data.a("BrewingStand", compound);
            }
        });
        tileDataProviders.register(TileEntityBeehive.class, (data, player, world, object, showDetails) -> {
            data.e().clear();
            TileEntityBeehive beehive = (TileEntityBeehive)object;
            data.a("Bees", (byte)beehive.g());
            data.a("Full", beehive.f());
        });
        tileDataProviders.register(TileEntityCommand.class, (data, player, world, object, showDetails) -> {
            if (!player.gp()) {
                return;
            }
            CommandBlockListenerAbstract logic = ((TileEntityCommand)object).c();
            Object command = logic.m();
            if (((String)command).isEmpty()) {
                return;
            }
            if (((String)command).length() > 40) {
                command = ((String)command).substring(0, 37) + "...";
            }
            data.a("Command", (String)command);
        });
        tileDataProviders.register(TileEntityJukeBox.class, (data, player, world, object, showDetails) -> {
            TileEntityJukeBox jukebox;
            ItemStack stack;
            if (object instanceof TileEntityJukeBox && !(stack = (jukebox = (TileEntityJukeBox)object).x()).b()) {
                data.a("Record", stack.b(new NBTTagCompound()));
            }
        });
        tileDataProviders.register(TileEntityLectern.class, (data, player, world, object, showDetails) -> {
            ItemStack stack = ((TileEntityLectern)object).c();
            if (!stack.b() && (stack.A() || stack.d() != Items.tT)) {
                data.a("Book", stack.b(new NBTTagCompound()));
            }
        });
        tileDataProviders.register(TileEntityComparator.class, (data, player, world, object, showDetails) -> data.a("Signal", ((TileEntityComparator)object).c()));
        tileDataProviders.register(TileEntityHopper.class, (data, player, world, object, showDetails) -> {
            IBlockData state = object.r();
            if (state.b(BlockProperties.f) && !state.c(BlockProperties.f).booleanValue()) {
                data.a("HopperLocked", true);
            }
        });
        tileDataProviders.register(TileEntityFurnace.class, (data, player, world, object, showDetails) -> {
            TileEntityFurnace furnace = (TileEntityFurnace)object;
            NBTTagList items = new NBTTagList();
            for (int i2 = 0; i2 < 3; ++i2) {
                items.add(furnace.a(i2).b(new NBTTagCompound()));
            }
            data.a("furnace", items);
            NBTTagCompound furnaceTag = furnace.q();
            data.a("progress", furnaceTag.h("CookTime"));
            data.a("total", furnaceTag.h("CookTimeTotal"));
        });
        tileDataProviders.register(TileEntity.class, (data, player, world, object, showDetails) -> {
            if (object instanceof INamableTileEntity) {
                INamableTileEntity nameable = (INamableTileEntity)((Object)object);
                IChatBaseComponent name = null;
                if (nameable instanceof TileEntityChest) {
                    TileEntityChest chestBlock = (TileEntityChest)nameable;
                    ITileInventory menuProvider = chestBlock.r().b(world, chestBlock.aB_());
                    if (menuProvider != null) {
                        name = menuProvider.Q_();
                    }
                } else if (nameable.ae()) {
                    name = nameable.Q_();
                }
                if (name != null) {
                    data.a("givenName", IChatBaseComponent.ChatSerializer.a(name));
                }
            }
        });
        tileDataProviders.register(ChiseledBookShelfBlockEntity.class, (data, player, world, object, showDetails) -> {
            ChiseledBookShelfBlockEntity bookShelf = (ChiseledBookShelfBlockEntity)object;
            if (!bookShelf.ai_()) {
                data.a("Bookshelf", bookShelf.q());
            }
        });
        tileDataProviders.register(TileEntity.class, (tag, player, world, object, showDetails) -> {
            if (object instanceof TileEntityFurnace) {
                return;
            }
            for (IServerExtensionProvider<TileEntity, ItemStack> provider : tileItemProviders.get(object)) {
                RandomizableContainer containerEntity;
                List groups = provider.getGroups(player, world, (TileEntity)object);
                if (groups == null) continue;
                if (ViewGroup.saveList(tag, "JadeItemStorage", groups, item -> {
                    NBTTagCompound itemTag = new NBTTagCompound();
                    int count = item.L();
                    if (count > 64) {
                        item.f(1);
                    }
                    item.b(itemTag);
                    if (count > 64) {
                        itemTag.a("NewCount", count);
                        item.f(count);
                    }
                    return itemTag;
                })) {
                    tag.a("JadeItemStorageUid", "minecraft:item_storage");
                    break;
                }
                if (object instanceof RandomizableContainer && (containerEntity = (RandomizableContainer)((Object)object)).az_() != null) {
                    tag.a("Loot", true);
                    break;
                }
                if (player.f() || player.P_() || !(object instanceof TileEntityContainer)) break;
                TileEntityContainer te = (TileEntityContainer)object;
                if (te.e == ChestLock.a) break;
                tag.a("Locked", true);
                break;
            }
        });
        tileDataProviders.register(TrialSpawnerBlockEntity.class, (data, player, world, object, showDetails) -> {
            TrialSpawnerBlockEntity spawner = (TrialSpawnerBlockEntity)object;
            TrialSpawnerData spawnerData = spawner.d().c();
            if (spawner.d().a(world) && world.X() < spawnerData.e) {
                data.a("Cooldown", (int)(spawnerData.e - world.X()));
            }
        });
        tileDataProviders.register(CalibratedSculkSensorBlockEntity.class, (data, player, world, object, showDetails) -> {
            EnumDirection direction = object.r().c(CalibratedSculkSensorBlock.b).g();
            int signal = world.c(object.aB_().a(direction), direction);
            data.a("Signal", signal);
        });
    }

    @ProtocolHandler.PlayerJoin
    public static void onPlayerJoin(EntityPlayer player) {
        if (LeavesConfig.jadeProtocol) {
            ProtocolUtils.sendPayloadPacket(player, PACKET_SERVER_PING, buf -> buf.a("{}"));
        }
    }

    @ProtocolHandler.PayloadReceiver(payload=RequestEntityPayload.class, payloadId={"request_entity"})
    public static void requestEntityData(EntityPlayer player, RequestEntityPayload payload) {
        if (!LeavesConfig.jadeProtocol) {
            return;
        }
        MinecraftServer server = MinecraftServer.getServer();
        server.execute(() -> {
            List<IJadeDataProvider<Entity>> providers;
            EntityEnderDragon dragon;
            EntityComplexPart[] parts;
            World world = player.dM();
            boolean showDetails = payload.showDetails;
            Entity entity = world.a(payload.entityId);
            if (entity == null || player.f(entity) > 900.0) {
                return;
            }
            if (payload.partIndex >= 0 && entity instanceof EntityEnderDragon && payload.partIndex < (parts = (dragon = (EntityEnderDragon)entity).ga()).length) {
                entity = parts[payload.partIndex];
            }
            if ((providers = entityDataProviders.get(entity)).isEmpty()) {
                return;
            }
            NBTTagCompound tag = new NBTTagCompound();
            for (IJadeDataProvider<Entity> provider : providers) {
                try {
                    provider.saveData(tag, player, world, entity, showDetails);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            tag.a("WailaEntityID", entity.aj());
            ProtocolUtils.sendPayloadPacket(player, PACKET_RECEIVE_DATA, buf -> buf.a(tag));
        });
    }

    @ProtocolHandler.PayloadReceiver(payload=RequestTilePayload.class, payloadId={"request_tile"})
    public static void requestTileData(EntityPlayer player, RequestTilePayload payload) {
        if (!LeavesConfig.jadeProtocol) {
            return;
        }
        MinecraftServer server = MinecraftServer.getServer();
        boolean showDetails = payload.showDetails;
        MovingObjectPositionBlock result = payload.hitResult;
        BlockPosition pos = result.a();
        World world = player.dM();
        if (pos.j(player.dm()) > 900.0 || !world.p(pos)) {
            return;
        }
        server.execute(() -> {
            TileEntity tile = world.c_(pos);
            if (tile == null) {
                return;
            }
            List<IJadeDataProvider<TileEntity>> providers = tileDataProviders.get(tile);
            if (providers.isEmpty()) {
                return;
            }
            NBTTagCompound tag = new NBTTagCompound();
            for (IJadeDataProvider<TileEntity> provider : providers) {
                try {
                    provider.saveData(tag, player, world, tile, showDetails);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            tag.a("x", pos.u());
            tag.a("y", pos.v());
            tag.a("z", pos.w());
            tag.a("id", BuiltInRegistries.k.b(tile.v()).toString());
            ProtocolUtils.sendPayloadPacket(player, PACKET_RECEIVE_DATA, buf -> buf.a(tag));
        });
    }

    @ProtocolHandler.ReloadServer
    public static void onServerReload() {
        if (LeavesConfig.jadeProtocol) {
            JadeProtocol.enableAllPlayer();
        }
    }

    public static void enableAllPlayer() {
        for (EntityPlayer player : MinecraftServer.getServer().ae().l) {
            JadeProtocol.onPlayerJoin(player);
        }
    }

    public static IChatBaseComponent getEffectName(MobEffect mobEffectInstance) {
        IChatMutableComponent mutableComponent = mobEffectInstance.c().e().f();
        if (mobEffectInstance.e() >= 1 && mobEffectInstance.e() <= 9) {
            mutableComponent.b(CommonComponents.u).b(IChatBaseComponent.c("enchantment.level." + (mobEffectInstance.e() + 1)));
        }
        return mutableComponent;
    }

    public static class HierarchyLookup<T> {
        private final Class<?> baseClass;
        private final Cache<Class<?>, List<T>> resultCache = CacheBuilder.newBuilder().build();
        private final boolean singleton;
        private ListMultimap<Class<?>, T> objects = ArrayListMultimap.create();

        public HierarchyLookup(Class<?> baseClass) {
            this(baseClass, false);
        }

        public HierarchyLookup(Class<?> baseClass, boolean singleton) {
            this.baseClass = baseClass;
            this.singleton = singleton;
        }

        public void register(Class<?> clazz, T provider) {
            Objects.requireNonNull(clazz);
            this.objects.put(clazz, provider);
        }

        public List<T> get(Object obj) {
            if (obj == null) {
                return List.of();
            }
            return this.get(obj.getClass());
        }

        public List<T> get(Class<?> clazz) {
            try {
                return (List)this.resultCache.get(clazz, () -> {
                    ArrayList list = Lists.newArrayList();
                    this.getInternal(clazz, list);
                    if (this.singleton && !list.isEmpty()) {
                        return ImmutableList.of(list.get(0));
                    }
                    return list;
                });
            }
            catch (ExecutionException e2) {
                e2.printStackTrace();
                return List.of();
            }
        }

        private void getInternal(Class<?> clazz, List<T> list) {
            if (clazz != this.baseClass && clazz != Object.class) {
                this.getInternal(clazz.getSuperclass(), list);
            }
            list.addAll(this.objects.get(clazz));
        }

        public Multimap<Class<?>, T> getObjects() {
            return this.objects;
        }
    }

    public static interface IServerExtensionProvider<IN, OUT> {
        public List<ViewGroup<OUT>> getGroups(EntityPlayer var1, World var2, IN var3);
    }

    public static interface IJadeDataProvider<T> {
        public void saveData(NBTTagCompound var1, EntityPlayer var2, World var3, T var4, boolean var5);
    }

    public record RequestEntityPayload(boolean showDetails, int entityId, int partIndex, float hitX, float hitY, float hitZ) implements CustomPacketPayload
    {
        private static final MinecraftKey PACKET_REQUEST_ENTITY = JadeProtocol.id("request_entity");

        public RequestEntityPayload(MinecraftKey id, PacketDataSerializer buf) {
            this(buf.readBoolean(), buf.n(), buf.n(), buf.readFloat(), buf.readFloat(), buf.readFloat());
        }

        @Override
        public void a(PacketDataSerializer buf) {
            buf.a(this.showDetails);
            buf.c(this.entityId);
            buf.c(this.partIndex);
            buf.a(this.hitX);
            buf.a(this.hitY);
            buf.a(this.hitZ);
        }

        @Override
        @NotNull
        public MinecraftKey a() {
            return PACKET_REQUEST_ENTITY;
        }
    }

    public record RequestTilePayload(boolean showDetails, MovingObjectPositionBlock hitResult, int blockState, ItemStack fakeBlock) implements CustomPacketPayload
    {
        private static final MinecraftKey PACKET_REQUEST_TILE = JadeProtocol.id("request_tile");

        public RequestTilePayload(MinecraftKey id, PacketDataSerializer buf) {
            this(buf.readBoolean(), buf.y(), buf.n(), buf.r());
        }

        @Override
        public void a(PacketDataSerializer buf) {
            buf.a(this.showDetails);
            buf.a(this.hitResult);
            buf.c(this.blockState);
            buf.a(this.fakeBlock);
        }

        @Override
        @NotNull
        public MinecraftKey a() {
            return PACKET_REQUEST_TILE;
        }
    }

    public static class ViewGroup<T> {
        public final List<T> views;
        @Nullable
        public String id;
        @Nullable
        protected NBTTagCompound extraData;

        public ViewGroup(List<T> views) {
            this.views = views;
        }

        public void save(NBTTagCompound tag, Function<T, NBTTagCompound> writer) {
            NBTTagList list = new NBTTagList();
            for (T view : this.views) {
                list.add((NBTBase)writer.apply(view));
            }
            tag.a("Views", list);
            if (this.id != null) {
                tag.a("Id", this.id);
            }
            if (this.extraData != null) {
                tag.a("Data", this.extraData);
            }
        }

        public static <T> boolean saveList(NBTTagCompound tag, String key, List<ViewGroup<T>> groups, Function<T, NBTTagCompound> writer) {
            if (groups == null || groups.isEmpty()) {
                return false;
            }
            NBTTagList groupList = new NBTTagList();
            for (ViewGroup<T> group : groups) {
                if (group.views.isEmpty()) continue;
                NBTTagCompound groupTag = new NBTTagCompound();
                group.save(groupTag, writer);
                groupList.add(groupTag);
            }
            if (!groupList.isEmpty()) {
                tag.a(key, groupList);
                return true;
            }
            return false;
        }

        public NBTTagCompound getExtraData() {
            if (this.extraData == null) {
                this.extraData = new NBTTagCompound();
            }
            return this.extraData;
        }
    }

    public static class ItemCollector<T> {
        public static final int MAX_SIZE = 54;
        public static final ItemCollector<?> EMPTY = new ItemCollector(null);
        private static final Predicate<ItemStack> NON_EMPTY = stack -> {
            if (stack.b()) {
                return false;
            }
            NBTTagCompound tag = stack.v();
            if (tag != null && tag.e("CustomModelData")) {
                for (String key : stack.v().e()) {
                    if (!key.toLowerCase(Locale.ENGLISH).endsWith("clear") || !stack.v().q(key)) continue;
                    return false;
                }
            }
            return true;
        };
        private final Object2IntLinkedOpenHashMap<ItemDefinition> items = new Object2IntLinkedOpenHashMap();
        private final ItemIterator<T> iterator;
        public long version;
        public long lastTimeFinished;
        public List<ViewGroup<ItemStack>> mergedResult;

        public ItemCollector(ItemIterator<T> iterator) {
            this.iterator = iterator;
        }

        public List<ViewGroup<ItemStack>> update(Object target, long gameTime) {
            if (this.iterator == null) {
                return null;
            }
            T container = this.iterator.find(target);
            if (container == null) {
                return null;
            }
            long currentVersion = this.iterator.getVersion(container);
            if (this.mergedResult != null && this.iterator.isFinished()) {
                if (this.version == currentVersion) {
                    return this.mergedResult;
                }
                if (this.lastTimeFinished + 5L > gameTime) {
                    return this.mergedResult;
                }
                this.iterator.reset();
            }
            AtomicInteger count = new AtomicInteger();
            this.iterator.populate(container).forEach(stack -> {
                count.incrementAndGet();
                if (NON_EMPTY.test((ItemStack)stack)) {
                    ItemDefinition def = new ItemDefinition((ItemStack)stack);
                    this.items.addTo((Object)def, stack.L());
                }
            });
            this.iterator.afterPopulate(count.get());
            if (this.mergedResult != null && !this.iterator.isFinished()) {
                this.updateCollectingProgress(this.mergedResult.get(0));
                return this.mergedResult;
            }
            List<ItemStack> partialResult = this.items.object2IntEntrySet().stream().limit(54L).map(entry -> {
                ItemDefinition def = (ItemDefinition)entry.getKey();
                return def.toStack(entry.getIntValue());
            }).toList();
            List<ViewGroup<ItemStack>> groups = List.of(this.updateCollectingProgress(new ViewGroup<ItemStack>(partialResult)));
            if (this.iterator.isFinished()) {
                this.mergedResult = groups;
                this.version = currentVersion;
                this.lastTimeFinished = gameTime;
                this.items.clear();
            }
            return groups;
        }

        protected ViewGroup<ItemStack> updateCollectingProgress(ViewGroup<ItemStack> group) {
            float progress = this.iterator.getCollectingProgress();
            NBTTagCompound data = group.getExtraData();
            if (Float.isNaN(progress)) {
                progress = 0.0f;
            }
            if (progress >= 1.0f) {
                data.r("Collecting");
            } else {
                data.a("Collecting", progress);
            }
            return group;
        }

        public record ItemDefinition(Item item, @Nullable NBTTagCompound tag) {
            ItemDefinition(ItemStack stack) {
                this(stack.d(), stack.v());
            }

            public ItemStack toStack(int count) {
                ItemStack stack = new ItemStack(this.item);
                stack.f(count);
                stack.c(this.tag);
                return stack;
            }
        }
    }

    public static abstract class ItemIterator<T> {
        public static final AtomicLong version = new AtomicLong();
        protected final Function<Object, @Nullable T> containerFinder;
        protected final int fromIndex;
        protected boolean finished;
        protected int currentIndex;

        protected ItemIterator(Function<Object, @Nullable T> containerFinder, int fromIndex) {
            this.containerFinder = containerFinder;
            this.currentIndex = this.fromIndex = fromIndex;
        }

        @Nullable
        public T find(Object target) {
            return this.containerFinder.apply(target);
        }

        public final boolean isFinished() {
            return this.finished;
        }

        public long getVersion(T container) {
            return version.getAndIncrement();
        }

        public abstract Stream<ItemStack> populate(T var1);

        public void reset() {
            this.currentIndex = this.fromIndex;
            this.finished = false;
        }

        public void afterPopulate(int count) {
            this.currentIndex += count;
            if (count == 0 || this.currentIndex >= 10000) {
                this.finished = true;
            }
        }

        public float getCollectingProgress() {
            return Float.NaN;
        }

        public static class ContainerItemIterator
        extends SlottedItemIterator<IInventory> {
            public ContainerItemIterator(int fromIndex) {
                this(IInventory.class::cast, fromIndex);
            }

            public ContainerItemIterator(Function<Object, @Nullable IInventory> containerFinder, int fromIndex) {
                super(containerFinder, fromIndex);
            }

            @Override
            protected int getSlotCount(IInventory container) {
                return container.b();
            }

            @Override
            protected ItemStack getItemInSlot(IInventory container, int slot) {
                return container.a(slot);
            }
        }

        public static abstract class SlottedItemIterator<T>
        extends ItemIterator<T> {
            protected float progress;

            public SlottedItemIterator(Function<Object, @Nullable T> containerFinder, int fromIndex) {
                super(containerFinder, fromIndex);
            }

            protected abstract int getSlotCount(T var1);

            protected abstract ItemStack getItemInSlot(T var1, int var2);

            @Override
            public Stream<ItemStack> populate(T container) {
                int toIndex = this.currentIndex + 108;
                int slotCount = this.getSlotCount(container);
                if (toIndex >= slotCount) {
                    toIndex = slotCount;
                    this.finished = true;
                }
                this.progress = (float)(this.currentIndex - this.fromIndex) / (float)(slotCount - this.fromIndex);
                return IntStream.range(this.currentIndex, toIndex).mapToObj(slot -> this.getItemInSlot(container, slot));
            }

            @Override
            public float getCollectingProgress() {
                return this.progress;
            }
        }
    }

    public static interface IJadeProvider {
    }
}

