/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol.core;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.runtime.ObjectMethods;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import org.apache.commons.lang.ArrayUtils;
import org.bukkit.event.player.PlayerKickEvent;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.protocol.core.LeavesProtocol;
import top.leavesmc.leaves.protocol.core.ProtocolHandler;

public class LeavesProtocolManager {
    private static final Map<LeavesProtocol, Map<ProtocolHandler.PayloadReceiver, Constructor<? extends CustomPacketPayload>>> KNOWN_TYPES = new HashMap<LeavesProtocol, Map<ProtocolHandler.PayloadReceiver, Constructor<? extends CustomPacketPayload>>>();
    private static final Map<LeavesProtocol, Map<ProtocolHandler.PayloadReceiver, Method>> KNOW_RECEIVERS = new HashMap<LeavesProtocol, Map<ProtocolHandler.PayloadReceiver, Method>>();
    private static final List<Method> TICKERS = new ArrayList<Method>();
    private static final List<Method> PLAYER_JOIN = new ArrayList<Method>();
    private static final List<Method> PLAYER_LEAVE = new ArrayList<Method>();
    private static final List<Method> RELOAD_SERVER = new ArrayList<Method>();
    private static final Map<LeavesProtocol, Map<ProtocolHandler.MinecraftRegister, Method>> MINECRAFT_REGISTER = new HashMap<LeavesProtocol, Map<ProtocolHandler.MinecraftRegister, Method>>();

    public static void init() {
        for (Class<?> clazz : LeavesProtocolManager.getClasses("top.leavesmc.leaves.protocol")) {
            HashSet methods;
            LeavesProtocol protocol = clazz.getAnnotation(LeavesProtocol.class);
            if (protocol == null) continue;
            try {
                Method[] publicMethods = clazz.getMethods();
                Method[] privateMethods = clazz.getDeclaredMethods();
                methods = new HashSet(publicMethods.length + privateMethods.length, 1.0f);
                Collections.addAll(methods, publicMethods);
                Collections.addAll(methods, privateMethods);
            }
            catch (NoClassDefFoundError e2) {
                e2.printStackTrace();
                return;
            }
            Map map = KNOWN_TYPES.getOrDefault(protocol, new HashMap());
            for (Method method : methods) {
                if (method.isBridge() || method.isSynthetic() || !Modifier.isStatic(method.getModifiers())) continue;
                method.setAccessible(true);
                ProtocolHandler.Init init = method.getAnnotation(ProtocolHandler.Init.class);
                if (init != null) {
                    try {
                        method.invoke(null, new Object[0]);
                    }
                    catch (IllegalAccessException | InvocationTargetException e3) {
                        e3.printStackTrace();
                    }
                    continue;
                }
                ProtocolHandler.PayloadReceiver receiver = method.getAnnotation(ProtocolHandler.PayloadReceiver.class);
                if (receiver != null) {
                    try {
                        map.put(receiver, receiver.payload().getConstructor(MinecraftKey.class, PacketDataSerializer.class));
                    }
                    catch (NoSuchMethodException e4) {
                        e4.printStackTrace();
                        continue;
                    }
                    if (!KNOW_RECEIVERS.containsKey(protocol)) {
                        KNOW_RECEIVERS.put(protocol, new HashMap());
                    }
                    KNOW_RECEIVERS.get(protocol).put(receiver, method);
                    continue;
                }
                ProtocolHandler.Ticker ticker = method.getAnnotation(ProtocolHandler.Ticker.class);
                if (ticker != null) {
                    TICKERS.add(method);
                    continue;
                }
                ProtocolHandler.PlayerJoin playerJoin = method.getAnnotation(ProtocolHandler.PlayerJoin.class);
                if (playerJoin != null) {
                    PLAYER_JOIN.add(method);
                    continue;
                }
                ProtocolHandler.PlayerLeave playerLeave = method.getAnnotation(ProtocolHandler.PlayerLeave.class);
                if (playerLeave != null) {
                    PLAYER_LEAVE.add(method);
                    continue;
                }
                ProtocolHandler.ReloadServer reloadServer = method.getAnnotation(ProtocolHandler.ReloadServer.class);
                if (reloadServer != null) {
                    RELOAD_SERVER.add(method);
                    continue;
                }
                ProtocolHandler.MinecraftRegister minecraftRegister = method.getAnnotation(ProtocolHandler.MinecraftRegister.class);
                if (minecraftRegister == null) continue;
                if (!MINECRAFT_REGISTER.containsKey(protocol)) {
                    MINECRAFT_REGISTER.put(protocol, new HashMap());
                }
                MINECRAFT_REGISTER.get(protocol).put(minecraftRegister, method);
            }
            KNOWN_TYPES.put(protocol, map);
        }
    }

    public static CustomPacketPayload getPayload(MinecraftKey id, PacketDataSerializer buf) {
        for (LeavesProtocol protocol : KNOWN_TYPES.keySet()) {
            if (!ArrayUtils.contains((Object[])protocol.namespace(), (Object)id.b())) continue;
            Map<ProtocolHandler.PayloadReceiver, Constructor<? extends CustomPacketPayload>> map = KNOWN_TYPES.get(protocol);
            for (ProtocolHandler.PayloadReceiver receiver : map.keySet()) {
                if (!receiver.ignoreId() && !ArrayUtils.contains((Object[])receiver.payloadId(), (Object)id.a())) continue;
                try {
                    return map.get(receiver).newInstance(new Object[]{id, buf});
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e2) {
                    e2.printStackTrace();
                    buf.readBytes(buf.readableBytes());
                    return new ErrorPayload(id, protocol.namespace(), receiver.payloadId());
                }
            }
        }
        return null;
    }

    public static void handlePayload(EntityPlayer player, CustomPacketPayload payload) {
        if (payload instanceof ServerboundCustomPayloadPacket.UnknownPayload) {
            return;
        }
        if (payload instanceof ErrorPayload) {
            ErrorPayload errorPayload = (ErrorPayload)payload;
            player.c.disconnect("Payload " + Arrays.toString(errorPayload.packetID) + " from " + Arrays.toString(errorPayload.protocolID) + " error", PlayerKickEvent.Cause.INVALID_PAYLOAD);
            return;
        }
        for (LeavesProtocol protocol : KNOW_RECEIVERS.keySet()) {
            if (!ArrayUtils.contains((Object[])protocol.namespace(), (Object)payload.a().b())) continue;
            Map<ProtocolHandler.PayloadReceiver, Method> map = KNOW_RECEIVERS.get(protocol);
            for (ProtocolHandler.PayloadReceiver receiver : map.keySet()) {
                if (payload.getClass() != receiver.payload() || !receiver.ignoreId() && !ArrayUtils.contains((Object[])receiver.payloadId(), (Object)payload.a().a())) continue;
                try {
                    map.get(receiver).invoke(null, player, payload);
                }
                catch (IllegalAccessException | InvocationTargetException e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    public static void handleTick() {
        if (!TICKERS.isEmpty()) {
            try {
                for (Method method : TICKERS) {
                    method.invoke(null, new Object[0]);
                }
            }
            catch (IllegalAccessException | InvocationTargetException e2) {
                e2.printStackTrace();
            }
        }
    }

    public static void handlePlayerJoin(EntityPlayer player) {
        if (!PLAYER_JOIN.isEmpty()) {
            try {
                for (Method method : PLAYER_JOIN) {
                    method.invoke(null, player);
                }
            }
            catch (IllegalAccessException | InvocationTargetException e2) {
                e2.printStackTrace();
            }
        }
    }

    public static void handlePlayerLeave(EntityPlayer player) {
        if (!PLAYER_LEAVE.isEmpty()) {
            try {
                for (Method method : PLAYER_LEAVE) {
                    method.invoke(null, player);
                }
            }
            catch (IllegalAccessException | InvocationTargetException e2) {
                e2.printStackTrace();
            }
        }
    }

    public static void handleServerReload() {
        if (!RELOAD_SERVER.isEmpty()) {
            try {
                for (Method method : RELOAD_SERVER) {
                    method.invoke(null, new Object[0]);
                }
            }
            catch (IllegalAccessException | InvocationTargetException e2) {
                e2.printStackTrace();
            }
        }
    }

    public static void handleMinecraftRegister(String channelId, EntityPlayer player) {
        for (LeavesProtocol protocol : MINECRAFT_REGISTER.keySet()) {
            String[] channel = channelId.split(":");
            if (!ArrayUtils.contains((Object[])protocol.namespace(), (Object)channel[0])) continue;
            Map<ProtocolHandler.MinecraftRegister, Method> map = MINECRAFT_REGISTER.get(protocol);
            for (ProtocolHandler.MinecraftRegister register : map.keySet()) {
                if (!register.ignoreId() && !register.channelId().equals(channel[1]) && !ArrayUtils.contains((Object[])register.channelIds(), (Object)channel[1])) continue;
                try {
                    map.get(register).invoke(null, player);
                }
                catch (IllegalAccessException | InvocationTargetException e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    public static Set<Class<?>> getClasses(String pack) {
        LinkedHashSet classes = new LinkedHashSet();
        String packageDirName = pack.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), StandardCharsets.UTF_8);
                    LeavesProtocolManager.findClassesInPackageByFile(pack, filePath, classes);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                try {
                    JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                    Enumeration<JarEntry> entries = jar.entries();
                    LeavesProtocolManager.findClassesInPackageByJar(pack, entries, packageDirName, classes);
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        return classes;
    }

    private static void findClassesInPackageByFile(String packageName, String packagePath, Set<Class<?>> classes) {
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] dirfiles = dir.listFiles(file -> file.isDirectory() || file.getName().endsWith(".class"));
        if (dirfiles != null) {
            for (File file2 : dirfiles) {
                if (file2.isDirectory()) {
                    LeavesProtocolManager.findClassesInPackageByFile(packageName + "." + file2.getName(), file2.getAbsolutePath(), classes);
                    continue;
                }
                String className = file2.getName().substring(0, file2.getName().length() - 6);
                try {
                    classes.add(Class.forName(packageName + "." + className));
                }
                catch (ClassNotFoundException e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    private static void findClassesInPackageByJar(String packageName, Enumeration<JarEntry> entries, String packageDirName, Set<Class<?>> classes) {
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (name.charAt(0) == '/') {
                name = name.substring(1);
            }
            if (!name.startsWith(packageDirName)) continue;
            int idx = name.lastIndexOf(47);
            if (idx != -1) {
                packageName = name.substring(0, idx).replace('/', '.');
            }
            if (!name.endsWith(".class") || entry.isDirectory()) continue;
            String className = name.substring(packageName.length() + 1, name.length() - 6);
            try {
                classes.add(Class.forName(packageName + "." + className));
            }
            catch (ClassNotFoundException e2) {
                e2.printStackTrace();
            }
        }
    }

    public static final class ErrorPayload
    extends Record
    implements CustomPacketPayload {
        private final MinecraftKey id;
        private final String[] protocolID;
        private final String[] packetID;

        public ErrorPayload(MinecraftKey id, String[] protocolID, String[] packetID) {
            this.id = id;
            this.protocolID = protocolID;
            this.packetID = packetID;
        }

        @Override
        public void a(@NotNull PacketDataSerializer buf) {
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ErrorPayload.class, "id;protocolID;packetID", "id", "protocolID", "packetID"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ErrorPayload.class, "id;protocolID;packetID", "id", "protocolID", "packetID"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ErrorPayload.class, "id;protocolID;packetID", "id", "protocolID", "packetID"}, this, o2);
        }

        @Override
        public MinecraftKey a() {
            return this.id;
        }

        public String[] protocolID() {
            return this.protocolID;
        }

        public String[] packetID() {
            return this.packetID;
        }
    }

    public static final class LeavesPayload
    extends Record
    implements CustomPacketPayload {
        private final PacketDataSerializer data;
        private final MinecraftKey id;

        public LeavesPayload(MinecraftKey location, PacketDataSerializer buf) {
            this(new PacketDataSerializer(buf.readBytes(buf.readableBytes())), location);
        }

        public LeavesPayload(PacketDataSerializer data, MinecraftKey id) {
            this.data = data;
            this.id = id;
        }

        @Override
        public void a(PacketDataSerializer buf) {
            buf.b(this.data);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{LeavesPayload.class, "data;id", "data", "id"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LeavesPayload.class, "data;id", "data", "id"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LeavesPayload.class, "data;id", "data", "id"}, this, o2);
        }

        public PacketDataSerializer data() {
            return this.data;
        }

        @Override
        public MinecraftKey a() {
            return this.id;
        }
    }

    public static final class EmptyPayload
    extends Record
    implements CustomPacketPayload {
        private final MinecraftKey id;

        public EmptyPayload(MinecraftKey location, PacketDataSerializer buf) {
            this(location);
        }

        public EmptyPayload(MinecraftKey id) {
            this.id = id;
        }

        @Override
        public void a(@NotNull PacketDataSerializer buf) {
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{EmptyPayload.class, "id", "id"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{EmptyPayload.class, "id", "id"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{EmptyPayload.class, "id", "id"}, this, o2);
        }

        @Override
        public MinecraftKey a() {
            return this.id;
        }
    }
}

