/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol.syncmatica;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.protocol.syncmatica.CommunicationManager;
import top.leavesmc.leaves.protocol.syncmatica.PlayerIdentifier;
import top.leavesmc.leaves.protocol.syncmatica.SyncmaticaProtocol;
import top.leavesmc.leaves.protocol.syncmatica.exchange.ExchangeTarget;

public class PlayerIdentifierProvider {
    private final Map<UUID, PlayerIdentifier> identifiers = new HashMap<UUID, PlayerIdentifier>();

    public PlayerIdentifierProvider() {
        this.identifiers.put(PlayerIdentifier.MISSING_PLAYER_UUID, PlayerIdentifier.MISSING_PLAYER);
    }

    public PlayerIdentifier createOrGet(ExchangeTarget exchangeTarget) {
        SyncmaticaProtocol.getCommunicationManager();
        return this.createOrGet(CommunicationManager.getGameProfile(exchangeTarget));
    }

    public PlayerIdentifier createOrGet(@NotNull GameProfile gameProfile) {
        return this.createOrGet(gameProfile.getId(), gameProfile.getName());
    }

    public PlayerIdentifier createOrGet(UUID uuid, String playerName) {
        return this.identifiers.computeIfAbsent(uuid, id -> new PlayerIdentifier(uuid, playerName));
    }

    public void updateName(UUID uuid, String playerName) {
        this.createOrGet(uuid, playerName).updatePlayerName(playerName);
    }

    public PlayerIdentifier fromJson(@NotNull JsonObject obj) {
        if (!obj.has("uuid") || !obj.has("name")) {
            return PlayerIdentifier.MISSING_PLAYER;
        }
        UUID jsonUUID = UUID.fromString(obj.get("uuid").getAsString());
        return this.identifiers.computeIfAbsent(jsonUUID, key -> new PlayerIdentifier(jsonUUID, obj.get("name").getAsString()));
    }
}

