/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol.syncmatica;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.core.BlockPosition;

public class ServerPosition {
    private final BlockPosition position;
    private final String dimensionId;

    public ServerPosition(BlockPosition pos, String dim) {
        this.position = pos;
        this.dimensionId = dim;
    }

    public BlockPosition getBlockPosition() {
        return this.position;
    }

    public String getDimensionId() {
        return this.dimensionId;
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        JsonArray arr = new JsonArray();
        arr.add((JsonElement)new JsonPrimitive((Number)this.position.u()));
        arr.add((JsonElement)new JsonPrimitive((Number)this.position.v()));
        arr.add((JsonElement)new JsonPrimitive((Number)this.position.w()));
        obj.add("position", (JsonElement)arr);
        obj.add("dimension", (JsonElement)new JsonPrimitive(this.dimensionId));
        return obj;
    }

    public static ServerPosition fromJson(JsonObject obj) {
        if (obj.has("position") && obj.has("dimension")) {
            JsonArray arr = obj.get("position").getAsJsonArray();
            int x2 = arr.get(0).getAsInt();
            int y2 = arr.get(1).getAsInt();
            int z2 = arr.get(2).getAsInt();
            BlockPosition pos = new BlockPosition(x2, y2, z2);
            return new ServerPosition(pos, obj.get("dimension").getAsString());
        }
        return null;
    }
}

