/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol.syncmatica;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.protocol.syncmatica.SubRegionPlacementModification;

public class SubRegionData {
    private boolean isModified;
    private Map<String, SubRegionPlacementModification> modificationData;

    public SubRegionData() {
        this(false, null);
    }

    public SubRegionData(boolean isModified, Map<String, SubRegionPlacementModification> modificationData) {
        this.isModified = isModified;
        this.modificationData = modificationData;
    }

    public void reset() {
        this.isModified = false;
        this.modificationData = null;
    }

    public void modify(String name, BlockPosition position, EnumBlockRotation rotation, EnumBlockMirror mirror) {
        this.modify(new SubRegionPlacementModification(name, position, rotation, mirror));
    }

    public void modify(SubRegionPlacementModification subRegionPlacementModification) {
        if (subRegionPlacementModification == null) {
            return;
        }
        this.isModified = true;
        if (this.modificationData == null) {
            this.modificationData = new HashMap<String, SubRegionPlacementModification>();
        }
        this.modificationData.put(subRegionPlacementModification.name, subRegionPlacementModification);
    }

    public boolean isModified() {
        return this.isModified;
    }

    public Map<String, SubRegionPlacementModification> getModificationData() {
        return this.modificationData;
    }

    public JsonElement toJson() {
        return this.modificationDataToJson();
    }

    @NotNull
    private JsonElement modificationDataToJson() {
        JsonArray arr = new JsonArray();
        for (Map.Entry<String, SubRegionPlacementModification> entry : this.modificationData.entrySet()) {
            arr.add((JsonElement)entry.getValue().toJson());
        }
        return arr;
    }

    @NotNull
    public static SubRegionData fromJson(@NotNull JsonElement obj) {
        SubRegionData newSubRegionData = new SubRegionData();
        newSubRegionData.isModified = true;
        for (JsonElement modification : obj.getAsJsonArray()) {
            newSubRegionData.modify(SubRegionPlacementModification.fromJson(modification.getAsJsonObject()));
        }
        return newSubRegionData;
    }

    public String toString() {
        if (!this.isModified) {
            return "[]";
        }
        return this.modificationData == null ? "[ERROR:null]" : this.modificationData.toString();
    }
}

