/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol.syncmatica;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.protocol.syncmatica.ServerPlacement;
import top.leavesmc.leaves.protocol.syncmatica.SyncmaticaProtocol;

public class SyncmaticManager {
    public static final String PLACEMENTS_JSON_KEY = "placements";
    private final Map<UUID, ServerPlacement> schematics = new HashMap<UUID, ServerPlacement>();

    public void addPlacement(ServerPlacement placement) {
        this.schematics.put(placement.getId(), placement);
        this.updateServerPlacement();
    }

    public ServerPlacement getPlacement(UUID id) {
        return this.schematics.get(id);
    }

    public Collection<ServerPlacement> getAll() {
        return this.schematics.values();
    }

    public void removePlacement(@NotNull ServerPlacement placement) {
        this.schematics.remove(placement.getId());
        this.updateServerPlacement();
    }

    public void updateServerPlacement() {
        this.saveServer();
    }

    public void startup() {
        this.loadServer();
    }

    private void saveServer() {
        JsonObject obj = new JsonObject();
        JsonArray arr = new JsonArray();
        for (ServerPlacement p2 : this.getAll()) {
            arr.add((JsonElement)p2.toJson());
        }
        obj.add(PLACEMENTS_JSON_KEY, (JsonElement)arr);
        File backup = new File(SyncmaticaProtocol.getLitematicFolder(), "placements.json.bak");
        File incoming = new File(SyncmaticaProtocol.getLitematicFolder(), "placements.json.new");
        File current = new File(SyncmaticaProtocol.getLitematicFolder(), "placements.json");
        try (FileWriter writer = new FileWriter(incoming);){
            writer.write(new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)obj));
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return;
        }
        SyncmaticaProtocol.backupAndReplace(backup.toPath(), current.toPath(), incoming.toPath());
    }

    private void loadServer() {
        File f2 = new File(SyncmaticaProtocol.getLitematicFolder(), "placements.json");
        if (f2.exists() && f2.isFile() && f2.canRead()) {
            JsonElement element = null;
            try {
                JsonParser parser = new JsonParser();
                FileReader reader = new FileReader(f2);
                element = parser.parse((Reader)reader);
                reader.close();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            if (element == null) {
                return;
            }
            try {
                JsonObject obj = element.getAsJsonObject();
                if (obj == null || !obj.has(PLACEMENTS_JSON_KEY)) {
                    return;
                }
                JsonArray arr = obj.getAsJsonArray(PLACEMENTS_JSON_KEY);
                for (JsonElement elem : arr) {
                    ServerPlacement placement = ServerPlacement.fromJson(elem.getAsJsonObject());
                    if (placement == null) continue;
                    this.schematics.put(placement.getId(), placement);
                }
            }
            catch (IllegalStateException | NullPointerException e3) {
                e3.printStackTrace();
            }
        }
    }
}

