/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol.syncmatica;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.protocol.syncmatica.CommunicationManager;
import top.leavesmc.leaves.protocol.syncmatica.Feature;
import top.leavesmc.leaves.protocol.syncmatica.FeatureSet;
import top.leavesmc.leaves.protocol.syncmatica.FileStorage;
import top.leavesmc.leaves.protocol.syncmatica.PlayerIdentifierProvider;
import top.leavesmc.leaves.protocol.syncmatica.SyncmaticManager;

public class SyncmaticaProtocol {
    public static final String PROTOCOL_ID = "syncmatica";
    public static final String PROTOCOL_VERSION = "leaves-syncmatica-1.0.0";
    private static final File litematicFolder = new File("." + File.separator + "syncmatics");
    private static final PlayerIdentifierProvider playerIdentifierProvider = new PlayerIdentifierProvider();
    private static final CommunicationManager communicationManager = new CommunicationManager();
    private static final FeatureSet featureSet = new FeatureSet(Arrays.asList(Feature.values()));
    private static final SyncmaticManager syncmaticManager = new SyncmaticManager();
    private static final FileStorage fileStorage = new FileStorage();
    private static final int[] ILLEGAL_CHARS = new int[]{34, 60, 62, 124, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 58, 42, 63, 92, 47};
    private static final String ILLEGAL_PATTERNS = "(^(con|prn|aux|nul|com[0-9]|lpt[0-9])(\\..*)?$)|(^\\.\\.*$)";

    public static File getLitematicFolder() {
        return litematicFolder;
    }

    public static PlayerIdentifierProvider getPlayerIdentifierProvider() {
        return playerIdentifierProvider;
    }

    public static CommunicationManager getCommunicationManager() {
        return communicationManager;
    }

    public static FeatureSet getFeatureSet() {
        return featureSet;
    }

    public static SyncmaticManager getSyncmaticManager() {
        return syncmaticManager;
    }

    public static FileStorage getFileStorage() {
        return fileStorage;
    }

    public static void init() {
        litematicFolder.mkdirs();
        syncmaticManager.startup();
    }

    @NotNull
    public static UUID createChecksum(@NotNull InputStream fis) throws NoSuchAlgorithmException, IOException {
        int numRead;
        byte[] buffer = new byte[4096];
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        do {
            if ((numRead = fis.read(buffer)) <= 0) continue;
            messageDigest.update(buffer, 0, numRead);
        } while (numRead != -1);
        fis.close();
        return UUID.nameUUIDFromBytes(messageDigest.digest());
    }

    @NotNull
    public static String sanitizeFileName(@NotNull String badFileName) {
        StringBuilder sanitized = new StringBuilder();
        int len = badFileName.codePointCount(0, badFileName.length());
        for (int i2 = 0; i2 < len; ++i2) {
            int c2 = badFileName.codePointAt(i2);
            if (Arrays.binarySearch(ILLEGAL_CHARS, c2) >= 0) continue;
            sanitized.appendCodePoint(c2);
            if (sanitized.length() == 255) break;
        }
        return sanitized.toString().replaceAll(ILLEGAL_PATTERNS, "_");
    }

    public static boolean isOverQuota(int sent) {
        return LeavesConfig.syncmaticaQuota && sent > LeavesConfig.syncmaticaQuotaLimit;
    }

    public static void backupAndReplace(Path backup, Path current, Path incoming) {
        if (!Files.exists(incoming, new LinkOption[0])) {
            return;
        }
        if (SyncmaticaProtocol.overwrite(backup, current, 2) && !SyncmaticaProtocol.overwrite(current, incoming, 4)) {
            SyncmaticaProtocol.overwrite(current, backup, 8);
        }
    }

    private static boolean overwrite(Path backup, Path current, int tries) {
        if (!Files.exists(current, new LinkOption[0])) {
            return true;
        }
        try {
            Files.deleteIfExists(backup);
            Files.move(current, backup, new CopyOption[0]);
        }
        catch (IOException exception) {
            if (tries <= 0) {
                return false;
            }
            return SyncmaticaProtocol.overwrite(backup, current, tries - 1);
        }
        return true;
    }
}

