/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol.syncmatica.exchange;

import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.protocol.syncmatica.CommunicationManager;
import top.leavesmc.leaves.protocol.syncmatica.MessageType;
import top.leavesmc.leaves.protocol.syncmatica.PacketType;
import top.leavesmc.leaves.protocol.syncmatica.ServerPlacement;
import top.leavesmc.leaves.protocol.syncmatica.SyncmaticaProtocol;
import top.leavesmc.leaves.protocol.syncmatica.exchange.AbstractExchange;
import top.leavesmc.leaves.protocol.syncmatica.exchange.ExchangeTarget;

public class DownloadExchange
extends AbstractExchange {
    private final ServerPlacement toDownload;
    private final OutputStream outputStream;
    private final MessageDigest md5;
    private final File downloadFile;
    private int bytesSent;

    public DownloadExchange(ServerPlacement syncmatic, File downloadFile, ExchangeTarget partner) throws IOException, NoSuchAlgorithmException {
        super(partner);
        this.downloadFile = downloadFile;
        FileOutputStream os = new FileOutputStream(downloadFile);
        this.toDownload = syncmatic;
        this.md5 = MessageDigest.getInstance("MD5");
        this.outputStream = new DigestOutputStream(os, this.md5);
    }

    @Override
    public boolean checkPacket(@NotNull MinecraftKey id, PacketDataSerializer packetBuf) {
        if (id.equals(PacketType.SEND_LITEMATIC.identifier) || id.equals(PacketType.FINISHED_LITEMATIC.identifier) || id.equals(PacketType.CANCEL_LITEMATIC.identifier)) {
            return DownloadExchange.checkUUID(packetBuf, this.toDownload.getId());
        }
        return false;
    }

    @Override
    public void handle(@NotNull MinecraftKey id, @NotNull PacketDataSerializer packetBuf) {
        packetBuf.p();
        if (id.equals(PacketType.SEND_LITEMATIC.identifier)) {
            int size = packetBuf.readInt();
            this.bytesSent += size;
            if (SyncmaticaProtocol.isOverQuota(this.bytesSent)) {
                this.close(true);
                SyncmaticaProtocol.getCommunicationManager().sendMessage(this.getPartner(), MessageType.ERROR, "syncmatica.error.cancelled_transmit_exceed_quota");
            }
            try {
                packetBuf.a(this.outputStream, size);
            }
            catch (IOException e2) {
                this.close(true);
                e2.printStackTrace();
                return;
            }
            PacketDataSerializer FriendlyByteBuf = new PacketDataSerializer(Unpooled.buffer());
            FriendlyByteBuf.a(this.toDownload.getId());
            this.getPartner().sendPacket(PacketType.RECEIVED_LITEMATIC.identifier, FriendlyByteBuf);
            return;
        }
        if (id.equals(PacketType.FINISHED_LITEMATIC.identifier)) {
            try {
                this.outputStream.flush();
            }
            catch (IOException e3) {
                this.close(false);
                e3.printStackTrace();
                return;
            }
            UUID downloadHash = UUID.nameUUIDFromBytes(this.md5.digest());
            if (downloadHash.equals(this.toDownload.getHash())) {
                this.succeed();
            } else {
                this.close(false);
            }
            return;
        }
        if (id.equals(PacketType.CANCEL_LITEMATIC.identifier)) {
            this.close(false);
        }
    }

    @Override
    public void init() {
        PacketDataSerializer FriendlyByteBuf = new PacketDataSerializer(Unpooled.buffer());
        FriendlyByteBuf.a(this.toDownload.getId());
        this.getPartner().sendPacket(PacketType.REQUEST_LITEMATIC.identifier, FriendlyByteBuf);
    }

    @Override
    protected void onClose() {
        this.getManager();
        CommunicationManager.setDownloadState(this.toDownload, false);
        try {
            this.outputStream.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        if (!this.isSuccessful() && this.downloadFile.exists()) {
            this.downloadFile.delete();
        }
    }

    @Override
    protected void sendCancelPacket() {
        PacketDataSerializer FriendlyByteBuf = new PacketDataSerializer(Unpooled.buffer());
        FriendlyByteBuf.a(this.toDownload.getId());
        this.getPartner().sendPacket(PacketType.CANCEL_LITEMATIC.identifier, FriendlyByteBuf);
    }

    public ServerPlacement getPlacement() {
        return this.toDownload;
    }
}

