/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol.syncmatica.exchange;

import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.protocol.syncmatica.PacketType;
import top.leavesmc.leaves.protocol.syncmatica.ServerPlacement;
import top.leavesmc.leaves.protocol.syncmatica.exchange.AbstractExchange;
import top.leavesmc.leaves.protocol.syncmatica.exchange.ExchangeTarget;

public class UploadExchange
extends AbstractExchange {
    private static final int BUFFER_SIZE = 16384;
    private final ServerPlacement toUpload;
    private final InputStream inputStream;
    private final byte[] buffer = new byte[16384];

    public UploadExchange(ServerPlacement syncmatic, File uploadFile, ExchangeTarget partner) throws FileNotFoundException {
        super(partner);
        this.toUpload = syncmatic;
        this.inputStream = new FileInputStream(uploadFile);
    }

    @Override
    public boolean checkPacket(@NotNull MinecraftKey id, PacketDataSerializer packetBuf) {
        if (id.equals(PacketType.RECEIVED_LITEMATIC.identifier) || id.equals(PacketType.CANCEL_LITEMATIC.identifier)) {
            return UploadExchange.checkUUID(packetBuf, this.toUpload.getId());
        }
        return false;
    }

    @Override
    public void handle(@NotNull MinecraftKey id, @NotNull PacketDataSerializer packetBuf) {
        packetBuf.p();
        if (id.equals(PacketType.RECEIVED_LITEMATIC.identifier)) {
            this.send();
        }
        if (id.equals(PacketType.CANCEL_LITEMATIC.identifier)) {
            this.close(false);
        }
    }

    private void send() {
        int bytesRead;
        try {
            bytesRead = this.inputStream.read(this.buffer);
        }
        catch (IOException e2) {
            this.close(true);
            e2.printStackTrace();
            return;
        }
        if (bytesRead == -1) {
            this.sendFinish();
        } else {
            this.sendData(bytesRead);
        }
    }

    private void sendData(int bytesRead) {
        PacketDataSerializer FriendlyByteBuf = new PacketDataSerializer(Unpooled.buffer());
        FriendlyByteBuf.a(this.toUpload.getId());
        FriendlyByteBuf.p(bytesRead);
        FriendlyByteBuf.b(this.buffer, 0, bytesRead);
        this.getPartner().sendPacket(PacketType.SEND_LITEMATIC.identifier, FriendlyByteBuf);
    }

    private void sendFinish() {
        PacketDataSerializer FriendlyByteBuf = new PacketDataSerializer(Unpooled.buffer());
        FriendlyByteBuf.a(this.toUpload.getId());
        this.getPartner().sendPacket(PacketType.FINISHED_LITEMATIC.identifier, FriendlyByteBuf);
        this.succeed();
    }

    @Override
    public void init() {
        this.send();
    }

    @Override
    protected void onClose() {
        try {
            this.inputStream.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    protected void sendCancelPacket() {
        PacketDataSerializer FriendlyByteBuf = new PacketDataSerializer(Unpooled.buffer());
        FriendlyByteBuf.a(this.toUpload.getId());
        this.getPartner().sendPacket(PacketType.CANCEL_LITEMATIC.identifier, FriendlyByteBuf);
    }
}

