/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.region;

import com.github.luben.zstd.ZstdInputStream;
import com.github.luben.zstd.ZstdOutputStream;
import com.mojang.logging.LogUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.ChunkStatus;
import org.slf4j.Logger;
import top.leavesmc.leaves.region.AbstractRegionFile;
import top.leavesmc.leaves.region.LinearRegionFileFlusher;

public class LinearRegionFile
implements AbstractRegionFile,
AutoCloseable {
    private static final long SUPERBLOCK = -4323716122432332390L;
    private static final byte VERSION = 2;
    private static final int HEADER_SIZE = 32;
    private static final int FOOTER_SIZE = 8;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final List<Byte> SUPPORTED_VERSIONS = Arrays.asList((byte)1, (byte)2);
    private static final LinearRegionFileFlusher linearRegionFileFlusher = new LinearRegionFileFlusher();
    private final byte[][] buffer = new byte[1024][];
    private final int[] bufferUncompressedSize = new int[1024];
    private final int[] chunkTimestamps = new int[1024];
    private final ChunkStatus[] statuses = new ChunkStatus[1024];
    private final LZ4Compressor compressor;
    private final LZ4FastDecompressor decompressor;
    public final ReentrantLock fileLock = new ReentrantLock(true);
    private final int compressionLevel;
    private final AtomicBoolean markedToSave = new AtomicBoolean(false);
    public boolean closed = false;
    public Path path;

    public LinearRegionFile(Path file, int compression) throws IOException {
        this.path = file;
        this.compressionLevel = compression;
        this.compressor = LZ4Factory.fastestInstance().fastCompressor();
        this.decompressor = LZ4Factory.fastestInstance().fastDecompressor();
        File regionFile = new File(this.path.toString());
        Arrays.fill(this.bufferUncompressedSize, 0);
        if (!regionFile.canRead()) {
            return;
        }
        try (FileInputStream fileStream = new FileInputStream(regionFile);
             DataInputStream rawDataStream = new DataInputStream(fileStream);){
            long superBlock = rawDataStream.readLong();
            if (superBlock != -4323716122432332390L) {
                throw new RuntimeException("Invalid superblock: " + superBlock + " in " + file);
            }
            byte version = rawDataStream.readByte();
            if (!SUPPORTED_VERSIONS.contains(version)) {
                throw new RuntimeException("Invalid version: " + version + " in " + file);
            }
            rawDataStream.skipBytes(11);
            int dataCount = rawDataStream.readInt();
            long fileLength = file.toFile().length();
            if (fileLength != (long)(32 + dataCount + 8)) {
                throw new IOException("Invalid file length: " + this.path + " " + fileLength + " " + (32 + dataCount + 8));
            }
            rawDataStream.skipBytes(8);
            byte[] rawCompressed = new byte[dataCount];
            rawDataStream.readFully(rawCompressed, 0, dataCount);
            superBlock = rawDataStream.readLong();
            if (superBlock != -4323716122432332390L) {
                throw new IOException("Footer superblock invalid " + this.path);
            }
            try (DataInputStream dataStream = new DataInputStream((InputStream)new ZstdInputStream((InputStream)new ByteArrayInputStream(rawCompressed)));){
                int i2;
                int[] starts = new int[1024];
                for (i2 = 0; i2 < 1024; ++i2) {
                    starts[i2] = dataStream.readInt();
                    dataStream.skipBytes(4);
                }
                for (i2 = 0; i2 < 1024; ++i2) {
                    if (starts[i2] <= 0) continue;
                    int size = starts[i2];
                    byte[] b2 = new byte[size];
                    dataStream.readFully(b2, 0, size);
                    int maxCompressedLength = this.compressor.maxCompressedLength(size);
                    byte[] compressed = new byte[maxCompressedLength];
                    int compressedLength = this.compressor.compress(b2, 0, size, compressed, 0, maxCompressedLength);
                    b2 = new byte[compressedLength];
                    System.arraycopy(compressed, 0, b2, 0, compressedLength);
                    this.buffer[i2] = b2;
                    this.bufferUncompressedSize[i2] = size;
                }
            }
        }
    }

    @Override
    public Path getRegionFile() {
        return this.path;
    }

    @Override
    public ReentrantLock getFileLock() {
        return this.fileLock;
    }

    @Override
    public void a() throws IOException {
        if (this.isMarkedToSave()) {
            this.flushWrapper();
        }
    }

    private void markToSave() {
        linearRegionFileFlusher.scheduleSave(this);
        this.markedToSave.set(true);
    }

    public boolean isMarkedToSave() {
        return this.markedToSave.getAndSet(false);
    }

    public void flushWrapper() {
        try {
            this.save();
        }
        catch (IOException e2) {
            LOGGER.error("Failed to flush region file " + this.path.toAbsolutePath(), (Throwable)e2);
        }
    }

    @Override
    public boolean b(ChunkCoordIntPair pos) throws Exception {
        throw new Exception("doesChunkExist is a stub");
    }

    private synchronized void save() throws IOException {
        long timestamp = LinearRegionFile.getTimestamp();
        int chunkCount = 0;
        File tempFile = new File(this.path.toString() + ".tmp");
        try (FileOutputStream fileStream = new FileOutputStream(tempFile);
             ByteArrayOutputStream zstdByteArray = new ByteArrayOutputStream();
             ZstdOutputStream zstdStream = new ZstdOutputStream((OutputStream)zstdByteArray, this.compressionLevel);
             DataOutputStream zstdDataStream = new DataOutputStream((OutputStream)zstdStream);
             DataOutputStream dataStream = new DataOutputStream(fileStream);){
            int i2;
            dataStream.writeLong(-4323716122432332390L);
            dataStream.writeByte(2);
            dataStream.writeLong(timestamp);
            dataStream.writeByte(this.compressionLevel);
            ArrayList<byte[]> byteBuffers = new ArrayList<byte[]>();
            for (i2 = 0; i2 < 1024; ++i2) {
                if (this.bufferUncompressedSize[i2] != 0) {
                    chunkCount = (short)(chunkCount + 1);
                    byte[] content = new byte[this.bufferUncompressedSize[i2]];
                    this.decompressor.decompress(this.buffer[i2], 0, content, 0, this.bufferUncompressedSize[i2]);
                    byteBuffers.add(content);
                    continue;
                }
                byteBuffers.add(null);
            }
            for (i2 = 0; i2 < 1024; ++i2) {
                zstdDataStream.writeInt(this.bufferUncompressedSize[i2]);
                zstdDataStream.writeInt(this.chunkTimestamps[i2]);
            }
            for (i2 = 0; i2 < 1024; ++i2) {
                if (byteBuffers.get(i2) == null) continue;
                zstdDataStream.write((byte[])byteBuffers.get(i2), 0, ((byte[])byteBuffers.get(i2)).length);
            }
            zstdDataStream.close();
            dataStream.writeShort(chunkCount);
            byte[] compressed = zstdByteArray.toByteArray();
            dataStream.writeInt(compressed.length);
            dataStream.writeLong(0L);
            dataStream.write(compressed, 0, compressed.length);
            dataStream.writeLong(-4323716122432332390L);
            dataStream.flush();
            fileStream.getFD().sync();
            fileStream.getChannel().force(true);
        }
        Files.move(tempFile.toPath(), this.path, StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public void setStatus(int x2, int z2, ChunkStatus status) {
        this.statuses[LinearRegionFile.getChunkIndex((int)x2, (int)z2)] = status;
    }

    public synchronized void write(ChunkCoordIntPair pos, ByteBuffer buffer) {
        try {
            byte[] b2 = this.toByteArray(new ByteArrayInputStream(buffer.array()));
            int uncompressedSize = b2.length;
            int maxCompressedLength = this.compressor.maxCompressedLength(b2.length);
            byte[] compressed = new byte[maxCompressedLength];
            int compressedLength = this.compressor.compress(b2, 0, b2.length, compressed, 0, maxCompressedLength);
            b2 = new byte[compressedLength];
            System.arraycopy(compressed, 0, b2, 0, compressedLength);
            int index = LinearRegionFile.getChunkIndex(pos.e, pos.f);
            this.buffer[index] = b2;
            this.chunkTimestamps[index] = LinearRegionFile.getTimestamp();
            this.bufferUncompressedSize[LinearRegionFile.getChunkIndex((int)pos.e, (int)pos.f)] = uncompressedSize;
        }
        catch (IOException e2) {
            LOGGER.error("Chunk write IOException " + e2 + " " + this.path);
        }
        this.markToSave();
    }

    @Override
    public DataOutputStream c(ChunkCoordIntPair pos) {
        return new DataOutputStream(new BufferedOutputStream(new ChunkBuffer(pos)));
    }

    private byte[] toByteArray(InputStream in) throws IOException {
        int length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] tempBuffer = new byte[4096];
        while ((length = in.read(tempBuffer)) >= 0) {
            out.write(tempBuffer, 0, length);
        }
        return out.toByteArray();
    }

    @Override
    @Nullable
    public synchronized DataInputStream a(ChunkCoordIntPair pos) {
        if (this.bufferUncompressedSize[LinearRegionFile.getChunkIndex(pos.e, pos.f)] != 0) {
            byte[] content = new byte[this.bufferUncompressedSize[LinearRegionFile.getChunkIndex(pos.e, pos.f)]];
            this.decompressor.decompress(this.buffer[LinearRegionFile.getChunkIndex(pos.e, pos.f)], 0, content, 0, this.bufferUncompressedSize[LinearRegionFile.getChunkIndex(pos.e, pos.f)]);
            return new DataInputStream(new ByteArrayInputStream(content));
        }
        return null;
    }

    @Override
    public ChunkStatus getStatusIfCached(int x2, int z2) {
        return this.statuses[LinearRegionFile.getChunkIndex(x2, z2)];
    }

    @Override
    public void d(ChunkCoordIntPair pos) {
        int i2 = LinearRegionFile.getChunkIndex(pos.e, pos.f);
        this.buffer[i2] = null;
        this.bufferUncompressedSize[i2] = 0;
        this.chunkTimestamps[i2] = LinearRegionFile.getTimestamp();
        this.markToSave();
    }

    @Override
    public boolean e(ChunkCoordIntPair pos) {
        return this.bufferUncompressedSize[LinearRegionFile.getChunkIndex(pos.e, pos.f)] > 0;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.a();
    }

    private static int getChunkIndex(int x2, int z2) {
        return (x2 & 0x1F) + ((z2 & 0x1F) << 5);
    }

    private static int getTimestamp() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    @Override
    public boolean recalculateHeader() {
        return false;
    }

    @Override
    public void setOversized(int x2, int z2, boolean something) {
    }

    @Override
    public NBTTagCompound getOversizedData(int x2, int z2) throws IOException {
        throw new IOException("getOversizedData is a stub " + this.path);
    }

    @Override
    public boolean isOversized(int x2, int z2) {
        return false;
    }

    private class ChunkBuffer
    extends ByteArrayOutputStream {
        private final ChunkCoordIntPair pos;

        public ChunkBuffer(ChunkCoordIntPair chunkcoordintpair) {
            this.pos = chunkcoordintpair;
        }

        @Override
        public void close() {
            ByteBuffer bytebuffer = ByteBuffer.wrap(this.buf, 0, this.count);
            LinearRegionFile.this.write(this.pos, bytebuffer);
        }
    }
}

