/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.replay;

import io.netty.channel.local.LocalChannel;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.minecraft.SharedConstants;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.RegistrySynchronization;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.protocol.BundlePacket;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.common.ClientboundUpdateTagsPacket;
import net.minecraft.network.protocol.common.custom.BrandPayload;
import net.minecraft.network.protocol.configuration.ClientboundFinishConfigurationPacket;
import net.minecraft.network.protocol.configuration.ClientboundRegistryDataPacket;
import net.minecraft.network.protocol.configuration.ClientboundUpdateEnabledFeaturesPacket;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateTime;
import net.minecraft.network.protocol.login.PacketLoginOutSuccess;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.flag.FeatureFlags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.leavesmc.leaves.LeavesLogger;
import top.leavesmc.leaves.replay.RecordMetaData;
import top.leavesmc.leaves.replay.RecorderOption;
import top.leavesmc.leaves.replay.ReplayFile;
import top.leavesmc.leaves.replay.ServerPhotographer;

public class Recorder
extends NetworkManager {
    private static final LeavesLogger LOGGER = LeavesLogger.LOGGER;
    private final ReplayFile replayFile;
    private final ServerPhotographer photographer;
    private final RecorderOption recorderOption;
    private final RecordMetaData metaData;
    private final ExecutorService saveService = Executors.newSingleThreadExecutor();
    private boolean stopped = false;
    private boolean paused = false;
    private boolean resumeOnNextPacket = true;
    private long startTime;
    private long lastPacket;
    private long timeShift = 0L;
    private boolean isSaved;
    private boolean isSaving;
    private EnumProtocol state = EnumProtocol.d;

    public Recorder(ServerPhotographer photographer, RecorderOption recorderOption, File replayFile) throws IOException {
        super(EnumProtocolDirection.b);
        this.photographer = photographer;
        this.recorderOption = recorderOption;
        this.metaData = new RecordMetaData();
        this.replayFile = new ReplayFile(replayFile);
        this.n = new LocalChannel();
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
        this.metaData.singleplayer = false;
        this.metaData.serverName = this.recorderOption.serverName;
        this.metaData.generator = "leaves";
        this.metaData.date = this.startTime;
        this.metaData.mcversion = SharedConstants.b().c();
        this.savePacket(new PacketLoginOutSuccess(this.photographer.fR()), EnumProtocol.d);
        this.startConfiguration();
        if (this.recorderOption.forceWeather != null) {
            this.setWeather(this.recorderOption.forceWeather);
        }
    }

    public void startConfiguration() {
        this.state = EnumProtocol.e;
        MinecraftServer server = MinecraftServer.getServer();
        this.savePacket(new ClientboundCustomPayloadPacket(new BrandPayload(server.getServerModName())), EnumProtocol.e);
        LayeredRegistryAccess<RegistryLayer> layeredregistryaccess = server.ba();
        this.savePacket(new ClientboundUpdateEnabledFeaturesPacket(FeatureFlags.e.b(server.aY().M())), EnumProtocol.e);
        this.savePacket(new ClientboundRegistryDataPacket(new IRegistryCustom.c(RegistrySynchronization.a(layeredregistryaccess)).d()), EnumProtocol.e);
        this.savePacket(new ClientboundUpdateTagsPacket(TagNetworkSerialization.a(layeredregistryaccess)), EnumProtocol.e);
        this.savePacket(new ClientboundFinishConfigurationPacket(), EnumProtocol.e);
        this.state = EnumProtocol.b;
    }

    @Override
    public void c() {
    }

    public void stop() {
        this.stopped = true;
    }

    public void pauseRecording() {
        this.resumeOnNextPacket = false;
        this.paused = true;
    }

    public void resumeRecording() {
        this.resumeOnNextPacket = true;
    }

    public void setWeather(RecorderOption.RecordWeather weather) {
        weather.getPackets().forEach(this::savePacket);
    }

    public long getRecordedTime() {
        long base = System.currentTimeMillis() - this.startTime;
        return base - this.timeShift;
    }

    private synchronized long getCurrentTimeAndUpdate() {
        long now = this.getRecordedTime();
        if (this.paused) {
            if (this.resumeOnNextPacket) {
                this.paused = false;
            }
            this.timeShift += now - this.lastPacket;
            return this.lastPacket;
        }
        this.lastPacket = now;
        return this.lastPacket;
    }

    @Override
    public boolean k() {
        return true;
    }

    @Override
    public void a(@NotNull Packet<?> packet, @Nullable PacketSendListener callbacks, boolean flush) {
        if (!this.stopped) {
            PacketPlayOutGameStateChange.a type;
            Packet<PacketListenerPlayOut> packet1;
            if (packet instanceof ClientboundBundlePacket) {
                packet1 = (ClientboundBundlePacket)((Object)packet);
                ((BundlePacket)packet1).a().forEach(subPacket -> this.a((Packet<?>)subPacket, null));
            }
            if (packet instanceof PacketPlayOutSpawnEntity && ((PacketPlayOutSpawnEntity)(packet1 = (PacketPlayOutSpawnEntity)((Object)packet))).e() == EntityTypes.bv) {
                this.metaData.players.add(((PacketPlayOutSpawnEntity)packet1).d());
                this.saveMetadata();
            }
            if (packet instanceof ClientboundDisconnectPacket) {
                return;
            }
            if (this.recorderOption.forceDayTime != -1 && packet instanceof PacketPlayOutUpdateTime) {
                packet1 = packet;
                packet = new PacketPlayOutUpdateTime(((PacketPlayOutUpdateTime)packet1).d(), this.recorderOption.forceDayTime, false);
            }
            if (this.recorderOption.forceWeather != null && packet instanceof PacketPlayOutGameStateChange && ((type = ((PacketPlayOutGameStateChange)(packet1 = (PacketPlayOutGameStateChange)((Object)packet))).a()) == PacketPlayOutGameStateChange.b || type == PacketPlayOutGameStateChange.c || type == PacketPlayOutGameStateChange.h || type == PacketPlayOutGameStateChange.i)) {
                return;
            }
            if (this.recorderOption.ignoreChat && (packet instanceof ClientboundSystemChatPacket || packet instanceof ClientboundPlayerChatPacket)) {
                return;
            }
            this.savePacket(packet);
        }
    }

    private void saveMetadata() {
        this.saveService.submit(() -> {
            try {
                this.replayFile.saveMetaData(this.metaData);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        });
    }

    private void savePacket(Packet<?> packet) {
        this.savePacket(packet, this.state);
    }

    private void savePacket(Packet<?> packet, EnumProtocol protocol) {
        try {
            long timestamp = this.getCurrentTimeAndUpdate();
            this.saveService.submit(() -> {
                try {
                    this.replayFile.savePacket(timestamp, packet, protocol);
                }
                catch (Exception e2) {
                    LOGGER.severe("Error saving packet");
                    e2.printStackTrace();
                }
            });
        }
        catch (Exception e2) {
            LOGGER.severe("Error saving packet");
            e2.printStackTrace();
        }
    }

    public boolean isSaved() {
        return this.isSaved;
    }

    public CompletableFuture<Void> saveRecording(File dest, boolean save) {
        this.isSaved = true;
        if (!this.isSaving) {
            this.isSaving = true;
            this.metaData.duration = (int)this.lastPacket;
            return CompletableFuture.runAsync(() -> {
                this.saveMetadata();
                this.saveService.shutdown();
                boolean interrupted = false;
                try {
                    this.saveService.awaitTermination(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e2) {
                    interrupted = true;
                }
                try {
                    if (save) {
                        this.replayFile.closeAndSave(dest);
                    } else {
                        this.replayFile.closeNotSave();
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                    throw new CompletionException(e3);
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }, runnable -> {
                Thread thread = new Thread(runnable, "Recording file save thread");
                thread.start();
            });
        }
        LOGGER.warning("saveRecording() called twice");
        return CompletableFuture.supplyAsync(() -> {
            throw new IllegalStateException("saveRecording() called twice");
        });
    }
}

