/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.replay;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import java.util.UUID;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.SharedConstants;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.replay.DigestOutputStream;
import top.leavesmc.leaves.replay.RecordMetaData;
import top.leavesmc.leaves.replay.ReplayMarker;
import top.leavesmc.leaves.util.UUIDSerializer;

public class ReplayFile {
    private static final String RECORDING_FILE = "recording.tmcpr";
    private static final String RECORDING_FILE_CRC32 = "recording.tmcpr.crc32";
    private static final String MARKER_FILE = "markers.json";
    private static final String META_FILE = "metaData.json";
    private static final Gson MARKER_GSON = new GsonBuilder().registerTypeAdapter(ReplayMarker.class, (Object)new ReplayMarker.Serializer()).create();
    private static final Gson META_GSON = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDSerializer()).create();
    private final File tmpDir;
    private final DataOutputStream packetStream;
    private final CRC32 crc32 = new CRC32();
    private final File markerFile;
    private final File metaFile;

    public ReplayFile(@NotNull File name) throws IOException {
        this.tmpDir = new File(name.getParentFile(), name.getName() + ".tmp");
        if (this.tmpDir.exists() && !ReplayFile.deleteDir(this.tmpDir)) {
            throw new IOException("Recording file " + name + " already exists!");
        }
        if (!this.tmpDir.mkdirs()) {
            throw new IOException("Failed to create temp directory for recording " + this.tmpDir);
        }
        File packetFile = new File(this.tmpDir, RECORDING_FILE);
        this.metaFile = new File(this.tmpDir, META_FILE);
        this.markerFile = new File(this.tmpDir, MARKER_FILE);
        this.packetStream = new DataOutputStream(new DigestOutputStream(new BufferedOutputStream(new FileOutputStream(packetFile)), this.crc32));
    }

    private byte @NotNull [] getPacketBytes(Packet<?> packet, EnumProtocol state) {
        int packetID = state.b(EnumProtocolDirection.b).a(packet);
        ByteBuf buf = Unpooled.buffer();
        PacketDataSerializer packetBuf = new PacketDataSerializer(buf);
        packetBuf.c(packetID);
        packet.a(packetBuf);
        buf.readerIndex(0);
        byte[] ret = new byte[buf.readableBytes()];
        buf.readBytes(ret);
        buf.release();
        return ret;
    }

    public void saveMarkers(List<ReplayMarker> markers) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.markerFile), StandardCharsets.UTF_8);){
            writer.write(MARKER_GSON.toJson(markers));
        }
    }

    public void saveMetaData(@NotNull RecordMetaData data) throws IOException {
        data.fileFormat = "MCPR";
        data.fileFormatVersion = 14;
        data.protocol = SharedConstants.b().e();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.metaFile), StandardCharsets.UTF_8);){
            writer.write(META_GSON.toJson((Object)data));
        }
    }

    public void savePacket(long timestamp, Packet<?> packet, EnumProtocol protocol) throws Exception {
        byte[] data = this.getPacketBytes(packet, protocol);
        this.packetStream.writeInt((int)timestamp);
        this.packetStream.writeInt(data.length);
        this.packetStream.write(data);
    }

    public synchronized void closeAndSave(File file) throws IOException {
        this.packetStream.close();
        String[] files = this.tmpDir.list();
        if (files == null) {
            return;
        }
        try (ZipOutputStream os = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
            String[] stringArray = files;
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String fileName = stringArray[i2];
                os.putNextEntry(new ZipEntry(fileName));
                File f2 = new File(this.tmpDir, fileName);
                this.copy(new FileInputStream(f2), os);
            }
            os.putNextEntry(new ZipEntry(RECORDING_FILE_CRC32));
            OutputStreamWriter writer = new OutputStreamWriter(os);
            writer.write(Long.toString(this.crc32.getValue()));
            ((Writer)writer).flush();
        }
        for (String fileName : files) {
            File f3 = new File(this.tmpDir, fileName);
            Files.delete(f3.toPath());
        }
        Files.delete(this.tmpDir.toPath());
    }

    public synchronized void closeNotSave() throws IOException {
        this.packetStream.close();
        String[] files = this.tmpDir.list();
        if (files == null) {
            return;
        }
        for (String fileName : files) {
            File f2 = new File(this.tmpDir, fileName);
            Files.delete(f2.toPath());
        }
        Files.delete(this.tmpDir.toPath());
    }

    private void copy(@NotNull InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[8192];
        while ((len = in.read(buffer)) > -1) {
            out.write(buffer, 0, len);
        }
        in.close();
    }

    private static boolean deleteDir(File dir) {
        if (dir == null || !dir.exists()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    ReplayFile.deleteDir(file);
                    continue;
                }
                if (file.delete()) continue;
                return false;
            }
        }
        return dir.delete();
    }
}

