/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.replay;

import com.mojang.authlib.GameProfile;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.LeavesLogger;
import top.leavesmc.leaves.bot.BotStatsCounter;
import top.leavesmc.leaves.bot.ServerBot;
import top.leavesmc.leaves.entity.CraftPhotographer;
import top.leavesmc.leaves.entity.Photographer;
import top.leavesmc.leaves.replay.Recorder;
import top.leavesmc.leaves.replay.RecorderOption;
import top.leavesmc.leaves.replay.ServerPhotographerGameMode;

public class ServerPhotographer
extends EntityPlayer {
    private static final List<ServerPhotographer> photographers = new CopyOnWriteArrayList<ServerPhotographer>();
    public PhotographerCreateState createState;
    private EntityPlayer followPlayer;
    private Recorder recorder;
    private File saveFile;
    private Vec3D lastPos;
    private final ServerStatisticManager stats;

    private ServerPhotographer(MinecraftServer server, WorldServer world, GameProfile profile) {
        super(server, world, profile, ClientInformation.a());
        this.e = new ServerPhotographerGameMode(this);
        this.followPlayer = null;
        this.stats = new BotStatsCounter(server);
        this.lastPos = this.dk();
    }

    public static ServerPhotographer createPhotographer(@NotNull PhotographerCreateState state) throws IOException {
        if (!ServerBot.isCreateLegal(state.id)) {
            return null;
        }
        MinecraftServer server = MinecraftServer.getServer();
        WorldServer world = ((CraftWorld)state.loc.getWorld()).getHandle();
        GameProfile profile = new GameProfile(UUID.randomUUID(), state.id);
        ServerPhotographer photographer = new ServerPhotographer(server, world, profile);
        photographer.recorder = new Recorder(photographer, state.option, new File("replay", state.id));
        photographer.saveFile = new File("replay", state.id + ".mcpr");
        photographer.createState = state;
        photographer.recorder.start();
        MinecraftServer.getServer().ae().placeNewPhotographer(photographer.recorder, photographer, world, state.loc);
        photographer.z().I.a(photographer);
        photographer.j(true);
        photographers.add(photographer);
        LeavesLogger.LOGGER.info("Photographer " + state.id + " created");
        return photographer;
    }

    @Override
    public void l() {
        super.l();
        super.m();
        if (this.d.ai() % 10 == 0) {
            this.c.m();
            this.z().I.a(this);
        }
        if (this.followPlayer != null) {
            if (this.K() == this || this.K().dM() != this.dM()) {
                this.getBukkitPlayer().teleport(this.K().getBukkitEntity().getLocation());
                this.c((Entity)this.followPlayer);
            }
            if (this.lastPos.g(this.dk()) > 1024.0) {
                this.getBukkitPlayer().teleport(this.K().getBukkitEntity().getLocation());
            }
        }
        this.lastPos = this.dk();
    }

    @Override
    public void a(@NotNull DamageSource damageSource) {
        super.a(damageSource);
        this.remove(true);
    }

    @Override
    public boolean b(@NotNull DamageSource damageSource) {
        return true;
    }

    @Override
    public boolean a(@NotNull DamageSource source, float amount) {
        return false;
    }

    @Override
    public void c(float health) {
    }

    @Override
    @NotNull
    public ServerStatisticManager H() {
        return this.stats;
    }

    public void remove(boolean async) {
        this.remove(async, true);
    }

    public void remove(boolean async, boolean save) {
        super.a(Entity.RemovalReason.a);
        photographers.remove(this);
        this.recorder.stop();
        this.d.ae().removePhotographer(this);
        LeavesLogger.LOGGER.info("Photographer " + this.createState.id + " removed");
        if (save && !this.recorder.isSaved()) {
            CompletableFuture<Void> future = this.recorder.saveRecording(this.saveFile, save);
            if (!async) {
                future.join();
            }
        }
    }

    public void setFollowPlayer(EntityPlayer followPlayer) {
        this.c((Entity)followPlayer);
        this.followPlayer = followPlayer;
    }

    public void setSaveFile(File saveFile) {
        this.saveFile = saveFile;
    }

    public void pauseRecording() {
        this.recorder.pauseRecording();
    }

    public void resumeRecording() {
        this.recorder.resumeRecording();
    }

    public static ServerPhotographer getPhotographer(String id) {
        for (ServerPhotographer photographer : photographers) {
            if (!photographer.createState.id.equals(id)) continue;
            return photographer;
        }
        return null;
    }

    public static ServerPhotographer getPhotographer(UUID uuid) {
        for (ServerPhotographer photographer : photographers) {
            if (!photographer.cw().equals(uuid)) continue;
            return photographer;
        }
        return null;
    }

    public static List<ServerPhotographer> getPhotographers() {
        return photographers;
    }

    public Photographer getBukkitPlayer() {
        return this.getBukkitEntity();
    }

    @Override
    @NotNull
    public CraftPhotographer getBukkitEntity() {
        return (CraftPhotographer)super.getBukkitEntity();
    }

    public static class PhotographerCreateState {
        public RecorderOption option;
        public Location loc;
        public final String id;

        public PhotographerCreateState(Location loc, String id, RecorderOption option) {
            this.loc = loc;
            this.id = id;
            this.option = option;
        }

        public ServerPhotographer createSync() {
            try {
                return ServerPhotographer.createPhotographer(this);
            }
            catch (IOException e2) {
                e2.printStackTrace();
                return null;
            }
        }
    }
}

