/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.util;

import it.unimi.dsi.fastutil.objects.Object2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBannerAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBeaconBeam;
import net.minecraft.world.level.material.MaterialMapColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HopperCounter {
    private static boolean enabled = false;
    private static final Map<EnumColor, HopperCounter> COUNTERS;
    public final EnumColor color;
    private final TextComponent coloredName;
    private final Object2LongMap<Item> counter = new Object2LongLinkedOpenHashMap();
    private long startTick = -1L;
    private long startMillis;
    private static final Map<Item, Block> DEFAULTS;

    private HopperCounter(EnumColor color) {
        this.color = color;
        this.coloredName = Component.text((String)color.b(), (TextColor)TextColor.color((int)color.g()));
    }

    public void add(MinecraftServer server, ItemStack stack) {
        if (this.startTick < 0L) {
            this.startTick = server.F().X();
            this.startMillis = System.currentTimeMillis();
        }
        Item item = stack.d();
        this.counter.put((Object)item, this.counter.getLong((Object)item) + (long)stack.L());
    }

    public void reset(MinecraftServer server) {
        this.counter.clear();
        this.startTick = server.F().X();
        this.startMillis = System.currentTimeMillis();
    }

    public List<Component> format(MinecraftServer server, boolean realTime) {
        long ticks = Math.max(realTime ? (System.currentTimeMillis() - this.startMillis) / 50L : server.F().X() - this.startTick, -1L);
        if (this.startTick < 0L || ticks == -1L) {
            return Collections.singletonList(((TextComponent.Builder)Component.text().append(new Component[]{this.coloredName, Component.text((String)" hasn't started counting yet")})).build());
        }
        long total = this.getTotalItems();
        if (total <= 0L) {
            return Collections.singletonList(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(new Component[]{Component.text((String)"No items for "), this.coloredName})).append(new Component[]{Component.text((String)" yet ("), Component.text((String)String.format("%.2f ", (double)ticks / 1200.0), (Style)Style.style((TextDecoration)TextDecoration.BOLD))})).append(new Component[]{Component.text((String)"min"), Component.text((String)(realTime ? " - real time" : "")), Component.text((String)")")})).build());
        }
        ArrayList<Component> items = new ArrayList<Component>();
        items.add((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(new Component[]{Component.text((String)"Items for "), this.coloredName, Component.text((String)" ")})).append(new Component[]{Component.text((String)"("), Component.text((String)String.format("%.2f ", (double)ticks * 1.0 / 1200.0), (Style)Style.style((TextDecoration)TextDecoration.BOLD))})).append(new Component[]{Component.text((String)"min"), Component.text((String)(realTime ? " - real time" : "")), Component.text((String)"), ")})).append(new Component[]{Component.text((String)"total: "), Component.text((long)total, (Style)Style.style((TextDecoration)TextDecoration.BOLD)), Component.text((String)", ")})).append(new Component[]{Component.text((String)"("), Component.text((String)String.format("%.1f", (double)total * 1.0 * 72000.0 / (double)ticks), (Style)Style.style((TextDecoration)TextDecoration.BOLD))})).append((Component)Component.text((String)"/h):"))).build());
        this.counter.object2LongEntrySet().forEach(entry -> {
            Item item = (Item)entry.getKey();
            TranslatableComponent name = Component.translatable((String)item.a());
            TextColor textColor = HopperCounter.guessColor(server, item);
            name = textColor != null ? name.style(name.style().merge(Style.style((TextColor)textColor))) : name.style(name.style().merge(Style.style((TextDecoration)TextDecoration.ITALIC)));
            long count = entry.getLongValue();
            items.add((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"- ", (TextColor)NamedTextColor.GRAY))).append((Component)name)).append((Component)Component.text((String)": ", (TextColor)NamedTextColor.GRAY))).append(new Component[]{Component.text((long)count, (Style)Style.style((TextDecoration)TextDecoration.BOLD)), Component.text((String)", ", (TextColor)NamedTextColor.GRAY)})).append((Component)Component.text((String)String.format("%.1f", (double)count * 72000.0 / (double)ticks), (Style)Style.style((TextDecoration)TextDecoration.BOLD)))).append((Component)Component.text((String)"/h"))).build());
        });
        return items;
    }

    @Nullable
    public static TextColor guessColor(@NotNull MinecraftServer server, Item item) {
        IRegistryCustom.Dimension registryAccess = server.aZ();
        TextColor direct = HopperCounter.fromItem(item, registryAccess);
        if (direct != null) {
            return direct;
        }
        MinecraftKey id = registryAccess.d(Registries.F).b(item);
        for (Recipes recipes : registryAccess.d(Registries.Z)) {
            for (IRecipe<?> r2 : HopperCounter.getAllMatching(server.aG(), recipes, id, registryAccess)) {
                for (RecipeItemStack ingredient : r2.a()) {
                    for (Collection<ItemStack> stacks : HopperCounter.getRecipeStacks(ingredient)) {
                        for (ItemStack itemStack : stacks) {
                            TextColor textColor = HopperCounter.fromItem(itemStack.d(), registryAccess);
                            if (textColor == null) continue;
                            return textColor;
                        }
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    public static TextColor fromItem(Item item, IRegistryCustom registryAccess) {
        if (DEFAULTS.containsKey(item)) {
            return TextColor.color((int)HopperCounter.appropriateColor(HopperCounter.DEFAULTS.get((Object)item).w().ak));
        }
        if (item instanceof ItemDye) {
            ItemDye dye = (ItemDye)item;
            return TextColor.color((int)HopperCounter.appropriateColor(dye.d().e().ak));
        }
        Block block = null;
        IRegistry<Item> itemRegistry = registryAccess.d(Registries.F);
        IRegistry<Block> blockRegistry = registryAccess.d(Registries.f);
        MinecraftKey id = itemRegistry.b(item);
        if (item instanceof ItemBlock) {
            ItemBlock blockItem = (ItemBlock)item;
            block = blockItem.e();
        } else if (blockRegistry.b(id).isPresent()) {
            block = blockRegistry.a(id);
        }
        if (block != null) {
            if (block instanceof BlockBannerAbstract) {
                return TextColor.color((int)HopperCounter.appropriateColor(((BlockBannerAbstract)block).b().e().ak));
            }
            if (block instanceof IBeaconBeam) {
                return TextColor.color((int)HopperCounter.appropriateColor(((IBeaconBeam)((Object)block)).b().e().ak));
            }
            return TextColor.color((int)HopperCounter.appropriateColor(block.w().ak));
        }
        return null;
    }

    public static List<IRecipe<?>> getAllMatching(@NotNull CraftingManager manager, Recipes<?> type, MinecraftKey output, IRegistryCustom registryAccess) {
        Map typeRecipes = (Map)manager.c.get(type);
        if (typeRecipes == null) {
            return Collections.emptyList();
        }
        if (typeRecipes.containsKey(output)) {
            return Collections.singletonList(((RecipeHolder)typeRecipes.get(output)).b());
        }
        IRegistry<Item> regs = registryAccess.d(Registries.F);
        return typeRecipes.values().stream().filter(r2 -> Objects.equals(regs.b(r2.b().a(registryAccess).d()), output)).map(RecipeHolder::b).collect(Collectors.toList());
    }

    public static List<Collection<ItemStack>> getRecipeStacks(@NotNull RecipeItemStack ingredient) {
        return Arrays.stream(ingredient.d).map(RecipeItemStack.Provider::a).toList();
    }

    public static int appropriateColor(int color) {
        if (color == 0) {
            return MaterialMapColor.i.ak;
        }
        int r2 = color >> 16 & 0xFF;
        int g2 = color >> 8 & 0xFF;
        int b2 = color & 0xFF;
        if (r2 < 70) {
            r2 = 70;
        }
        if (g2 < 70) {
            g2 = 70;
        }
        if (b2 < 70) {
            b2 = 70;
        }
        return (r2 << 16) + (g2 << 8) + b2;
    }

    public long getTotalItems() {
        return this.counter.isEmpty() ? 0L : this.counter.values().longStream().sum();
    }

    public static void resetAll(MinecraftServer server, boolean fresh) {
        for (HopperCounter counter : COUNTERS.values()) {
            counter.reset(server);
            if (!fresh) continue;
            counter.startTick = -1L;
        }
    }

    public static HopperCounter getCounter(EnumColor color) {
        return COUNTERS.get(color);
    }

    public static void setEnabled(boolean is) {
        enabled = is;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    static {
        EnumMap<EnumColor, HopperCounter> counterMap = new EnumMap<EnumColor, HopperCounter>(EnumColor.class);
        for (EnumColor color : EnumColor.values()) {
            counterMap.put(color, new HopperCounter(color));
        }
        COUNTERS = Collections.unmodifiableMap(counterMap);
        DEFAULTS = Map.ofEntries(Map.entry(Items.dj, Blocks.bE), Map.entry(Items.dk, Blocks.bO), Map.entry(Items.dl, Blocks.bD), Map.entry(Items.dm, Blocks.bC), Map.entry(Items.dn, Blocks.dP), Map.entry(Items.do, Blocks.bO), Map.entry(Items.dp, Blocks.bB), Map.entry(Items.dq, Blocks.dP), Map.entry(Items.dr, Blocks.bG), Map.entry(Items.ds, Blocks.dP), Map.entry(Items.dt, Blocks.bL), Map.entry(Items.dv, Blocks.bP), Map.entry(Items.du, Blocks.bA), Map.entry(Items.dz, Blocks.eT), Map.entry(Items.dA, Blocks.eU), Map.entry(Items.pm, Blocks.n), Map.entry(Items.oF, Blocks.ch), Map.entry(Items.oB, Blocks.ci), Map.entry(Items.ov, Blocks.cz), Map.entry(Items.oG, Blocks.pi), Map.entry(Items.hW, Blocks.bE), Map.entry(Items.hX, Blocks.bC), Map.entry(Items.hY, Blocks.bO), Map.entry(Items.hZ, Blocks.bG), Map.entry(Items.tY, Blocks.bB), Map.entry(Items.oq, Blocks.bO), Map.entry(Items.pt, Blocks.ij), Map.entry(Items.pU, Blocks.bG), Map.entry(Items.ut, Blocks.bG), Map.entry(Items.rZ, Blocks.hj), Map.entry(Items.rX, Blocks.dV), Map.entry(Items.pY, Blocks.ch), Map.entry(Items.qW, Blocks.hj), Map.entry(Items.qX, Blocks.r), Map.entry(Items.sb, Blocks.bM), Map.entry(Items.qZ, Blocks.hn), Map.entry(Items.qY, Blocks.bB), Map.entry(Items.tZ, Blocks.hj), Map.entry(Items.uG, Blocks.bO), Map.entry(Items.vd, Blocks.dV), Map.entry(Items.rT, Blocks.fa), Map.entry(Items.ub, Blocks.hV), Map.entry(Items.sj, Blocks.dV), Map.entry(Items.pr, Blocks.bH), Map.entry(Items.oo, Blocks.bF), Map.entry(Items.pq, Blocks.bA), Map.entry(Items.pT, Blocks.bP), Map.entry(Items.qA, Blocks.o), Map.entry(Items.qV, Blocks.ec), Map.entry(Items.qL, Blocks.bA), Map.entry(Items.qI, Blocks.cj), Map.entry(Items.rc, Blocks.bP), Map.entry(Items.qz, Blocks.dP), Map.entry(Items.qw, Blocks.G), Map.entry(Items.qx, Blocks.H), Map.entry(Items.qB, Blocks.bA), Map.entry(Items.qJ, Blocks.dR), Map.entry(Items.re, Blocks.fC), Map.entry(Items.rw, Blocks.kM), Map.entry(Items.qE, Blocks.hv), Map.entry(Items.qC, Blocks.hn), Map.entry(Items.qD, Blocks.hp), Map.entry(Items.qF, Blocks.hk), Map.entry(Items.rx, Blocks.bA), Map.entry(Items.sl, Blocks.ch), Map.entry(Items.sc, Blocks.oF), Map.entry(Items.ul, Blocks.cz), Map.entry(Items.us, Blocks.ii), Map.entry(Items.ur, Blocks.hZ), Map.entry(Items.ux, Blocks.n), Map.entry(Items.uZ, Blocks.kw), Map.entry(Items.vn, Blocks.kP), Map.entry(Items.vK, Blocks.kM), Map.entry(Items.vL, Blocks.mX), Map.entry(Items.wn, Blocks.ph), Map.entry(Items.uE, Blocks.kM), Map.entry(Items.vm, Blocks.hn), Map.entry(Items.vI, Blocks.hZ), Map.entry(Items.se, Blocks.bA), Map.entry(Items.vJ, Blocks.kM), Map.entry(Items.qO, Blocks.kM), Map.entry(Items.oD, Blocks.qW), Map.entry(Items.oz, Blocks.qt));
    }
}

