/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.util;

import com.destroystokyo.paper.PaperVersionFetcher;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class LeavesVersionFetcher
extends PaperVersionFetcher {
    private static final String DOWNLOAD_PAGE = "https://leavesmc.org/downloads/leaves";
    private static final String GITHUB_BRANCH_NAME = "master";

    @Override
    @Nonnull
    public Component getVersionMessage(@Nonnull String serverVersion) {
        String[] parts = serverVersion.substring("git-Leaves-".length()).split("[-\\s]");
        Component updateMessage = LeavesVersionFetcher.getUpdateStatusMessage("LeavesMC/Leaves", GITHUB_BRANCH_NAME, parts[0]);
        Component history = this.getHistory();
        return history != null ? TextComponent.ofChildren((ComponentLike[])new ComponentLike[]{updateMessage, Component.newline(), history}) : updateMessage;
    }

    private static int fetchDistanceFromLeavesApiV2(String mcVersion, String hash) {
        int n2;
        block8: {
            BufferedReader reader = Resources.asCharSource((URL)new URL("https://api.leavesmc.org/v2/projects/leaves/versions/" + mcVersion + "/differ/" + hash), (Charset)Charsets.UTF_8).openBufferedStream();
            try {
                n2 = Integer.parseInt(reader.readLine());
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    throw new NumberFormatException();
                }
            }
            reader.close();
        }
        return n2;
    }

    private static Component getUpdateStatusMessage(@Nonnull String repo, @Nonnull String branch, @Nonnull String versionInfo) {
        int distance;
        versionInfo = versionInfo.replace("\"", "");
        try {
            distance = LeavesVersionFetcher.fetchDistanceFromLeavesApiV2(LeavesVersionFetcher.getMinecraftVersion(), versionInfo);
        }
        catch (NumberFormatException ignored) {
            distance = LeavesVersionFetcher.fetchDistanceFromGitHub(repo, branch, versionInfo);
        }
        switch (distance) {
            case -1: {
                return Component.text((String)"Error obtaining version information", (TextColor)NamedTextColor.YELLOW);
            }
            case 0: {
                return Component.text((String)"You are running the latest version", (TextColor)NamedTextColor.GREEN);
            }
            case -2: {
                return Component.text((String)"Unknown version", (TextColor)NamedTextColor.YELLOW);
            }
        }
        return ((TextComponent)Component.text((String)("You are " + distance + " version(s) behind"), (TextColor)NamedTextColor.YELLOW).append((Component)Component.newline())).append(Component.text((String)"Download the new version at: ").append(((TextComponent)Component.text((String)DOWNLOAD_PAGE, (TextColor)NamedTextColor.GOLD).hoverEvent((HoverEventSource)Component.text((String)"Click to open", (TextColor)NamedTextColor.WHITE))).clickEvent(ClickEvent.openUrl((String)DOWNLOAD_PAGE))));
    }
}

