/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.util;

import java.util.UUID;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.portal.PortalTravelAgent;
import org.jetbrains.annotations.Nullable;

public class ReturnPortalManager {
    private static final int MAX_PORTAL_DISTANCE_SQ = 16;
    private static final String RETURN_PORTAL_LIST = "ReturnPortalList";
    private static final String RETURN_PORTAL_UID = "UID";
    private static final String FROM_DIM = "FromDim";
    private static final String FROM_POS = "FromPos";
    private static final String TO_MIN_CORNER = "ToMinCorner";
    private static final String TO_AXIS_1_SIZE = "ToAxis1Size";
    private static final String TO_AXIS_2_SIZE = "ToAxis2Size";

    public static BlockUtil.Rectangle findPortalAt(EntityHuman player, ResourceKey<World> dim, BlockPosition pos) {
        WorldServer fromWorld;
        MinecraftServer server = player.dM().o();
        if (server != null && (fromWorld = server.a(dim)) != null) {
            PortalTravelAgent portalForcer = fromWorld.p();
            return portalForcer.a(pos, false, fromWorld.D_()).orElse(null);
        }
        return null;
    }

    public static NBTTagList getPlayerPortalList(EntityHuman player) {
        NBTTagCompound data = player.getLeavesData();
        NBTTagList list = data.c(RETURN_PORTAL_LIST, 10);
        data.a(RETURN_PORTAL_LIST, list);
        return list;
    }

    @Nullable
    public static ReturnPortal findReturnPortal(EntityPlayer player, ResourceKey<World> fromDim, BlockPosition fromPos) {
        NBTTagList portalList = ReturnPortalManager.getPlayerPortalList(player);
        for (NBTBase entry : portalList) {
            BlockPosition portalTrigger;
            NBTTagCompound portal = (NBTTagCompound)entry;
            ResourceKey<World> entryFromDim = ResourceKey.a(Registries.aM, new MinecraftKey(portal.l(FROM_DIM)));
            if (entryFromDim != fromDim || !((portalTrigger = BlockPosition.d(portal.i(FROM_POS))).j(fromPos) <= 16.0)) continue;
            UUID uid = portal.b(RETURN_PORTAL_UID) ? portal.a(RETURN_PORTAL_UID) : UUID.randomUUID();
            BlockPosition minCorner = BlockPosition.d(portal.i(TO_MIN_CORNER));
            int axis1Size = portal.h(TO_AXIS_1_SIZE);
            int axis2Size = portal.h(TO_AXIS_2_SIZE);
            return new ReturnPortal(uid, new BlockUtil.Rectangle(minCorner, axis1Size, axis2Size));
        }
        return null;
    }

    public static void storeReturnPortal(EntityPlayer player, ResourceKey<World> fromDim, BlockPosition fromPos, BlockUtil.Rectangle toPortal) {
        NBTTagList portalList = ReturnPortalManager.getPlayerPortalList(player);
        ReturnPortal returnPortal = ReturnPortalManager.findReturnPortal(player, fromDim, fromPos);
        if (returnPortal != null) {
            ReturnPortalManager.removeReturnPortal(player, returnPortal);
        }
        NBTTagCompound portalCompound = new NBTTagCompound();
        portalCompound.a(RETURN_PORTAL_UID, UUID.randomUUID());
        portalCompound.a(FROM_DIM, String.valueOf(fromDim.a()));
        portalCompound.a(FROM_POS, fromPos.a());
        portalCompound.a(TO_MIN_CORNER, toPortal.a.a());
        portalCompound.a(TO_AXIS_1_SIZE, toPortal.b);
        portalCompound.a(TO_AXIS_2_SIZE, toPortal.c);
        portalList.add(portalCompound);
    }

    public static void removeReturnPortal(EntityPlayer player, ReturnPortal portal) {
        NBTTagList portalList = ReturnPortalManager.getPlayerPortalList(player);
        for (int i2 = 0; i2 < portalList.size(); ++i2) {
            NBTTagCompound entry = (NBTTagCompound)portalList.k(i2);
            if (!entry.b(RETURN_PORTAL_UID) || !entry.a(RETURN_PORTAL_UID).equals(portal.uid())) continue;
            portalList.c(i2);
            break;
        }
    }

    public record ReturnPortal(UUID uid, BlockUtil.Rectangle rectangle) {
    }
}

