/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.papermc.paper.chunk.system.RegionizedPlayerChunkLoader;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ArraySetSorted;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.storage.SavedFile;
import top.leavesmc.leaves.LeavesConfig;

public class TicketHelper {
    private static final Set<TicketType<?>> NEED_SAVED = Set.of(TicketType.c, TicketType.f, TicketType.ENTITY_LOAD, TicketType.POI_LOAD);

    public static void tryToLoadTickets() {
        if (!LeavesConfig.fastResume) {
            return;
        }
        File file = MinecraftServer.getServer().a(SavedFile.l).resolve("chunk_tickets.leaves.json").toFile();
        if (file.isFile()) {
            try (BufferedReader bfr = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
                JsonObject json = (JsonObject)new Gson().fromJson((Reader)bfr, JsonObject.class);
                TicketHelper.loadSavedChunkTickets(json);
                file.delete();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }

    public static void tryToSaveTickets() {
        if (!LeavesConfig.fastResume) {
            return;
        }
        File file = MinecraftServer.getServer().a(SavedFile.l).resolve("chunk_tickets.leaves.json").toFile();
        if (!file.isFile()) {
            try {
                file.createNewFile();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        try (BufferedWriter bfw = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            bfw.write(new Gson().toJson((JsonElement)TicketHelper.getSavedChunkTickets()));
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    public static void loadSavedChunkTickets(JsonObject json) {
        MinecraftServer server = MinecraftServer.getServer();
        for (String worldKey : json.keySet()) {
            WorldServer level = server.a(ResourceKey.a(Registries.aM, new MinecraftKey(worldKey)));
            if (level == null) continue;
            PlayerChunkMap.ChunkDistanceManager chunkDistanceManager = level.l().a.F;
            for (JsonElement chunkElement : json.get(worldKey).getAsJsonArray()) {
                JsonObject chunkJson = (JsonObject)chunkElement;
                long chunkKey = chunkJson.get("key").getAsLong();
                for (JsonElement ticketElement : chunkJson.get("tickets").getAsJsonArray()) {
                    Ticket ticket = TicketHelper.tickFormJson((JsonObject)ticketElement);
                    chunkDistanceManager.getChunkHolderManager().addTicketAtLevelCustom(ticket, chunkKey, true);
                }
            }
        }
    }

    public static JsonObject getSavedChunkTickets() {
        JsonObject json = new JsonObject();
        for (WorldServer level : MinecraftServer.getServer().H()) {
            JsonArray levelArray = new JsonArray();
            PlayerChunkMap.ChunkDistanceManager chunkDistanceManager = level.l().a.F;
            for (Long2ObjectMap.Entry chunkTickets : chunkDistanceManager.getChunkHolderManager().getTicketsCopy().long2ObjectEntrySet()) {
                long chunkKey = chunkTickets.getLongKey();
                JsonArray ticketArray = new JsonArray();
                ArraySetSorted tickets = (ArraySetSorted)chunkTickets.getValue();
                for (Ticket ticket : tickets) {
                    if (!NEED_SAVED.contains(ticket.a())) continue;
                    ticketArray.add((JsonElement)TicketHelper.ticketToJson(ticket));
                }
                if (ticketArray.isEmpty()) continue;
                JsonObject chunkJson = new JsonObject();
                chunkJson.addProperty("key", (Number)chunkKey);
                chunkJson.add("tickets", (JsonElement)ticketArray);
                levelArray.add((JsonElement)chunkJson);
            }
            if (levelArray.isEmpty()) continue;
            json.add(level.ae().a().toString(), (JsonElement)levelArray);
        }
        return json;
    }

    private static JsonObject ticketToJson(Ticket<?> ticket) {
        JsonObject json = new JsonObject();
        json.addProperty("type", ticket.a().toString());
        json.addProperty("ticketLevel", (Number)ticket.b());
        json.addProperty("removeDelay", (Number)ticket.removeDelay);
        Object t2 = ticket.c;
        if (t2 instanceof BlockPosition) {
            BlockPosition pos = (BlockPosition)t2;
            json.addProperty("key", (Number)pos.a());
        } else {
            t2 = ticket.c;
            if (t2 instanceof ChunkCoordIntPair) {
                ChunkCoordIntPair pos = (ChunkCoordIntPair)t2;
                json.addProperty("key", (Number)pos.a());
            } else {
                t2 = ticket.c;
                if (t2 instanceof Long) {
                    Long l2 = (Long)t2;
                    json.addProperty("key", (Number)l2);
                }
            }
        }
        return json;
    }

    private static <T> Ticket<T> tickFormJson(JsonObject json) {
        TicketType<Object> ticketType = null;
        Object key = null;
        switch (json.get("type").getAsString()) {
            case "player": {
                ticketType = TicketType.c;
                key = new ChunkCoordIntPair(json.get("key").getAsLong());
                break;
            }
            case "portal": {
                ticketType = TicketType.f;
                key = BlockPosition.d(json.get("key").getAsLong());
                break;
            }
            case "entity_load": {
                ticketType = TicketType.ENTITY_LOAD;
                key = json.get("key").getAsLong();
                break;
            }
            case "poi_load": {
                ticketType = TicketType.POI_LOAD;
                key = json.get("key").getAsLong();
                break;
            }
            case "region_player_ticket": {
                ticketType = RegionizedPlayerChunkLoader.REGION_PLAYER_TICKET;
                key = json.get("key").getAsLong();
            }
        }
        if (ticketType == null) {
            throw new IllegalArgumentException("???");
        }
        int ticketLevel = json.get("ticketLevel").getAsInt();
        long removeDelay = json.get("removeDelay").getAsLong();
        return new Ticket<Object>(ticketType, ticketLevel, key, removeDelay);
    }
}

