/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.profile;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import com.google.common.base.Charsets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.spigotmc.SpigotConfig;

public class CraftPlayerProfile
implements PlayerProfile {
    private GameProfile profile;
    private final PropertySet properties = new PropertySet();

    public CraftPlayerProfile(CraftPlayer player) {
        this.profile = player.getHandle().getProfile();
    }

    public CraftPlayerProfile(UUID id, String name) {
        this.profile = new GameProfile(id, name);
    }

    public CraftPlayerProfile(GameProfile profile) {
        Validate.notNull((Object)profile, (String)"GameProfile cannot be null!", (Object[])new Object[0]);
        this.profile = profile;
    }

    @Override
    public boolean hasProperty(String property) {
        return this.profile.getProperties().containsKey((Object)property);
    }

    @Override
    public void setProperty(ProfileProperty property) {
        String name = property.getName();
        PropertyMap properties = this.profile.getProperties();
        properties.removeAll((Object)name);
        properties.put((Object)name, (Object)new Property(name, property.getValue(), property.getSignature()));
    }

    public GameProfile getGameProfile() {
        return this.profile;
    }

    @Override
    @Nullable
    public UUID getId() {
        return this.profile.getId();
    }

    @Override
    public UUID setId(@Nullable UUID uuid) {
        GameProfile prev = this.profile;
        this.profile = new GameProfile(uuid, prev.getName());
        CraftPlayerProfile.copyProfileProperties(prev, this.profile);
        return prev.getId();
    }

    @Override
    @Nullable
    public String getName() {
        return this.profile.getName();
    }

    @Override
    public String setName(@Nullable String name) {
        GameProfile prev = this.profile;
        this.profile = new GameProfile(prev.getId(), name);
        CraftPlayerProfile.copyProfileProperties(prev, this.profile);
        return prev.getName();
    }

    @Override
    @Nonnull
    public Set<ProfileProperty> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Collection<ProfileProperty> properties) {
        properties.forEach(this::setProperty);
    }

    @Override
    public void clearProperties() {
        this.profile.getProperties().clear();
    }

    @Override
    public boolean removeProperty(String property) {
        return !this.profile.getProperties().removeAll((Object)property).isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CraftPlayerProfile that = (CraftPlayerProfile)o;
        return Objects.equals(this.profile, that.profile);
    }

    public int hashCode() {
        return this.profile.hashCode();
    }

    public String toString() {
        return this.profile.toString();
    }

    public CraftPlayerProfile clone() {
        CraftPlayerProfile clone = new CraftPlayerProfile(this.getId(), this.getName());
        clone.setProperties(this.getProperties());
        return clone;
    }

    @Override
    public boolean isComplete() {
        return this.profile.isComplete();
    }

    @Override
    public boolean completeFromCache() {
        MinecraftServer server = MinecraftServer.getServer();
        return this.completeFromCache(false, server.func_71266_T() || SpigotConfig.bungee);
    }

    @Override
    public boolean completeFromCache(boolean onlineMode) {
        return this.completeFromCache(false, onlineMode);
    }

    @Override
    public boolean completeFromCache(boolean lookupUUID, boolean onlineMode) {
        GameProfile profile;
        MinecraftServer server = MinecraftServer.getServer();
        String name = this.profile.getName();
        PlayerProfileCache userCache = server.func_152358_ax();
        if (this.profile.getId() == null && (profile = onlineMode ? (lookupUUID ? userCache.func_152655_a(name) : userCache.getProfileIfCached(name)) : new GameProfile(UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(Charsets.UTF_8)), name)) != null) {
            CraftPlayerProfile.copyProfileProperties(this.profile, profile);
            this.profile = profile;
        }
        if (!(this.profile.getName() != null && this.hasTextures() || this.profile.getId() == null || (profile = userCache.func_152652_a(this.profile.getId())) == null)) {
            if (this.profile.getName() == null) {
                CraftPlayerProfile.copyProfileProperties(this.profile, profile);
                this.profile = profile;
            } else {
                CraftPlayerProfile.copyProfileProperties(profile, this.profile);
            }
        }
        return this.profile.isComplete();
    }

    @Override
    public boolean complete(boolean textures) {
        MinecraftServer server = MinecraftServer.getServer();
        return this.complete(textures, server.func_71266_T() || SpigotConfig.bungee);
    }

    @Override
    public boolean complete(boolean textures, boolean onlineMode) {
        MinecraftServer server = MinecraftServer.getServer();
        boolean isCompleteFromCache = this.completeFromCache(true, onlineMode);
        if (onlineMode && (!isCompleteFromCache || textures && !this.hasTextures())) {
            GameProfile result = server.func_147130_as().fillProfileProperties(this.profile, true);
            if (result != null) {
                CraftPlayerProfile.copyProfileProperties(result, this.profile, true);
            }
            if (this.profile.isComplete()) {
                server.func_152358_ax().func_152649_a(this.profile);
            }
        }
        return this.profile.isComplete() && (!onlineMode || !textures || this.hasTextures());
    }

    private static void copyProfileProperties(GameProfile source, GameProfile target) {
        CraftPlayerProfile.copyProfileProperties(source, target, false);
    }

    private static void copyProfileProperties(GameProfile source, GameProfile target, boolean clearTarget) {
        PropertyMap sourceProperties = source.getProperties();
        PropertyMap targetProperties = target.getProperties();
        if (clearTarget) {
            targetProperties.clear();
        }
        if (sourceProperties.isEmpty()) {
            return;
        }
        for (Property property : sourceProperties.values()) {
            targetProperties.removeAll((Object)property.getName());
            targetProperties.put((Object)property.getName(), (Object)property);
        }
    }

    private static ProfileProperty toBukkit(Property property) {
        return new ProfileProperty(property.getName(), property.getValue(), property.getSignature());
    }

    public static PlayerProfile asBukkitCopy(GameProfile gameProfile) {
        CraftPlayerProfile profile = new CraftPlayerProfile(gameProfile.getId(), gameProfile.getName());
        CraftPlayerProfile.copyProfileProperties(gameProfile, profile.profile);
        return profile;
    }

    public static PlayerProfile asBukkitMirror(GameProfile profile) {
        return new CraftPlayerProfile(profile);
    }

    public static Property asAuthlib(ProfileProperty property) {
        return new Property(property.getName(), property.getValue(), property.getSignature());
    }

    public static GameProfile asAuthlibCopy(PlayerProfile profile) {
        CraftPlayerProfile craft = (CraftPlayerProfile)profile;
        return CraftPlayerProfile.asAuthlib(craft.clone());
    }

    public static GameProfile asAuthlib(PlayerProfile profile) {
        CraftPlayerProfile craft = (CraftPlayerProfile)profile;
        return craft.getGameProfile();
    }

    private class PropertySet
    extends AbstractSet<ProfileProperty> {
        private PropertySet() {
        }

        @Override
        @Nonnull
        public Iterator<ProfileProperty> iterator() {
            return new ProfilePropertyIterator(CraftPlayerProfile.this.profile.getProperties().values().iterator());
        }

        @Override
        public int size() {
            return CraftPlayerProfile.this.profile.getProperties().size();
        }

        @Override
        public boolean add(ProfileProperty property) {
            CraftPlayerProfile.this.setProperty(property);
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends ProfileProperty> c) {
            CraftPlayerProfile.this.setProperties(c);
            return true;
        }

        @Override
        public boolean contains(Object o) {
            return o instanceof ProfileProperty && CraftPlayerProfile.this.profile.getProperties().containsKey((Object)((ProfileProperty)o).getName());
        }

        private class ProfilePropertyIterator
        implements Iterator<ProfileProperty> {
            private final Iterator<Property> iterator;

            ProfilePropertyIterator(Iterator<Property> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public ProfileProperty next() {
                return CraftPlayerProfile.toBukkit(this.iterator.next());
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        }
    }
}

