/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.util.set;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class LinkedSortedSet<E>
implements Iterable<E> {
    public final Comparator<? super E> comparator;
    protected Link<E> head;
    protected Link<E> tail;

    public LinkedSortedSet() {
        this(Comparator.naturalOrder());
    }

    public LinkedSortedSet(Comparator<? super E> comparator) {
        this.comparator = comparator;
    }

    public void clear() {
        this.tail = null;
        this.head = null;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            Link<E> next;
            {
                this.next = LinkedSortedSet.this.head;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public E next() {
                Link next = this.next;
                if (next == null) {
                    throw new NoSuchElementException();
                }
                this.next = next.next;
                return next.element;
            }
        };
    }

    public boolean addLast(E element) {
        Comparator<E> comparator = this.comparator;
        Link<E> curr = this.tail;
        if (curr != null) {
            int compare;
            while ((compare = comparator.compare(element, curr.element)) < 0) {
                Link<E> prev = curr;
                curr = curr.prev;
                if (curr != null) continue;
                prev.prev = new Link<E>(element, null, prev);
                this.head = prev.prev;
                return true;
            }
            if (compare != 0) {
                Link next = curr.next;
                Link<E> insert = new Link<E>(element, curr, next);
                curr.next = insert;
                if (next == null) {
                    this.tail = insert;
                } else {
                    next.prev = insert;
                }
                return true;
            }
            return false;
        }
        this.tail = new Link<E>(element);
        this.head = this.tail;
        return true;
    }

    public boolean addFirst(E element) {
        Comparator<E> comparator = this.comparator;
        Link<E> curr = this.head;
        if (curr != null) {
            Link<E> prev;
            int compare;
            while ((compare = comparator.compare(element, curr.element)) > 0) {
                prev = curr;
                curr = curr.next;
                if (curr != null) continue;
                prev.next = new Link<E>(element, prev, null);
                this.tail = prev.next;
                return true;
            }
            if (compare != 0) {
                prev = curr.prev;
                Link<E> insert = new Link<E>(element, prev, curr);
                curr.prev = insert;
                if (prev == null) {
                    this.head = insert;
                } else {
                    prev.next = insert;
                }
                return true;
            }
            return false;
        }
        this.tail = new Link<E>(element);
        this.head = this.tail;
        return true;
    }

    protected static final class Link<E> {
        public E element;
        public Link<E> prev;
        public Link<E> next;

        public Link() {
        }

        public Link(E element) {
            this.element = element;
        }

        public Link(E element, Link<E> prev, Link<E> next) {
            this.element = element;
            this.prev = prev;
            this.next = next;
        }
    }
}

