/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.api.mc;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerWorld;

public abstract class ChunkMcAPI {
    public static boolean isBorderChunkLoaded(ServerWorld world, int cX, int cZ) {
        return ChunkMcAPI.getBorderChunkNow(world, cX, cZ).isPresent();
    }

    public static boolean isBorderChunkLoaded(ServerWorld world, long cPos) {
        return ChunkMcAPI.getBorderChunkNow(world, cPos).isPresent();
    }

    public static boolean isBorderChunkLoaded(ChunkHolder holder) {
        return ChunkMcAPI.getBorderChunkNow(holder).isPresent();
    }

    public static boolean isTickingChunkLoaded(ServerWorld world, int cX, int cZ) {
        return ChunkMcAPI.getTickingChunkNow(world, cX, cZ).isPresent();
    }

    public static boolean isTickingChunkLoaded(ServerWorld world, long cPos) {
        return ChunkMcAPI.getTickingChunkNow(world, cPos).isPresent();
    }

    public static boolean isTickingChunkLoaded(ChunkHolder holder) {
        return ChunkMcAPI.getTickingChunkNow(holder).isPresent();
    }

    public static boolean isEntityTickingChunkLoaded(ServerWorld world, int cX, int cZ) {
        return ChunkMcAPI.getEntityTickingChunkNow(world, cX, cZ).isPresent();
    }

    public static boolean isEntityTickingChunkLoaded(ServerWorld world, long cPos) {
        return ChunkMcAPI.getEntityTickingChunkNow(world, cPos).isPresent();
    }

    public static boolean isEntityTickingChunkLoaded(ChunkHolder holder) {
        return ChunkMcAPI.getEntityTickingChunkNow(holder).isPresent();
    }

    public static Optional<Chunk> getBorderChunkNow(ServerWorld world, int cX, int cZ) {
        return ChunkMcAPI._getChunkNow(ChunkMcAPI.getChunkHolder(world, cX, cZ).orElse(null), ChunkHolder.LocationType.BORDER);
    }

    public static Optional<Chunk> getBorderChunkNow(ServerWorld world, long cPos) {
        return ChunkMcAPI._getChunkNow(ChunkMcAPI.getChunkHolder(world, cPos).orElse(null), ChunkHolder.LocationType.BORDER);
    }

    public static Optional<Chunk> getBorderChunkNow(ChunkHolder holder) {
        return ChunkMcAPI._getChunkNow(holder, ChunkHolder.LocationType.BORDER);
    }

    public static Optional<Chunk> getTickingChunkNow(ServerWorld world, int cX, int cZ) {
        return ChunkMcAPI._getChunkNow(ChunkMcAPI.getChunkHolder(world, cX, cZ).orElse(null), ChunkHolder.LocationType.TICKING);
    }

    public static Optional<Chunk> getTickingChunkNow(ServerWorld world, long cPos) {
        return ChunkMcAPI._getChunkNow(ChunkMcAPI.getChunkHolder(world, cPos).orElse(null), ChunkHolder.LocationType.TICKING);
    }

    public static Optional<Chunk> getTickingChunkNow(ChunkHolder holder) {
        return ChunkMcAPI._getChunkNow(holder, ChunkHolder.LocationType.TICKING);
    }

    public static Optional<Chunk> getEntityTickingChunkNow(ServerWorld world, int cX, int cZ) {
        return ChunkMcAPI._getChunkNow(ChunkMcAPI.getChunkHolder(world, cX, cZ).orElse(null), ChunkHolder.LocationType.ENTITY_TICKING);
    }

    public static Optional<Chunk> getEntityTickingChunkNow(ServerWorld world, long cPos) {
        return ChunkMcAPI._getChunkNow(ChunkMcAPI.getChunkHolder(world, cPos).orElse(null), ChunkHolder.LocationType.ENTITY_TICKING);
    }

    public static Optional<Chunk> getEntityTickingChunkNow(ChunkHolder holder) {
        return ChunkMcAPI._getChunkNow(holder, ChunkHolder.LocationType.ENTITY_TICKING);
    }

    public static Optional<ChunkHolder> getChunkHolder(ServerWorld world, int cX, int cZ) {
        return ChunkMcAPI._getChunkHolder(world, ChunkPos.func_77272_a((int)cX, (int)cZ));
    }

    public static Optional<ChunkHolder> getChunkHolder(ServerWorld world, long cPos) {
        return ChunkMcAPI._getChunkHolder(world, cPos);
    }

    private static Optional<Chunk> _getChunkNow(ChunkHolder holder, ChunkHolder.LocationType type) {
        if (holder != null) {
            CompletableFuture future;
            switch (type) {
                case BORDER: {
                    future = holder.func_223492_c();
                    break;
                }
                case TICKING: {
                    future = holder.func_219296_a();
                    break;
                }
                case ENTITY_TICKING: {
                    future = holder.func_219297_b();
                    break;
                }
                default: {
                    future = null;
                }
            }
            if (future != null) {
                return future.getNow(ChunkHolder.field_219308_c).left();
            }
        }
        return Optional.empty();
    }

    private static Optional<ChunkHolder> _getChunkHolder(ServerWorld world, long cPos) {
        if (world == null) {
            throw new IllegalArgumentException("`world` must not be null in getChunkHolder(...) call!");
        }
        return Optional.ofNullable(world.func_72863_F().field_217237_a.func_219219_b(cPos));
    }
}

