/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.bukkit.nms.remappers;

import com.google.common.collect.Maps;
import com.mohistmc.bukkit.nms.proxy.DelegateClassLoder;
import com.mohistmc.bukkit.nms.proxy.DelegateURLClassLoder;
import com.mohistmc.bukkit.nms.remappers.ReflectMethodRemapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class MohistSuperClassRemapper {
    public static Map<String, Class<?>> defineClass = Maps.newHashMap();

    public static void init(ClassNode node) {
        boolean remapSpClass = false;
        switch (node.superName) {
            case "java/net/URLClassLoader": {
                node.superName = Type.getInternalName(DelegateURLClassLoder.class);
                remapSpClass = true;
                break;
            }
            case "java/lang/ClassLoader": {
                defineClass.put(node.name + ";defineClass", DelegateClassLoder.class);
                node.superName = Type.getInternalName(DelegateClassLoder.class);
                remapSpClass = true;
            }
        }
        for (MethodNode method : node.methods) {
            for (AbstractInsnNode next : method.instructions) {
                if (next instanceof TypeInsnNode && next.getOpcode() == 187) {
                    TypeInsnNode insn = (TypeInsnNode)next;
                    switch (insn.desc) {
                        case "java/net/URLClassLoader": {
                            insn.desc = Type.getInternalName(DelegateURLClassLoder.class);
                            remapSpClass = true;
                            break;
                        }
                        case "java/lang/ClassLoader": {
                            insn.desc = Type.getInternalName(DelegateClassLoder.class);
                            remapSpClass = true;
                        }
                    }
                }
                if (!(next instanceof MethodInsnNode)) continue;
                MethodInsnNode ins = (MethodInsnNode)next;
                block16 : switch (ins.getOpcode()) {
                    case 182: {
                        MohistSuperClassRemapper.remapVirtual(next);
                        break;
                    }
                    case 183: {
                        if (!remapSpClass || !ins.name.equals("<init>")) break;
                        switch (ins.owner) {
                            case "java/net/URLClassLoader": {
                                ins.owner = Type.getInternalName(DelegateURLClassLoder.class);
                                break block16;
                            }
                            case "java/lang/ClassLoader": {
                                ins.owner = Type.getInternalName(DelegateClassLoder.class);
                            }
                        }
                    }
                }
            }
        }
    }

    public static void remapVirtual(AbstractInsnNode insn) {
        MethodInsnNode method = (MethodInsnNode)insn;
        Class<?> proxyClass = ReflectMethodRemapper.getVirtualMethod().get(method.owner + ";" + method.name);
        if (proxyClass != null) {
            Type returnType = Type.getReturnType((String)method.desc);
            ArrayList<Type> args = new ArrayList<Type>();
            args.add(Type.getObjectType((String)method.owner));
            args.addAll(Arrays.asList(Type.getArgumentTypes((String)method.desc)));
            method.setOpcode(184);
            method.owner = Type.getInternalName(proxyClass);
            method.desc = Type.getMethodDescriptor((Type)returnType, (Type[])args.toArray(new Type[0]));
        } else {
            proxyClass = defineClass.get(method.owner + ";" + method.name);
            if (proxyClass != null) {
                method.name = method.name + "Mohist";
                method.owner = Type.getInternalName(proxyClass);
            }
        }
    }
}

