/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.forge;

import com.mohistmc.api.PlayerAPI;
import com.mohistmc.forge.ForgeInjectBukkit;
import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.IPermissionHandler;
import net.minecraftforge.server.permission.context.IContext;
import org.bukkit.Bukkit;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;

public class BukkitPermissionsHandler
implements IPermissionHandler {
    @Override
    public void registerNode(@NotNull String node, @NotNull DefaultPermissionLevel level, @NotNull String desc) {
        ForgeInjectBukkit.registerDefaultPermission(node, level, desc);
    }

    @Override
    @NotNull
    public Collection<String> getRegisteredNodes() {
        return Bukkit.getPluginManager().getPermissions().stream().map(Permission::getName).collect(Collectors.toList());
    }

    @Override
    public boolean hasPermission(@NotNull GameProfile profile, @NotNull String node, @NotNull IContext context) {
        Object player;
        if (context != null && (player = context.getPlayer()) != null) {
            return player.getBukkitEntity().hasPermission(node);
        }
        player = Bukkit.getPlayer(profile.getId());
        if (player != null) {
            return player.hasPermission(node);
        }
        Permission permission = Bukkit.getPluginManager().getPermission(node);
        boolean op = PlayerAPI.isOp(profile);
        if (permission != null) {
            return permission.getDefault().getValue(op);
        }
        return Permission.DEFAULT_PERMISSION.getValue(op);
    }

    @Override
    @NotNull
    public String getNodeDescription(@NotNull String desc) {
        Permission permission = Bukkit.getPluginManager().getPermission(desc);
        return permission != null ? permission.getDescription() : "No Description Set";
    }
}

