/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.util;

import java.io.File;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import sun.misc.Unsafe;

public class MohistModuleManager {
    List<Module> loadedModules = new ArrayList<Module>();
    private boolean moduleOptionAvailable = false;

    public MohistModuleManager() {
        try {
            Unsafe unsafe = this.getUnsafe();
            unsafe.putObject(MohistModuleManager.class, unsafe.objectFieldOffset(Class.class.getDeclaredField("module")), Class.class.getModule());
            this.moduleOptionAvailable = true;
            this.addExportsToAllUnnamed("java.base", "sun.security.util");
            this.addOpensToAllUnnamed("java.base", "java.util.jar");
            this.addOpensToAllUnnamed("java.base", "java.lang");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isModuleOptionAvailable() {
        return this.moduleOptionAvailable;
    }

    public Optional<Module> findModule(String name) {
        return Stream.concat(this.getDefaultModuleLayer().modules().stream(), this.loadedModules.stream()).filter(module -> module.getName().equals(name)).findAny();
    }

    public boolean addOpens(String moduleName, String packageName, String applyTo) {
        return this.addModuleOption("addOpens", moduleName, packageName, applyTo);
    }

    public boolean addOpensToAllUnnamed(String moduleName, String packageName) {
        return this.addModuleOption("addOpensToAllUnnamed", moduleName, packageName, null);
    }

    public boolean addExports(String moduleName, String packageName, String applyTo) {
        return this.addModuleOption("addOpens", moduleName, packageName, applyTo);
    }

    public boolean addExportsToAllUnnamed(String moduleName, String packageName) {
        return this.addModuleOption("addExportsToAllUnnamed", moduleName, packageName, null);
    }

    private boolean addModuleOption(String methodName, String moduleFrom, String packageName, String moduleTo) {
        try {
            Optional<Module> moduleFrom_ = this.findModule(moduleFrom);
            Optional<Module> moduleTo_ = this.findModule(moduleTo);
            if (!moduleFrom_.isPresent()) {
                return false;
            }
            if (moduleTo_.isPresent()) {
                Class.forName("jdk.internal.module.Modules").getMethod(methodName, Module.class, String.class, Module.class).invoke(null, moduleFrom_.get(), packageName, moduleTo_.get());
            } else if (methodName.endsWith("Unnamed")) {
                Class.forName("jdk.internal.module.Modules").getMethod(methodName, Module.class, String.class).invoke(null, moduleFrom_.get(), packageName);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void loadModule(File moduleFile) {
        this.loadModules(moduleFile);
    }

    public void loadModules(File ... moduleFiles) {
        ModuleLayer currentModuleLayer = this.getDefaultModuleLayer();
        ModuleFinder moduleFinder = ModuleFinder.of((Path[])Arrays.stream(moduleFiles).map(File::toPath).toArray(Path[]::new));
        Set<String> moduleNames = moduleFinder.findAll().stream().map(moduleRef -> moduleRef.descriptor().name()).collect(Collectors.toSet());
        Configuration configuration = currentModuleLayer.configuration().resolveAndBind(moduleFinder, ModuleFinder.of(new Path[0]), moduleNames);
        ModuleLayer moduleLayer = currentModuleLayer.defineModulesWithOneLoader(configuration, ClassLoader.getSystemClassLoader());
        this.loadedModules.addAll(moduleLayer.modules());
    }

    private ModuleLayer getDefaultModuleLayer() {
        return ModuleLayer.boot();
    }

    public Unsafe getUnsafe() throws IllegalAccessException, NoSuchFieldException {
        Field f = Unsafe.class.getDeclaredField("theUnsafe");
        f.setAccessible(true);
        return (Unsafe)f.get(null);
    }
}

