/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="forge", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ModelDataManager {
    private static WeakReference<World> currentWorld = new WeakReference<Object>(null);
    private static final Map<ChunkPos, Set<BlockPos>> needModelDataRefresh = new ConcurrentHashMap<ChunkPos, Set<BlockPos>>();
    private static final Map<ChunkPos, Map<BlockPos, IModelData>> modelDataCache = new ConcurrentHashMap<ChunkPos, Map<BlockPos, IModelData>>();

    private static void cleanCaches(World world) {
        Preconditions.checkNotNull((Object)world, (Object)"World must not be null");
        Preconditions.checkArgument((world == Minecraft.func_71410_x().field_71441_e ? 1 : 0) != 0, (Object)"Cannot use model data for a world other than the current client world");
        if (world != currentWorld.get()) {
            currentWorld = new WeakReference<World>(world);
            needModelDataRefresh.clear();
            modelDataCache.clear();
        }
    }

    public static void requestModelDataRefresh(TileEntity te) {
        Preconditions.checkNotNull((Object)te, (Object)"Tile entity must not be null");
        World world = te.func_145831_w();
        ModelDataManager.cleanCaches(world);
        needModelDataRefresh.computeIfAbsent(new ChunkPos(te.func_174877_v()), $ -> Collections.synchronizedSet(new HashSet())).add(te.func_174877_v());
    }

    private static void refreshModelData(World world, ChunkPos chunk) {
        ModelDataManager.cleanCaches(world);
        Set<BlockPos> needUpdate = needModelDataRefresh.remove(chunk);
        if (needUpdate != null) {
            Map data = modelDataCache.computeIfAbsent(chunk, $ -> new ConcurrentHashMap());
            for (BlockPos pos : needUpdate) {
                TileEntity toUpdate = world.func_175625_s(pos);
                if (toUpdate != null && !toUpdate.func_145837_r()) {
                    data.put(pos, toUpdate.getModelData());
                    continue;
                }
                data.remove(pos);
            }
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        if (!event.getChunk().getWorldForge().func_201670_d()) {
            return;
        }
        ChunkPos chunk = event.getChunk().func_76632_l();
        needModelDataRefresh.remove(chunk);
        modelDataCache.remove(chunk);
    }

    @Nullable
    public static IModelData getModelData(World world, BlockPos pos) {
        return ModelDataManager.getModelData(world, new ChunkPos(pos)).get(pos);
    }

    public static Map<BlockPos, IModelData> getModelData(World world, ChunkPos pos) {
        Preconditions.checkArgument((boolean)world.field_72995_K, (Object)"Cannot request model data for server world");
        ModelDataManager.refreshModelData(world, pos);
        return modelDataCache.getOrDefault(pos, Collections.emptyMap());
    }
}

