/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.b3d;

import com.google.common.base.Objects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoadingException;
import net.minecraftforge.client.model.ModelTransformComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.b3d.B3DClip;
import net.minecraftforge.client.model.b3d.B3DModel;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.common.model.Models;
import net.minecraftforge.common.model.TransformationHelper;
import net.minecraftforge.common.model.animation.IClip;
import net.minecraftforge.common.model.animation.IJoint;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum B3DLoader implements ISelectiveResourceReloadListener
{
    INSTANCE;

    private static final Logger LOGGER;
    private IResourceManager manager;
    private final Set<String> enabledDomains = new HashSet<String>();
    private final Map<ResourceLocation, B3DModel> cache = new HashMap<ResourceLocation, B3DModel>();

    @Override
    public void onResourceManagerReload(IResourceManager manager, Predicate<IResourceType> resourcePredicate) {
        this.manager = manager;
        this.cache.clear();
    }

    public IUnbakedModel loadModel(ResourceLocation modelLocation) throws Exception {
        B3DModel model;
        ResourceLocation file = new ResourceLocation(modelLocation.func_110624_b(), modelLocation.func_110623_a());
        if (!this.cache.containsKey(file)) {
            IResource resource = null;
            try {
                try {
                    resource = this.manager.func_199002_a(file);
                }
                catch (FileNotFoundException e) {
                    if (modelLocation.func_110623_a().startsWith("models/block/")) {
                        resource = this.manager.func_199002_a(new ResourceLocation(file.func_110624_b(), "models/item/" + file.func_110623_a().substring("models/block/".length())));
                    }
                    if (modelLocation.func_110623_a().startsWith("models/item/")) {
                        resource = this.manager.func_199002_a(new ResourceLocation(file.func_110624_b(), "models/block/" + file.func_110623_a().substring("models/item/".length())));
                    }
                    throw e;
                }
                B3DModel.Parser parser = new B3DModel.Parser(resource.func_199027_b());
                B3DModel model2 = parser.parse();
                this.cache.put(file, model2);
            }
            catch (IOException e) {
                try {
                    this.cache.put(file, null);
                    throw e;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(resource);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable)resource);
        }
        if ((model = this.cache.get(file)) == null) {
            throw new ModelLoadingException("Error loading model previously: " + file);
        }
        if (!(model.getRoot().getKind() instanceof B3DModel.Mesh)) {
            return new ModelWrapper(modelLocation, model, (ImmutableSet<String>)ImmutableSet.of(), true, true, true, 1);
        }
        return new ModelWrapper(modelLocation, model, (ImmutableSet<String>)ImmutableSet.of((Object)model.getRoot().getName()), true, true, true, 1);
    }

    static {
        LOGGER = LogManager.getLogger();
    }

    private static final class BakedWrapper
    implements IDynamicBakedModel {
        private final B3DModel.Node<?> node;
        private final IModelTransform state;
        private final boolean smooth;
        private final boolean gui3d;
        private final boolean isSideLit;
        private final ImmutableSet<String> meshes;
        private final ImmutableMap<String, TextureAtlasSprite> textures;
        private final LoadingCache<Integer, B3DState> cache;
        private ImmutableList<BakedQuad> quads;

        public BakedWrapper(final B3DModel.Node<?> node, final IModelTransform state, boolean smooth, boolean gui3d, boolean isSideLit, ImmutableSet<String> meshes, ImmutableMap<String, TextureAtlasSprite> textures) {
            this(node, state, smooth, gui3d, isSideLit, meshes, textures, (LoadingCache<Integer, B3DState>)CacheBuilder.newBuilder().maximumSize(128L).expireAfterAccess(2L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Integer, B3DState>(){

                public B3DState load(Integer frame) throws Exception {
                    IModelTransform parent = state;
                    B3DModel.Animation newAnimation = node.getAnimation();
                    if (parent instanceof B3DState) {
                        B3DState ps = (B3DState)parent;
                        parent = ps.getParent();
                    }
                    return new B3DState(newAnimation, frame, frame, 0.0f, parent);
                }
            }));
        }

        public BakedWrapper(B3DModel.Node<?> node, IModelTransform state, boolean smooth, boolean gui3d, boolean isSideLit, ImmutableSet<String> meshes, ImmutableMap<String, TextureAtlasSprite> textures, LoadingCache<Integer, B3DState> cache) {
            this.node = node;
            this.state = state;
            this.smooth = smooth;
            this.gui3d = gui3d;
            this.isSideLit = isSideLit;
            this.meshes = meshes;
            this.textures = textures;
            this.cache = cache;
        }

        @Override
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData data) {
            ImmutableList.Builder builder;
            if (side != null) {
                return ImmutableList.of();
            }
            Object modelState = this.state;
            IModelTransform newState = data.getData(Properties.AnimationProperty);
            if (newState != null) {
                IModelTransform parent = this.state;
                if (parent instanceof B3DState) {
                    B3DState ps = (B3DState)parent;
                    parent = ps.getParent();
                }
                modelState = parent == null ? newState : new ModelTransformComposition(parent, newState);
            }
            if (this.quads == null) {
                builder = ImmutableList.builder();
                this.generateQuads((ImmutableList.Builder<BakedQuad>)builder, this.node, this.state, (ImmutableList<String>)ImmutableList.of());
                this.quads = builder.build();
            }
            if (this.state != modelState) {
                builder = ImmutableList.builder();
                this.generateQuads((ImmutableList.Builder<BakedQuad>)builder, this.node, (IModelTransform)modelState, (ImmutableList<String>)ImmutableList.of());
                return builder.build();
            }
            return this.quads;
        }

        private void generateQuads(ImmutableList.Builder<BakedQuad> builder, B3DModel.Node<?> node, final IModelTransform state, ImmutableList<String> path) {
            ImmutableList.Builder pathBuilder = ImmutableList.builder();
            pathBuilder.addAll(path);
            pathBuilder.add((Object)node.getName());
            ImmutableList newPath = pathBuilder.build();
            for (B3DModel.Node child : node.getNodes().values()) {
                this.generateQuads(builder, child, state, (ImmutableList<String>)newPath);
            }
            if (node.getKind() instanceof B3DModel.Mesh && this.meshes.contains((Object)node.getName()) && state.getPartTransformation(Models.getHiddenModelPart((ImmutableList<String>)newPath)).isIdentity()) {
                B3DModel.Mesh mesh = (B3DModel.Mesh)node.getKind();
                ImmutableList<B3DModel.Face> faces = mesh.bake(new Function<B3DModel.Node<?>, Matrix4f>(){
                    private final TransformationMatrix global;
                    private final LoadingCache<B3DModel.Node<?>, TransformationMatrix> localCache;
                    {
                        this.global = state.func_225615_b_();
                        this.localCache = CacheBuilder.newBuilder().maximumSize(32L).build(new CacheLoader<B3DModel.Node<?>, TransformationMatrix>(){

                            public TransformationMatrix load(B3DModel.Node<?> node) throws Exception {
                                return state.getPartTransformation((Object)new NodeJoint(node));
                            }
                        });
                    }

                    @Override
                    public Matrix4f apply(B3DModel.Node<?> node) {
                        return this.global.func_227985_a_((TransformationMatrix)this.localCache.getUnchecked(node)).func_227988_c_();
                    }
                });
                for (B3DModel.Face f : faces) {
                    List<B3DModel.Texture> textures = null;
                    if (f.getBrush() != null) {
                        textures = f.getBrush().getTextures();
                    }
                    TextureAtlasSprite sprite = textures == null || textures.isEmpty() ? (TextureAtlasSprite)this.textures.get((Object)"missingno") : (textures.get(0) == B3DModel.Texture.White ? ModelLoader.White.instance() : (TextureAtlasSprite)this.textures.get((Object)textures.get(0).getPath()));
                    BakedQuadBuilder quadBuilder = new BakedQuadBuilder(sprite);
                    quadBuilder.setContractUVs(true);
                    quadBuilder.setQuadOrientation(Direction.func_176737_a((float)f.getNormal().func_195899_a(), (float)f.getNormal().func_195900_b(), (float)f.getNormal().func_195902_c()));
                    this.putVertexData(quadBuilder, f.getV1(), f.getNormal(), sprite);
                    this.putVertexData(quadBuilder, f.getV2(), f.getNormal(), sprite);
                    this.putVertexData(quadBuilder, f.getV3(), f.getNormal(), sprite);
                    this.putVertexData(quadBuilder, f.getV3(), f.getNormal(), sprite);
                    builder.add((Object)quadBuilder.build());
                }
            }
        }

        private final void putVertexData(IVertexConsumer consumer, B3DModel.Vertex v, Vector3f faceNormal, TextureAtlasSprite sprite) {
            ImmutableList vertexFormatElements = consumer.getVertexFormat().func_227894_c_();
            block6: for (int e = 0; e < vertexFormatElements.size(); ++e) {
                switch (((VertexFormatElement)vertexFormatElements.get(e)).func_177375_c()) {
                    case POSITION: {
                        consumer.put(e, v.getPos().func_195899_a(), v.getPos().func_195900_b(), v.getPos().func_195902_c(), 1.0f);
                        continue block6;
                    }
                    case COLOR: {
                        if (v.getColor() != null) {
                            consumer.put(e, v.getColor().func_195910_a(), v.getColor().func_195913_b(), v.getColor().func_195914_c(), v.getColor().func_195915_d());
                            continue block6;
                        }
                        consumer.put(e, 1.0f, 1.0f, 1.0f, 1.0f);
                        continue block6;
                    }
                    case UV: {
                        if (((VertexFormatElement)vertexFormatElements.get(e)).func_177369_e() < v.getTexCoords().length) {
                            consumer.put(e, sprite.func_94214_a((double)(v.getTexCoords()[0].func_195910_a() * 16.0f)), sprite.func_94207_b((double)(v.getTexCoords()[0].func_195913_b() * 16.0f)), 0.0f, 1.0f);
                            continue block6;
                        }
                        consumer.put(e, 0.0f, 0.0f, 0.0f, 1.0f);
                        continue block6;
                    }
                    case NORMAL: {
                        if (v.getNormal() != null) {
                            consumer.put(e, v.getNormal().func_195899_a(), v.getNormal().func_195900_b(), v.getNormal().func_195902_c(), 0.0f);
                            continue block6;
                        }
                        consumer.put(e, faceNormal.func_195899_a(), faceNormal.func_195900_b(), faceNormal.func_195902_c(), 0.0f);
                        continue block6;
                    }
                    default: {
                        consumer.put(e, new float[0]);
                    }
                }
            }
        }

        public boolean func_177555_b() {
            return this.smooth;
        }

        public boolean func_177556_c() {
            return this.gui3d;
        }

        public boolean func_230044_c_() {
            return this.isSideLit;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return (TextureAtlasSprite)this.textures.values().asList().get(0);
        }

        public boolean doesHandlePerspectives() {
            return true;
        }

        public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.state, cameraTransformType, mat);
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }
    }

    private static final class ModelWrapper
    implements IUnbakedModel {
        private final ResourceLocation modelLocation;
        private final B3DModel model;
        private final ImmutableSet<String> meshes;
        private final ImmutableMap<String, String> textures;
        private final boolean smooth;
        private final boolean gui3d;
        private final boolean isSideLit;
        private final int defaultKey;

        public ModelWrapper(ResourceLocation modelLocation, B3DModel model, ImmutableSet<String> meshes, boolean smooth, boolean gui3d, boolean isSideLit, int defaultKey) {
            this(modelLocation, model, meshes, smooth, gui3d, isSideLit, defaultKey, ModelWrapper.buildTextures(model.getTextures()));
        }

        public ModelWrapper(ResourceLocation modelLocation, B3DModel model, ImmutableSet<String> meshes, boolean smooth, boolean gui3d, boolean isSideLit, int defaultKey, ImmutableMap<String, String> textures) {
            this.modelLocation = modelLocation;
            this.model = model;
            this.meshes = meshes;
            this.isSideLit = isSideLit;
            this.textures = textures;
            this.smooth = smooth;
            this.gui3d = gui3d;
            this.defaultKey = defaultKey;
        }

        private static ImmutableMap<String, String> buildTextures(List<B3DModel.Texture> textures) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (B3DModel.Texture t : textures) {
                String path = t.getPath();
                String location = ModelWrapper.getLocation(path);
                if (!location.startsWith("#")) {
                    location = "#" + location;
                }
                builder.put((Object)path, (Object)location);
            }
            return builder.build();
        }

        private static String getLocation(String path) {
            if (path.endsWith(".png")) {
                path = path.substring(0, path.length() - ".png".length());
            }
            return path;
        }

        public Collection<RenderMaterial> func_225614_a_(Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            return this.textures.values().stream().filter(loc -> !loc.startsWith("#")).map(t -> new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation(t))).collect(Collectors.toList());
        }

        public Collection<ResourceLocation> func_187965_e() {
            return Collections.emptyList();
        }

        @Nullable
        public IBakedModel func_225613_a_(ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ResourceLocation modelLocation) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            TextureAtlasSprite missing = spriteGetter.apply(new RenderMaterial(AtlasTexture.field_110575_b, MissingTextureSprite.func_195675_b()));
            for (Map.Entry e : this.textures.entrySet()) {
                if (((String)e.getValue()).startsWith("#")) {
                    LOGGER.fatal("unresolved texture '{}' for b3d model '{}'", e.getValue(), (Object)this.modelLocation);
                    builder.put((Object)((String)e.getKey()), (Object)missing);
                    continue;
                }
                builder.put((Object)((String)e.getKey()), (Object)spriteGetter.apply(new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation((String)e.getValue()))));
            }
            builder.put((Object)"missingno", (Object)missing);
            return new BakedWrapper(this.model.getRoot(), modelTransform, this.smooth, this.gui3d, this.isSideLit, this.meshes, (ImmutableMap<String, TextureAtlasSprite>)builder.build());
        }

        public ModelWrapper retexture(ImmutableMap<String, String> textures) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry e : this.textures.entrySet()) {
                String path = (String)e.getKey();
                String loc = ModelWrapper.getLocation(path);
                if (loc.startsWith("#") && (textures.containsKey((Object)loc) || textures.containsKey((Object)loc.substring(1)))) {
                    String alt = loc.substring(1);
                    String newLoc = (String)textures.get((Object)loc);
                    if (newLoc == null) {
                        newLoc = (String)textures.get((Object)alt);
                    }
                    if (newLoc == null) {
                        newLoc = path.substring(1);
                    }
                    builder.put((Object)((String)e.getKey()), (Object)newLoc);
                    continue;
                }
                builder.put(e);
            }
            return new ModelWrapper(this.modelLocation, this.model, this.meshes, this.smooth, this.gui3d, this.isSideLit, this.defaultKey, (ImmutableMap<String, String>)builder.build());
        }

        public ModelWrapper process(ImmutableMap<String, String> data) {
            JsonElement e;
            ImmutableSet newMeshes = this.meshes;
            int newDefaultKey = this.defaultKey;
            boolean hasChanged = false;
            if (data.containsKey((Object)"mesh")) {
                e = new JsonParser().parse((String)data.get((Object)"mesh"));
                if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isString()) {
                    return new ModelWrapper(this.modelLocation, this.model, (ImmutableSet<String>)ImmutableSet.of((Object)e.getAsString()), this.smooth, this.gui3d, this.isSideLit, this.defaultKey, this.textures);
                }
                if (e.isJsonArray()) {
                    ImmutableSet.Builder builder = ImmutableSet.builder();
                    for (JsonElement s : e.getAsJsonArray()) {
                        if (s.isJsonPrimitive() && s.getAsJsonPrimitive().isString()) {
                            builder.add((Object)s.getAsString());
                            continue;
                        }
                        LOGGER.fatal("unknown mesh definition '{}' in array for b3d model '{}'", (Object)s.toString(), (Object)this.modelLocation);
                        return this;
                    }
                    newMeshes = builder.build();
                    hasChanged = true;
                } else {
                    LOGGER.fatal("unknown mesh definition '{}' for b3d model '{}'", (Object)e.toString(), (Object)this.modelLocation);
                    return this;
                }
            }
            if (data.containsKey((Object)"key")) {
                e = new JsonParser().parse((String)data.get((Object)"key"));
                if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isNumber()) {
                    newDefaultKey = e.getAsNumber().intValue();
                    hasChanged = true;
                } else {
                    LOGGER.fatal("unknown keyframe definition '{}' for b3d model '{}'", (Object)e.toString(), (Object)this.modelLocation);
                    return this;
                }
            }
            return hasChanged ? new ModelWrapper(this.modelLocation, this.model, newMeshes, this.smooth, this.gui3d, this.isSideLit, newDefaultKey, this.textures) : this;
        }

        public Optional<IClip> getClip(String name) {
            if (name.equals("main")) {
                return Optional.of(B3DClip.INSTANCE);
            }
            return Optional.empty();
        }

        public IModelTransform getDefaultState() {
            return new B3DState(this.model.getRoot().getAnimation(), this.defaultKey, this.defaultKey, 0.0f);
        }

        public ModelWrapper smoothLighting(boolean value) {
            if (value == this.smooth) {
                return this;
            }
            return new ModelWrapper(this.modelLocation, this.model, this.meshes, value, this.gui3d, this.isSideLit, this.defaultKey, this.textures);
        }

        public ModelWrapper gui3d(boolean value) {
            if (value == this.gui3d) {
                return this;
            }
            return new ModelWrapper(this.modelLocation, this.model, this.meshes, this.smooth, value, this.isSideLit, this.defaultKey, this.textures);
        }
    }

    static final class NodeJoint
    implements IJoint {
        private final B3DModel.Node<?> node;

        public NodeJoint(B3DModel.Node<?> node) {
            this.node = node;
        }

        @Override
        public TransformationMatrix getInvBindPose() {
            Matrix4f m = new TransformationMatrix(this.node.getPos(), this.node.getRot(), this.node.getScale(), null).func_227988_c_();
            m.func_226600_c_();
            TransformationMatrix pose = new TransformationMatrix(m);
            if (this.node.getParent() != null) {
                TransformationMatrix parent = new NodeJoint(this.node.getParent()).getInvBindPose();
                pose = pose.func_227985_a_(parent);
            }
            return pose;
        }

        public Optional<NodeJoint> getParent() {
            if (this.node.getParent() == null) {
                return Optional.empty();
            }
            return Optional.of(new NodeJoint(this.node.getParent()));
        }

        public B3DModel.Node<?> getNode() {
            return this.node;
        }

        public int hashCode() {
            return this.node.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeJoint other = (NodeJoint)obj;
            return Objects.equal(this.node, other.node);
        }
    }

    public static final class B3DState
    implements IModelTransform {
        @Nullable
        private final B3DModel.Animation animation;
        private final int frame;
        private final int nextFrame;
        private final float progress;
        @Nullable
        private final IModelTransform parent;
        private static LoadingCache<Triple<B3DModel.Animation, B3DModel.Node<?>, Integer>, TransformationMatrix> cache = CacheBuilder.newBuilder().maximumSize(16384L).expireAfterAccess(2L, TimeUnit.MINUTES).build(new CacheLoader<Triple<B3DModel.Animation, B3DModel.Node<?>, Integer>, TransformationMatrix>(){

            public TransformationMatrix load(Triple<B3DModel.Animation, B3DModel.Node<?>, Integer> key) throws Exception {
                return B3DState.getNodeMatrix((B3DModel.Animation)key.getLeft(), (B3DModel.Node)key.getMiddle(), (Integer)key.getRight());
            }
        });

        public B3DState(@Nullable B3DModel.Animation animation, int frame) {
            this(animation, frame, frame, 0.0f);
        }

        public B3DState(@Nullable B3DModel.Animation animation, int frame, IModelTransform parent) {
            this(animation, frame, frame, 0.0f, parent);
        }

        public B3DState(@Nullable B3DModel.Animation animation, int frame, int nextFrame, float progress) {
            this(animation, frame, nextFrame, progress, null);
        }

        public B3DState(@Nullable B3DModel.Animation animation, int frame, int nextFrame, float progress, @Nullable IModelTransform parent) {
            this.animation = animation;
            this.frame = frame;
            this.nextFrame = nextFrame;
            this.progress = MathHelper.func_76131_a((float)progress, (float)0.0f, (float)1.0f);
            this.parent = this.getParent(parent);
        }

        @Nullable
        private IModelTransform getParent(@Nullable IModelTransform parent) {
            if (parent == null) {
                return null;
            }
            if (parent instanceof B3DState) {
                return ((B3DState)parent).parent;
            }
            return parent;
        }

        @Nullable
        public B3DModel.Animation getAnimation() {
            return this.animation;
        }

        public int getFrame() {
            return this.frame;
        }

        public int getNextFrame() {
            return this.nextFrame;
        }

        public float getProgress() {
            return this.progress;
        }

        @Nullable
        public IModelTransform getParent() {
            return this.parent;
        }

        public TransformationMatrix func_225615_b_() {
            if (this.parent != null) {
                return this.parent.func_225615_b_();
            }
            return TransformationMatrix.func_227983_a_();
        }

        public TransformationMatrix getPartTransformation(Object part) {
            TransformationMatrix nodeTransform;
            if (!(part instanceof NodeJoint)) {
                return TransformationMatrix.func_227983_a_();
            }
            B3DModel.Node<?> node = ((NodeJoint)part).getNode();
            if ((double)this.progress < 1.0E-5 || this.frame == this.nextFrame) {
                nodeTransform = this.getNodeMatrix(node, this.frame);
            } else if ((double)this.progress > 0.99999) {
                nodeTransform = this.getNodeMatrix(node, this.nextFrame);
            } else {
                nodeTransform = this.getNodeMatrix(node, this.frame);
                nodeTransform = TransformationHelper.slerp(nodeTransform, this.getNodeMatrix(node, this.nextFrame), this.progress);
            }
            if (this.parent != null && node.getParent() == null) {
                return this.parent.getPartTransformation(part).func_227985_a_(nodeTransform);
            }
            return nodeTransform;
        }

        public TransformationMatrix getNodeMatrix(B3DModel.Node<?> node) {
            return this.getNodeMatrix(node, this.frame);
        }

        public TransformationMatrix getNodeMatrix(B3DModel.Node<?> node, int frame) {
            return (TransformationMatrix)cache.getUnchecked((Object)Triple.of((Object)this.animation, node, (Object)frame));
        }

        public static TransformationMatrix getNodeMatrix(@Nullable B3DModel.Animation animation, B3DModel.Node<?> node, int frame) {
            TransformationMatrix ret = TransformationMatrix.func_227983_a_();
            B3DModel.Key key = null;
            if (animation != null) {
                key = (B3DModel.Key)animation.getKeys().get((Object)frame, node);
            } else if (node.getAnimation() != null) {
                key = (B3DModel.Key)node.getAnimation().getKeys().get((Object)frame, node);
            }
            if (key != null) {
                B3DModel.Node<B3DModel.IKind<?>> parent = node.getParent();
                if (parent != null) {
                    TransformationMatrix pm = (TransformationMatrix)cache.getUnchecked((Object)Triple.of((Object)animation, node.getParent(), (Object)frame));
                    ret = ret.func_227985_a_(pm);
                    ret = ret.func_227985_a_(new TransformationMatrix(parent.getPos(), parent.getRot(), parent.getScale(), null));
                }
                ret = ret.func_227985_a_(new TransformationMatrix(key.getPos(), key.getRot(), key.getScale(), null));
                TransformationMatrix invBind = new NodeJoint(node).getInvBindPose();
                ret = ret.func_227985_a_(invBind);
            } else {
                B3DModel.Node<B3DModel.IKind<?>> parent = node.getParent();
                if (parent != null) {
                    TransformationMatrix pm = (TransformationMatrix)cache.getUnchecked((Object)Triple.of((Object)animation, node.getParent(), (Object)frame));
                    ret = ret.func_227985_a_(pm);
                    ret = ret.func_227985_a_(new TransformationMatrix(parent.getPos(), parent.getRot(), parent.getScale(), null));
                }
                ret = ret.func_227985_a_(new TransformationMatrix(node.getPos(), node.getRot(), node.getScale(), null));
                TransformationMatrix invBind = new NodeJoint(node).getInvBindPose();
                ret = ret.func_227985_a_(invBind);
            }
            return ret;
        }
    }
}

