/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.pipeline;

import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.model.pipeline.VertexLighterFlat;

public class VertexLighterSmoothAo
extends VertexLighterFlat {
    public VertexLighterSmoothAo(BlockColors colors) {
        super(colors);
    }

    @Override
    protected void updateLightmap(float[] normal, float[] lightmap, float x, float y, float z) {
        lightmap[0] = this.calcLightmap(this.blockInfo.getBlockLight(), x, y, z);
        lightmap[1] = this.calcLightmap(this.blockInfo.getSkyLight(), x, y, z);
    }

    @Override
    protected void updateColor(float[] normal, float[] color, float x, float y, float z, float tint, int multiplier) {
        super.updateColor(normal, color, x, y, z, tint, multiplier);
        float a = this.getAo(x, y, z);
        color[0] = color[0] * a;
        color[1] = color[1] * a;
        color[2] = color[2] * a;
    }

    protected float calcLightmap(float[][][][] light, float x, float y, float z) {
        float s;
        float l2;
        if ((l2 = (x *= 2.0f) * x + (y *= 2.0f) * y + (z *= 2.0f) * z) > 5.98f) {
            float s2 = (float)Math.sqrt(5.98f / l2);
            x *= s2;
            y *= s2;
            z *= s2;
        }
        float ax = x > 0.0f ? x : -x;
        float ay = y > 0.0f ? y : -y;
        float az = z > 0.0f ? z : -z;
        float e1 = 1.0001f;
        if (ax > 1.9999f && ay <= e1 && az <= e1) {
            x = x < 0.0f ? -1.9999f : 1.9999f;
        } else if (ay > 1.9999f && az <= e1 && ax <= e1) {
            y = y < 0.0f ? -1.9999f : 1.9999f;
        } else if (az > 1.9999f && ax <= e1 && ay <= e1) {
            z = z < 0.0f ? -1.9999f : 1.9999f;
        }
        ax = x > 0.0f ? x : -x;
        ay = y > 0.0f ? y : -y;
        float f = az = z > 0.0f ? z : -z;
        if (ax <= e1 && ay + az > 2.9999f) {
            s = 2.9999f / (ay + az);
            y *= s;
            z *= s;
        } else if (ay <= e1 && az + ax > 2.9999f) {
            s = 2.9999f / (az + ax);
            z *= s;
            x *= s;
        } else if (az <= e1 && ax + ay > 2.9999f) {
            s = 2.9999f / (ax + ay);
            x *= s;
            y *= s;
        } else if (ax + ay + az > 3.9999f) {
            s = 3.9999f / (ax + ay + az);
            x *= s;
            y *= s;
            z *= s;
        }
        float l = 0.0f;
        float s3 = 0.0f;
        for (int ix = 0; ix <= 1; ++ix) {
            for (int iy = 0; iy <= 1; ++iy) {
                for (int iz = 0; iz <= 1; ++iz) {
                    float vx = x * (float)(1 - ix * 2);
                    float vy = y * (float)(1 - iy * 2);
                    float vz = z * (float)(1 - iz * 2);
                    float s32 = vx + vy + vz + 4.0f;
                    float sx = vy + vz + 3.0f;
                    float sy = vz + vx + 3.0f;
                    float sz = vx + vy + 3.0f;
                    float bx = (2.0f * vx + vy + vz + 6.0f) / (s32 * sy * sz * (vx + 2.0f));
                    s3 += bx;
                    l += bx * light[0][ix][iy][iz];
                    float by = (2.0f * vy + vz + vx + 6.0f) / (s32 * sz * sx * (vy + 2.0f));
                    s3 += by;
                    l += by * light[1][ix][iy][iz];
                    float bz = (2.0f * vz + vx + vy + 6.0f) / (s32 * sx * sy * (vz + 2.0f));
                    s3 += bz;
                    l += bz * light[2][ix][iy][iz];
                }
            }
        }
        l /= s3;
        l = MathHelper.func_76131_a((float)l, (float)0.0f, (float)1.0f);
        return l;
    }

    protected float getAo(float x, float y, float z) {
        int sz;
        int sx = x < 0.0f ? 1 : 2;
        int sy = y < 0.0f ? 1 : 2;
        int n = sz = z < 0.0f ? 1 : 2;
        if (x < 0.0f) {
            x += 1.0f;
        }
        if (y < 0.0f) {
            y += 1.0f;
        }
        if (z < 0.0f) {
            z += 1.0f;
        }
        float a = 0.0f;
        float[][][] ao = this.blockInfo.getAo();
        a += ao[sx - 1][sy - 1][sz - 1] * (1.0f - x) * (1.0f - y) * (1.0f - z);
        a += ao[sx - 1][sy - 1][sz - 0] * (1.0f - x) * (1.0f - y) * (0.0f + z);
        a += ao[sx - 1][sy - 0][sz - 1] * (1.0f - x) * (0.0f + y) * (1.0f - z);
        a += ao[sx - 1][sy - 0][sz - 0] * (1.0f - x) * (0.0f + y) * (0.0f + z);
        a += ao[sx - 0][sy - 1][sz - 1] * (0.0f + x) * (1.0f - y) * (1.0f - z);
        a += ao[sx - 0][sy - 1][sz - 0] * (0.0f + x) * (1.0f - y) * (0.0f + z);
        a += ao[sx - 0][sy - 0][sz - 1] * (0.0f + x) * (0.0f + y) * (1.0f - z);
        a += ao[sx - 0][sy - 0][sz - 0] * (0.0f + x) * (0.0f + y) * (0.0f + z);
        a = MathHelper.func_76131_a((float)a, (float)0.0f, (float)1.0f);
        return a;
    }

    @Override
    public void updateBlockInfo() {
        this.blockInfo.updateShift();
        this.blockInfo.updateLightMatrix();
    }
}

