/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraftforge.fml.loading.toposort.TopologicalSort;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdvancementLoadFix {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Map<Advancement, List<Advancement>> roots;

    public static void loadVisibility(PlayerAdvancements playerAdvancements, Set<Advancement> visible, Set<Advancement> visibilityChanged, Map<Advancement, AdvancementProgress> progress, Set<Advancement> progressChanged, Predicate<Advancement> shouldBeVisible) {
        if (roots == null) {
            throw new RuntimeException("Why did the advancements not load yet?!");
        }
        HashSet<Advancement> set = new HashSet<Advancement>();
        for (Map.Entry<Advancement, AdvancementProgress> entry : progress.entrySet()) {
            if (!entry.getValue().func_192105_a()) continue;
            set.add(entry.getKey());
            progressChanged.add(entry.getKey());
        }
        roots.values().stream().flatMap(Collection::stream).filter(adv -> AdvancementLoadFix.containsAncestor(adv, set)).forEach(adv -> AdvancementLoadFix.updateVisibility(adv, visible, visibilityChanged, progress, progressChanged, shouldBeVisible));
    }

    private static boolean containsAncestor(Advancement adv, Set<Advancement> set) {
        return set.contains(adv) || adv.func_192070_b() != null && AdvancementLoadFix.containsAncestor(adv.func_192070_b(), set);
    }

    private static void updateVisibility(Advancement adv, Set<Advancement> visible, Set<Advancement> visibilityChanged, Map<Advancement, AdvancementProgress> progress, Set<Advancement> progressChanged, Predicate<Advancement> shouldBeVisible) {
        boolean flag = shouldBeVisible.test(adv);
        boolean flag1 = visible.contains(adv);
        if (flag && !flag1) {
            visible.add(adv);
            visibilityChanged.add(adv);
            if (progress.containsKey(adv)) {
                progressChanged.add(adv);
            }
        } else if (!flag && flag1) {
            visible.remove(adv);
            visibilityChanged.add(adv);
        }
        if (flag != flag1 && adv.func_192070_b() != null) {
            AdvancementLoadFix.updateVisibility(adv.func_192070_b(), visible, visibilityChanged, progress, progressChanged, shouldBeVisible);
        }
    }

    public static void buildSortedTrees(Set<Advancement> roots) {
        AdvancementLoadFix.roots = roots.stream().map(AdvancementLoadFix::buildGraph).map(g -> TopologicalSort.topologicalSort((Graph)g, Comparator.comparing(Advancement::func_192067_g))).collect(Collectors.toMap(lst -> (Advancement)lst.get(0), Function.identity()));
    }

    private static Graph<Advancement> buildGraph(Advancement root) {
        MutableGraph tree = GraphBuilder.directed().build();
        AdvancementLoadFix.addEdgesAndChildren(root, (MutableGraph<Advancement>)tree);
        return tree;
    }

    private static void addEdgesAndChildren(Advancement root, MutableGraph<Advancement> tree) {
        tree.addNode((Object)root);
        for (Advancement adv : root.func_192069_e()) {
            AdvancementLoadFix.addEdgesAndChildren(adv, tree);
            tree.putEdge((Object)root, (Object)adv);
        }
    }
}

