/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import com.google.gson.JsonObject;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;

public class ForgeRecipeProvider
extends RecipeProvider {
    private Map<Item, ITag<Item>> replacements = new HashMap<Item, ITag<Item>>();
    private Set<ResourceLocation> excludes = new HashSet<ResourceLocation>();

    public ForgeRecipeProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    private void exclude(IItemProvider item) {
        this.excludes.add(item.func_199767_j().getRegistryName());
    }

    private void replace(IItemProvider item, ITag<Item> tag) {
        this.replacements.put(item.func_199767_j(), tag);
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        this.replace((IItemProvider)Items.field_151055_y, (ITag<Item>)Tags.Items.RODS_WOODEN);
        this.replace((IItemProvider)Items.field_151043_k, (ITag<Item>)Tags.Items.INGOTS_GOLD);
        this.replace((IItemProvider)Items.field_151042_j, (ITag<Item>)Tags.Items.INGOTS_IRON);
        this.replace((IItemProvider)Items.field_234759_km_, (ITag<Item>)Tags.Items.INGOTS_NETHERITE);
        this.replace((IItemProvider)Items.field_151045_i, (ITag<Item>)Tags.Items.GEMS_DIAMOND);
        this.replace((IItemProvider)Items.field_151166_bC, (ITag<Item>)Tags.Items.GEMS_EMERALD);
        this.replace((IItemProvider)Items.field_221675_bZ, (ITag<Item>)Tags.Items.CHESTS_WOODEN);
        this.replace((IItemProvider)Blocks.field_150347_e, (ITag<Item>)Tags.Items.COBBLESTONE);
        this.exclude((IItemProvider)Blocks.field_150340_R);
        this.exclude((IItemProvider)Items.field_151074_bl);
        this.exclude((IItemProvider)Blocks.field_150339_S);
        this.exclude((IItemProvider)Items.field_191525_da);
        this.exclude((IItemProvider)Blocks.field_150484_ah);
        this.exclude((IItemProvider)Blocks.field_150475_bE);
        this.exclude((IItemProvider)Blocks.field_235397_ng_);
        this.exclude((IItemProvider)Blocks.field_196659_cl);
        this.exclude((IItemProvider)Blocks.field_196646_bz);
        this.exclude((IItemProvider)Blocks.field_150463_bK);
        super.func_200404_a(vanilla -> {
            IFinishedRecipe modified = this.enhance((IFinishedRecipe)vanilla);
            if (modified != null) {
                consumer.accept(modified);
            }
        });
    }

    protected void func_208310_b(DirectoryCache cache, JsonObject advancementJson, Path pathIn) {
    }

    private IFinishedRecipe enhance(IFinishedRecipe vanilla) {
        if (vanilla instanceof ShapelessRecipeBuilder.Result) {
            return this.enhance((ShapelessRecipeBuilder.Result)vanilla);
        }
        if (vanilla instanceof ShapedRecipeBuilder.Result) {
            return this.enhance((ShapedRecipeBuilder.Result)vanilla);
        }
        return null;
    }

    private IFinishedRecipe enhance(ShapelessRecipeBuilder.Result vanilla) {
        List ingredients = (List)this.getField(ShapelessRecipeBuilder.Result.class, vanilla, 4);
        boolean modified = false;
        for (int x = 0; x < ingredients.size(); ++x) {
            Ingredient ing = this.enhance(vanilla.func_200442_b(), (Ingredient)ingredients.get(x));
            if (ing == null) continue;
            ingredients.set(x, ing);
            modified = true;
        }
        return modified ? vanilla : null;
    }

    private IFinishedRecipe enhance(ShapedRecipeBuilder.Result vanilla) {
        Map ingredients = (Map)this.getField(ShapedRecipeBuilder.Result.class, vanilla, 5);
        boolean modified = false;
        for (Character x : ingredients.keySet()) {
            Ingredient ing = this.enhance(vanilla.func_200442_b(), (Ingredient)ingredients.get(x));
            if (ing == null) continue;
            ingredients.put(x, ing);
            modified = true;
        }
        return modified ? vanilla : null;
    }

    private Ingredient enhance(ResourceLocation name, Ingredient vanilla) {
        Ingredient.IItemList[] vanillaItems;
        if (this.excludes.contains(name)) {
            return null;
        }
        boolean modified = false;
        ArrayList<Object> items = new ArrayList<Object>();
        for (Ingredient.IItemList entry : vanillaItems = (Ingredient.IItemList[])this.getField(Ingredient.class, vanilla, 2)) {
            if (entry instanceof Ingredient.SingleItemList) {
                ItemStack stack = entry.func_199799_a().stream().findFirst().orElse(ItemStack.field_190927_a);
                ITag<Item> replacement = this.replacements.get(stack.func_77973_b());
                if (replacement != null) {
                    items.add(new Ingredient.TagList(replacement));
                    modified = true;
                    continue;
                }
                items.add(entry);
                continue;
            }
            items.add(entry);
        }
        return modified ? Ingredient.func_209357_a(items.stream()) : null;
    }

    private <T, R> R getField(Class<T> clz, T inst, int index) {
        Field fld = clz.getDeclaredFields()[index];
        fld.setAccessible(true);
        try {
            return (R)fld.get(inst);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }
}

