/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids.capability.wrappers;

import net.minecraft.block.BlockState;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.VoidFluidHandler;

public class BlockWrapper
extends VoidFluidHandler {
    protected final BlockState state;
    protected final World world;
    protected final BlockPos blockPos;

    public BlockWrapper(BlockState state, World world, BlockPos blockPos) {
        this.state = state;
        this.world = world;
        this.blockPos = blockPos;
    }

    @Override
    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.getAmount() < 1000) {
            return 0;
        }
        if (action.execute()) {
            FluidUtil.destroyBlockOnFluidPlacement(this.world, this.blockPos);
            this.world.func_180501_a(this.blockPos, this.state, 11);
        }
        return 1000;
    }

    public static class LiquidContainerBlockWrapper
    extends VoidFluidHandler {
        protected final ILiquidContainer liquidContainer;
        protected final World world;
        protected final BlockPos blockPos;

        public LiquidContainerBlockWrapper(ILiquidContainer liquidContainer, World world, BlockPos blockPos) {
            this.liquidContainer = liquidContainer;
            this.world = world;
            this.blockPos = blockPos;
        }

        @Override
        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            BlockState state;
            if (resource.getAmount() >= 1000 && this.liquidContainer.func_204510_a((IBlockReader)this.world, this.blockPos, state = this.world.func_180495_p(this.blockPos), resource.getFluid()) && (action.simulate() || this.liquidContainer.func_204509_a((IWorld)this.world, this.blockPos, state, resource.getFluid().getAttributes().getStateForPlacement((IBlockDisplayReader)this.world, this.blockPos, resource)))) {
                return 1000;
            }
            return 0;
        }
    }
}

