/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import com.google.common.base.Stopwatch;
import com.mohistmc.util.i18n.i18n;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeferredWorkQueue {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Map<Class<? extends ParallelDispatchEvent>, DeferredWorkQueue> workQueues = new HashMap<Class<? extends ParallelDispatchEvent>, DeferredWorkQueue>();
    private final ModLoadingStage modLoadingStage;
    private final ConcurrentLinkedDeque<TaskInfo> tasks = new ConcurrentLinkedDeque();

    public DeferredWorkQueue(ModLoadingStage modLoadingStage, Class<? extends ParallelDispatchEvent> eventClass) {
        this.modLoadingStage = modLoadingStage;
        workQueues.put(eventClass, this);
    }

    public static Optional<DeferredWorkQueue> lookup(Optional<Class<? extends ParallelDispatchEvent>> parallelClass) {
        return Optional.ofNullable(workQueues.get(parallelClass.orElse(null)));
    }

    void runTasks() {
        if (this.tasks.isEmpty()) {
            return;
        }
        LOGGER.debug(Logging.LOADING, i18n.get((String)"deferredworkqueue.1", (Object[])new Object[]{this.modLoadingStage, this.tasks.size()}));
        StopWatch globalTimer = StopWatch.createStarted();
        this.tasks.forEach(t -> DeferredWorkQueue.makeRunnable(t, Runnable::run));
        LOGGER.debug(Logging.LOADING, i18n.get((String)"deferredworkqueue.2", (Object[])new Object[]{globalTimer}));
    }

    private static void makeRunnable(TaskInfo ti, Executor executor) {
        executor.execute(() -> {
            Stopwatch timer = Stopwatch.createStarted();
            ti.task.run();
            timer.stop();
            if (timer.elapsed(TimeUnit.SECONDS) >= 1L) {
                LOGGER.warn(Logging.LOADING, i18n.get((String)"deferredworkqueue.3", (Object[])new Object[]{ti.owner.getModId(), timer}));
            }
        });
    }

    public CompletableFuture<Void> enqueueWork(IModInfo modInfo, Runnable work) {
        return CompletableFuture.runAsync(work, r -> this.tasks.add(new TaskInfo(modInfo, r)));
    }

    public <T> CompletableFuture<T> enqueueWork(IModInfo modInfo, Supplier<T> work) {
        return CompletableFuture.supplyAsync(work, r -> this.tasks.add(new TaskInfo(modInfo, r)));
    }

    @Deprecated
    public static CompletableFuture<Void> runLater(Runnable workToEnqueue) {
        return Optional.ofNullable(ModLoadingContext.get().getActiveContainer().modLoadingStage.getDeferredWorkQueue()).map(wq -> wq.enqueueWork(ModLoadingContext.get().getActiveContainer().modInfo, workToEnqueue)).orElseGet(() -> CompletableFuture.completedFuture(null));
    }

    static class TaskInfo {
        public final IModInfo owner;
        public final Runnable task;

        private TaskInfo(IModInfo owner, Runnable task) {
            this.owner = owner;
            this.task = task;
        }
    }
}

