/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.SaveFormat;

public class WorldPersistenceHooks {
    private static List<WorldPersistenceHook> worldPersistenceHooks = new ArrayList<WorldPersistenceHook>();

    public static void addHook(WorldPersistenceHook hook) {
        worldPersistenceHooks.add(hook);
    }

    public static void handleWorldDataSave(SaveFormat.LevelSave levelSave, IServerConfiguration serverInfo, CompoundNBT tagCompound) {
        worldPersistenceHooks.forEach(wac -> tagCompound.func_218657_a(wac.getModId(), (INBT)wac.getDataForWriting(levelSave, serverInfo)));
    }

    public static void handleWorldDataLoad(SaveFormat.LevelSave levelSave, IServerConfiguration serverInfo, CompoundNBT tagCompound) {
        worldPersistenceHooks.forEach(wac -> wac.readData(levelSave, serverInfo, tagCompound.func_74775_l(wac.getModId())));
    }

    public static interface WorldPersistenceHook {
        public String getModId();

        public CompoundNBT getDataForWriting(SaveFormat.LevelSave var1, IServerConfiguration var2);

        public void readData(SaveFormat.LevelSave var1, IServerConfiguration var2, CompoundNBT var3);
    }
}

