/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.javafmlmod;

import com.mohistmc.util.i18n.i18n;
import java.util.Optional;
import net.minecraftforge.eventbus.EventBusErrorMessage;
import net.minecraftforge.eventbus.api.BusBuilder;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.IEventListener;
import net.minecraftforge.fml.AutomaticEventSubscriber;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingException;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.event.lifecycle.IModBusEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class FMLModContainer
extends ModContainer {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ModFileScanData scanResults;
    private final IEventBus eventBus;
    private Object modInstance;
    private final Class<?> modClass;

    public FMLModContainer(IModInfo info, String className, ClassLoader modClassLoader, ModFileScanData modFileScanResults) {
        super(info);
        LOGGER.debug(Logging.LOADING, i18n.get((String)"fmlmodcontainer.1", (Object[])new Object[]{className, modClassLoader, this.getClass().getClassLoader()}));
        this.scanResults = modFileScanResults;
        this.activityMap.put(ModLoadingStage.CONSTRUCT, this::constructMod);
        this.eventBus = BusBuilder.builder().setExceptionHandler(this::onEventFailed).setTrackPhases(false).markerType(IModBusEvent.class).build();
        this.configHandler = Optional.of(arg_0 -> ((IEventBus)this.eventBus).post(arg_0));
        FMLJavaModLoadingContext contextExtension = new FMLJavaModLoadingContext(this);
        this.contextExtension = () -> contextExtension;
        try {
            this.modClass = Class.forName(className, true, modClassLoader);
            LOGGER.debug(Logging.LOADING, i18n.get((String)"fmlmodcontainer.2", (Object[])new Object[]{this.modClass.getName(), this.modClass.getClassLoader()}));
        }
        catch (Throwable e) {
            LOGGER.error(Logging.LOADING, i18n.get((String)"fmlmodcontainer.3", (Object[])new Object[]{className}), e);
            throw new ModLoadingException(info, ModLoadingStage.CONSTRUCT, "fml.modloading.failedtoloadmodclass", e, new Object[0]);
        }
    }

    private void onEventFailed(IEventBus iEventBus, Event event, IEventListener[] iEventListeners, int i, Throwable throwable) {
        LOGGER.error((Message)new EventBusErrorMessage(event, i, iEventListeners, throwable));
    }

    private void constructMod() {
        try {
            LOGGER.debug(Logging.LOADING, i18n.get((String)"fmlmodcontainer.4", (Object[])new Object[]{this.getModId(), this.modClass.getName()}));
            this.modInstance = this.modClass.newInstance();
            LOGGER.debug(Logging.LOADING, i18n.get((String)"fmlmodcontainer.4", (Object[])new Object[]{this.getModId(), this.modClass.getName()}));
        }
        catch (Throwable e) {
            LOGGER.error(Logging.LOADING, i18n.get((String)"fmlmodcontainer.5", (Object[])new Object[]{this.getModId(), this.modClass.getName()}), e);
            throw new ModLoadingException(this.modInfo, ModLoadingStage.CONSTRUCT, "fml.modloading.failedtoloadmod", e, this.modClass);
        }
        try {
            LOGGER.debug(Logging.LOADING, i18n.get((String)"fmlmodcontainer.6", (Object[])new Object[]{this.getModId()}));
            AutomaticEventSubscriber.inject(this, this.scanResults, this.modClass.getClassLoader());
            LOGGER.debug(Logging.LOADING, i18n.get((String)"fmlmodcontainer.11", (Object[])new Object[]{this.getModId()}));
        }
        catch (Throwable e) {
            LOGGER.error(Logging.LOADING, i18n.get((String)"fmlmodcontainer.7", (Object[])new Object[]{this.getModId(), this.modClass.getName()}), e);
            throw new ModLoadingException(this.modInfo, ModLoadingStage.CONSTRUCT, "fml.modloading.failedtoloadmod", e, this.modClass);
        }
    }

    @Override
    public boolean matches(Object mod) {
        return mod == this.modInstance;
    }

    @Override
    public Object getMod() {
        return this.modInstance;
    }

    public IEventBus getEventBus() {
        return this.eventBus;
    }

    @Override
    protected <T extends Event> void acceptEvent(T e) {
        try {
            LOGGER.debug(Logging.LOADING, i18n.get((String)"fmlmodcontainer.8", (Object[])new Object[]{this.getModId(), e}));
            this.eventBus.post(e);
            LOGGER.debug(Logging.LOADING, i18n.get((String)"fmlmodcontainer.9", (Object[])new Object[]{this.getModId(), e}));
        }
        catch (Throwable t) {
            LOGGER.error(Logging.LOADING, i18n.get((String)"fmlmodcontainer.10", (Object[])new Object[]{e, this.getModId()}), t);
            throw new ModLoadingException(this.modInfo, this.modLoadingStage, "fml.modloading.errorduringevent", t, new Object[0]);
        }
    }
}

