/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.network;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkDirection;

public class PacketDistributor<T> {
    public static final PacketDistributor<ServerPlayerEntity> PLAYER = new PacketDistributor(PacketDistributor::playerConsumer, NetworkDirection.PLAY_TO_CLIENT);
    public static final PacketDistributor<RegistryKey<World>> DIMENSION = new PacketDistributor(PacketDistributor::playerListDimConsumer, NetworkDirection.PLAY_TO_CLIENT);
    public static final PacketDistributor<TargetPoint> NEAR = new PacketDistributor(PacketDistributor::playerListPointConsumer, NetworkDirection.PLAY_TO_CLIENT);
    public static final PacketDistributor<Void> ALL = new PacketDistributor(PacketDistributor::playerListAll, NetworkDirection.PLAY_TO_CLIENT);
    public static final PacketDistributor<Void> SERVER = new PacketDistributor(PacketDistributor::clientToServer, NetworkDirection.PLAY_TO_SERVER);
    public static final PacketDistributor<Entity> TRACKING_ENTITY = new PacketDistributor(PacketDistributor::trackingEntity, NetworkDirection.PLAY_TO_CLIENT);
    public static final PacketDistributor<Entity> TRACKING_ENTITY_AND_SELF = new PacketDistributor(PacketDistributor::trackingEntityAndSelf, NetworkDirection.PLAY_TO_CLIENT);
    public static final PacketDistributor<Chunk> TRACKING_CHUNK = new PacketDistributor(PacketDistributor::trackingChunk, NetworkDirection.PLAY_TO_CLIENT);
    public static final PacketDistributor<List<NetworkManager>> NMLIST = new PacketDistributor(PacketDistributor::networkManagerList, NetworkDirection.PLAY_TO_CLIENT);
    private final BiFunction<PacketDistributor<T>, Supplier<T>, Consumer<IPacket<?>>> functor;
    private final NetworkDirection direction;

    public PacketDistributor(BiFunction<PacketDistributor<T>, Supplier<T>, Consumer<IPacket<?>>> functor, NetworkDirection direction) {
        this.functor = functor;
        this.direction = direction;
    }

    public PacketTarget with(Supplier<T> input) {
        return new PacketTarget(this.functor.apply(this, input), this);
    }

    public PacketTarget noArg() {
        return new PacketTarget(this.functor.apply(this, () -> null), this);
    }

    private Consumer<IPacket<?>> playerConsumer(Supplier<ServerPlayerEntity> entityPlayerMPSupplier) {
        return p -> {
            ServerPlayerEntity player = (ServerPlayerEntity)entityPlayerMPSupplier.get();
            if (player.field_71135_a != null && player.field_71135_a.field_147371_a != null) {
                player.field_71135_a.field_147371_a.func_179290_a(p);
            }
        };
    }

    private Consumer<IPacket<?>> playerListDimConsumer(Supplier<RegistryKey<World>> dimensionTypeSupplier) {
        return p -> this.getServer().func_184103_al().func_232642_a_(p, (RegistryKey)dimensionTypeSupplier.get());
    }

    private Consumer<IPacket<?>> playerListAll(Supplier<Void> voidSupplier) {
        return p -> this.getServer().func_184103_al().func_148540_a(p);
    }

    private Consumer<IPacket<?>> clientToServer(Supplier<Void> voidSupplier) {
        return p -> Minecraft.func_71410_x().func_147114_u().func_147297_a(p);
    }

    private Consumer<IPacket<?>> playerListPointConsumer(Supplier<TargetPoint> targetPointSupplier) {
        return p -> {
            TargetPoint tp = (TargetPoint)targetPointSupplier.get();
            this.getServer().func_184103_al().func_148543_a((PlayerEntity)tp.excluded, tp.x, tp.y, tp.z, tp.r2, tp.dim, p);
        };
    }

    private Consumer<IPacket<?>> trackingEntity(Supplier<Entity> entitySupplier) {
        return p -> {
            Entity entity = (Entity)entitySupplier.get();
            ((ServerChunkProvider)entity.func_130014_f_().func_72863_F()).func_217218_b(entity, p);
        };
    }

    private Consumer<IPacket<?>> trackingEntityAndSelf(Supplier<Entity> entitySupplier) {
        return p -> {
            Entity entity = (Entity)entitySupplier.get();
            ((ServerChunkProvider)entity.func_130014_f_().func_72863_F()).func_217216_a(entity, p);
        };
    }

    private Consumer<IPacket<?>> trackingChunk(Supplier<Chunk> chunkPosSupplier) {
        return p -> {
            Chunk chunk = (Chunk)chunkPosSupplier.get();
            ((ServerChunkProvider)chunk.func_177412_p().func_72863_F()).field_217237_a.func_219097_a(chunk.func_76632_l(), false).forEach(e -> e.field_71135_a.func_147359_a(p));
        };
    }

    private Consumer<IPacket<?>> networkManagerList(Supplier<List<NetworkManager>> nmListSupplier) {
        return p -> ((List)nmListSupplier.get()).forEach(nm -> nm.func_179290_a(p));
    }

    private MinecraftServer getServer() {
        return (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
    }

    public static class PacketTarget {
        private final Consumer<IPacket<?>> packetConsumer;
        private final PacketDistributor<?> distributor;

        PacketTarget(Consumer<IPacket<?>> packetConsumer, PacketDistributor<?> distributor) {
            this.packetConsumer = packetConsumer;
            this.distributor = distributor;
        }

        public void send(IPacket<?> packet) {
            this.packetConsumer.accept(packet);
        }

        public NetworkDirection getDirection() {
            return ((PacketDistributor)this.distributor).direction;
        }
    }

    public static final class TargetPoint {
        private final ServerPlayerEntity excluded;
        private final double x;
        private final double y;
        private final double z;
        private final double r2;
        private final RegistryKey<World> dim;

        public TargetPoint(ServerPlayerEntity excluded, double x, double y, double z, double r2, RegistryKey<World> dim) {
            this.excluded = excluded;
            this.x = x;
            this.y = y;
            this.z = z;
            this.r2 = r2;
            this.dim = dim;
        }

        public TargetPoint(double x, double y, double z, double r2, RegistryKey<World> dim) {
            this.excluded = null;
            this.x = x;
            this.y = y;
            this.z = z;
            this.r2 = r2;
            this.dim = dim;
        }

        public static Supplier<TargetPoint> p(double x, double y, double z, double r2, RegistryKey<World> dim) {
            TargetPoint tp = new TargetPoint(x, y, z, r2, dim);
            return () -> tp;
        }
    }
}

