/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TranslationTextComponent;

public class EnumArgument<T extends Enum<T>>
implements ArgumentType<T> {
    private static final Dynamic2CommandExceptionType INVALID_ENUM = new Dynamic2CommandExceptionType((found, constants) -> new TranslationTextComponent("commands.forge.arguments.enum.invalid", new Object[]{constants, found}));
    private final Class<T> enumClass;

    public static <R extends Enum<R>> EnumArgument<R> enumArgument(Class<R> enumClass) {
        return new EnumArgument<R>(enumClass);
    }

    private EnumArgument(Class<T> enumClass) {
        this.enumClass = enumClass;
    }

    public T parse(StringReader reader) throws CommandSyntaxException {
        String name = reader.readUnquotedString();
        try {
            return Enum.valueOf(this.enumClass, name);
        }
        catch (IllegalArgumentException e) {
            throw INVALID_ENUM.createWithContext((ImmutableStringReader)reader, (Object)name, (Object)Arrays.toString(this.enumClass.getEnumConstants()));
        }
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return ISuggestionProvider.func_197013_a(Stream.of((Enum[])this.enumClass.getEnumConstants()).map(Object::toString), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return Stream.of((Enum[])this.enumClass.getEnumConstants()).map(Object::toString).collect(Collectors.toList());
    }

    public static class Serializer
    implements IArgumentSerializer<EnumArgument<?>> {
        public void serializeToNetwork(EnumArgument<?> argument, PacketBuffer buffer) {
            buffer.func_180714_a(((EnumArgument)argument).enumClass.getName());
        }

        public EnumArgument<?> deserializeFromNetwork(PacketBuffer buffer) {
            try {
                String name = buffer.func_218666_n();
                return new EnumArgument(Class.forName(name));
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        public void serializeToJson(EnumArgument<?> argument, JsonObject json) {
            json.addProperty("enum", ((EnumArgument)argument).enumClass.getName());
        }
    }
}

