/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mohistmc.forge.ForgeInjectBukkit;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.bukkit.Art;

public class CraftArt {
    private static final BiMap<PaintingType, Art> artwork;

    public static Art NotchToBukkit(PaintingType art) {
        Art bukkit = (Art)artwork.get((Object)art);
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit;
    }

    public static PaintingType BukkitToNotch(Art art) {
        PaintingType nms = (PaintingType)artwork.inverse().get((Object)art);
        Preconditions.checkArgument((nms != null ? 1 : 0) != 0);
        return nms;
    }

    static {
        ImmutableBiMap.Builder artworkBuilder = ImmutableBiMap.builder();
        for (ResourceLocation key : Registry.field_212620_i.func_148742_b()) {
            if (key.func_110624_b().equals("minecraft")) {
                artworkBuilder.put((Object)((PaintingType)Registry.field_212620_i.func_82594_a(key)), (Object)Art.getByName(key.func_110623_a()));
                continue;
            }
            ForgeInjectBukkit.artMap.forEach((arg_0, arg_1) -> ((ImmutableBiMap.Builder)artworkBuilder).put(arg_0, arg_1));
        }
        artwork = artworkBuilder.build();
    }
}

